/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.TableViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.specify.datamodel.Gift;
import edu.ku.brc.specify.datamodel.GiftPreparation;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class GiftPreparationBusRules
extends BaseBusRules
implements CommandListener {
    public GiftPreparationBusRules() {
        super(GiftPreparation.class);
        CommandDispatcher.register("Interactions", this);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        JButton newBtn = this.getNewBtn();
        if (newBtn != null) {
            ActionListener[] actionListenerArray = newBtn.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener al = actionListenerArray[n2];
                newBtn.removeActionListener(al);
                ++n2;
            }
            newBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultiView giftMV = null;
                    if (GiftPreparationBusRules.this.viewable instanceof FormViewObj) {
                        giftMV = GiftPreparationBusRules.this.formViewObj.getMVParent().getMultiViewParent();
                        GiftPreparationBusRules.this.formViewObj.getDataFromUI();
                    } else if (GiftPreparationBusRules.this.viewable instanceof TableViewObj) {
                        TableViewObj tblViewObj = (TableViewObj)GiftPreparationBusRules.this.viewable;
                        giftMV = tblViewObj.getMVParent().getMultiViewParent();
                    }
                    if (giftMV != null) {
                        if (GiftPreparationBusRules.this.formViewObj != null) {
                            GiftPreparationBusRules.this.formViewObj.getDataFromUI();
                        }
                        CommandDispatcher.dispatch(new CommandAction("Interactions", "AddToGift", giftMV.getCurrentViewAsFormViewObj().getCurrentDataObj()));
                    }
                }
            });
        }
    }

    @Override
    public void afterFillForm(Object dataObj) {
        Component comp = this.formViewObj.getControlByName("quantity");
        if (comp instanceof ValSpinner && dataObj != null) {
            GiftPreparation giftPrep = (GiftPreparation)dataObj;
            ValSpinner quantity = (ValSpinner)comp;
            if (quantity != null) {
                quantity.setRange(0, giftPrep.getQuantity(), giftPrep.getQuantity());
            }
        }
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        CommandDispatcher.unregister("Interactions", this);
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType("Interactions") && cmdAction.isAction("REFRESH_GIFT_PREPS")) {
            if (this.formViewObj != null) {
                MultiView giftMV = this.formViewObj.getMVParent().getMultiViewParent();
                if (giftMV != null && this.formViewObj.getValidator() != null) {
                    Gift gift = (Gift)giftMV.getData();
                    this.formViewObj.setDataObj(gift.getGiftPreparations());
                    this.formViewObj.getValidator().setHasChanged(true);
                    this.formViewObj.getValidator().validateRoot();
                }
            } else if (this.viewable instanceof TableViewObj) {
                TableViewObj tvo = (TableViewObj)this.viewable;
                MultiView giftMV = tvo.getMVParent().getMultiViewParent();
                giftMV.getCurrentValidator().setHasChanged(true);
                giftMV.getCurrentValidator().validateRoot();
                tvo.refreshDataList();
            }
        }
    }
}

