/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Gift;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.Shipment;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import javax.swing.JCheckBox;

public class GiftBusRules
extends AttachmentOwnerBaseBusRules {
    public static final String CMDTYPE = "Interactions";
    public final String NEW_GIFT = "NEW_GIFT";

    public GiftBusRules() {
        super(GiftBusRules.class);
    }

    @Override
    public void afterFillForm(Object dataObj) {
        if (this.formViewObj != null && this.formViewObj.getDataObj() instanceof Gift) {
            this.formViewObj.setSkippingAttach(true);
            MultiView mvParent = this.formViewObj.getMVParent();
            boolean isEdit = mvParent.isEditable();
            Component comp = this.formViewObj.getControlByName("generateInvoice");
            if (comp instanceof JCheckBox) {
                ((JCheckBox)comp).setVisible(isEdit);
            }
        }
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        return true;
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        Gift gift = (Gift)dataObj;
        for (Shipment shipment : gift.getShipments()) {
            shipment.getShipmentId();
        }
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (!(dataObj instanceof Gift)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS duplicateNumberStatus = this.isCheckDuplicateNumberOK("giftNumber", (FormDataObjIFace)dataObj, Gift.class, "giftId");
        return duplicateNumberStatus;
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        if (dataObj instanceof Accession) {
            return UIRegistry.getLocalizedMessage("LOAN_DELETED", ((Gift)dataObj).getGiftNumber());
        }
        return super.getDeleteMsg(dataObj);
    }

    @Override
    public void setObjectIdentity(Object dataObj, DraggableRecordIdentifier draggableIcon) {
        if (dataObj == null) {
            draggableIcon.setLabel("");
        }
        if (dataObj instanceof Gift) {
            Gift gift = (Gift)dataObj;
            draggableIcon.setLabel(gift.getGiftNumber());
            Object data = draggableIcon.getData();
            if (data == null) {
                RecordSet rs = new RecordSet();
                rs.initialize();
                rs.addItem(gift.getGiftId());
                data = rs;
                draggableIcon.setData(data);
            } else if (data instanceof RecordSetIFace) {
                RecordSetIFace rs = (RecordSetIFace)data;
                rs.clearItems();
                rs.addItem(gift.getGiftId());
            }
        }
    }

    @Override
    public boolean canCreateNewDataObject() {
        return true;
    }

    @Override
    public void createNewObj(boolean doSetIntoAndValidateArg, Object oldDataObj) {
        CommandAction cmdAction = new CommandAction(CMDTYPE, "NEW_GIFT", this.viewable);
        CommandDispatcher.dispatch(cmdAction);
    }
}

