/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.specify.datamodel.busrules.BaseTreeBusRules;
import edu.ku.brc.specify.tasks.TreeTaskMgr;
import edu.ku.brc.ui.UIRegistry;

public class GeographyBusRules
extends BaseTreeBusRules<Geography, GeographyTreeDef, GeographyTreeDefItem> {
    protected static final String PARENT = "parent";
    protected static final String RANK = "definitionItem";

    public GeographyBusRules() {
        super(Geography.class, GeographyTreeDefItem.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        TreeTaskMgr.checkLocks();
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        return UIRegistry.getLocalizedMessage("GEOGRAPHY_DELETED", ((Geography)dataObj).getName());
    }

    @Override
    public String[] getRelatedTableAndColumnNames() {
        String[] relationships = new String[]{"locality", "GeographyID", "geography", "AcceptedID"};
        return relationships;
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        this.reasonList.clear();
        if (dataObj instanceof Geography) {
            return super.okToDeleteNode((Geography)dataObj);
        }
        if (dataObj instanceof GeographyTreeDefItem) {
            return this.okToDeleteDefItem((GeographyTreeDefItem)dataObj);
        }
        return false;
    }

    public boolean okToDeleteDefItem(GeographyTreeDefItem defItem) {
        if (defItem.getRankId() == 0) {
            return false;
        }
        return this.okToDelete("geography", "GeographyTreeDefItemID", defItem.getId());
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        if (dataObj instanceof Geography) {
            Geography geo = (Geography)dataObj;
            this.beforeSaveGeography(geo);
            super.updateFullNamesIfNecessary(geo, session);
            return;
        }
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        this.setLSID((FormDataObjIFace)dataObj);
        return super.afterSaveCommit(dataObj, session);
    }

    protected void beforeSaveGeography(Geography geo) {
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        TreeTaskMgr.checkLocks();
    }

    @Override
    protected Class<?> getNodeClass() {
        return Geography.class;
    }
}

