/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.CollectingTrip;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.FundingAgent;
import edu.ku.brc.ui.UIRegistry;
import java.util.Hashtable;

public class FundingAgentBusRules
extends BaseBusRules {
    public FundingAgentBusRules() {
        super(FundingAgent.class);
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object parentDataObj, Object dataObj, boolean isExistingObject) {
        this.reasonList.clear();
        if (isExistingObject && parentDataObj instanceof CollectingTrip && dataObj instanceof FundingAgent) {
            CollectingTrip ce = (CollectingTrip)parentDataObj;
            FundingAgent col = (FundingAgent)dataObj;
            Hashtable<Integer, Boolean> hash = new Hashtable<Integer, Boolean>();
            for (FundingAgent fundingAgent : ce.getFundingAgents()) {
                Integer id = fundingAgent.getAgent().getAgentId();
                boolean isBad = false;
                if (hash.get(id) == null) {
                    if (fundingAgent.getId() != null && id.equals(col.getAgent().getAgentId())) {
                        isBad = true;
                    }
                    hash.put(id, true);
                } else {
                    isBad = true;
                }
                if (!isBad) continue;
                this.reasonList.add(String.format(UIRegistry.getResourceString("CT_DUPLICATE_FUNDINGAGENTS"), col.getIdentityTitle()));
                return BusinessRulesIFace.STATUS.Error;
            }
        }
        return super.processBusinessRules(parentDataObj, dataObj, isExistingObject);
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        super.beforeMerge(dataObj, session);
        FundingAgent fundingAgent = (FundingAgent)dataObj;
        if (fundingAgent.getDivision() == null) {
            fundingAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        }
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        FundingAgent fundingAgent = (FundingAgent)dataObj;
        if (fundingAgent.getDivision() == null) {
            fundingAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        }
    }
}

