/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizard;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.dbsupport.HibernateDataProviderSession;
import edu.ku.brc.specify.dbsupport.SpecifyDeleteHelper;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.hibernate.Session;

public class DivisionBusRules
extends BaseBusRules
implements CommandListener {
    private static final String CMD_TYPE = "DivisionBusRules";
    private static final String PROGRESS = "progress";
    private boolean isOKToCont = false;

    public DivisionBusRules() {
        super(Institution.class);
        CommandDispatcher.register(CMD_TYPE, this);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        ResultSetController rsc;
        super.initialize(viewableArg);
        if (this.formViewObj != null && this.formViewObj.getMVParent().isTopLevel() && (rsc = this.formViewObj.getRsController()) != null) {
            if (rsc.getNewRecBtn() != null) {
                rsc.getNewRecBtn().setVisible(false);
            }
            if (rsc.getDelRecBtn() != null) {
                rsc.getDelRecBtn().setVisible(false);
            }
        }
        if (this.formViewObj != null) {
            JButton newBtn;
            if (this.formViewObj.getMVParent().isTopLevel() && (rsc = this.formViewObj.getRsController()) != null) {
                if (rsc.getNewRecBtn() != null) {
                    rsc.getNewRecBtn().setVisible(false);
                }
                if (rsc.getDelRecBtn() != null) {
                    rsc.getDelRecBtn().setVisible(false);
                }
            }
            if (this.formViewObj.getRsController() != null && (newBtn = this.formViewObj.getRsController().getNewRecBtn()) != null) {
                ActionListener[] actionListenerArray = newBtn.getActionListeners();
                int n = actionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionListener al = actionListenerArray[n2];
                    newBtn.removeActionListener(al);
                    ++n2;
                }
                newBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DivisionBusRules.this.addNewDivision();
                    }
                });
            }
        }
    }

    @Override
    public void beforeFormFill() {
        super.beforeFormFill();
        if (this.formViewObj != null && this.formViewObj.getDataObj() != null && this.formViewObj.getMVParent().isTopLevel()) {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    Division div = (Division)this.formViewObj.getDataObj();
                    session.attach(div);
                    for (Discipline disp : div.getDisciplines()) {
                        disp.getCollections().size();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    public static boolean askForExitonChange(String messageKey) {
        int userChoice = 1;
        Object[] options = new Object[]{UIRegistry.getResourceString("Continue"), UIRegistry.getResourceString("CANCEL")};
        userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString(messageKey), UIRegistry.getResourceString("EXIT_REQ_TITLE"), 0, 3, null, options, options[0]);
        return userChoice == 0;
    }

    private int getNameCount(String name) {
        return BasicSQLUtils.getCountAsInt(String.format("SELECT COUNT(*) FROM division WHERE Name = '%s'", name));
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        Component comp;
        if (this.formViewObj != null && (comp = this.formViewObj.getControlByName("name")) instanceof ValTextField) {
            Division division = (Division)this.formViewObj.getDataObj();
            Integer divId = division.getId();
            String name = ((ValTextField)comp).getText();
            int cnt = this.getNameCount(name);
            if (cnt == 0 || cnt == 1 && divId != null) {
                return true;
            }
            this.reasonList.add(UIRegistry.getLocalizedMessage("DIVNAME_DUP", name));
        }
        return false;
    }

    public static boolean checkForParentSave(FormViewObj formViewObj, int tblId) {
        MultiView mv;
        if (formViewObj != null && formViewObj.getMVParent() != null && (mv = formViewObj.getMVParent()).getTopLevel() != null) {
            if (mv.getTopLevel().getCurrentValidator().hasChanged()) {
                UIRegistry.showLocalizedError(2, "TOP_MV_SAVE", DBTableIdMgr.getInstance().getTitleForId(Institution.getClassTableId()));
                return false;
            }
            return true;
        }
        return false;
    }

    private void addNewDivision() {
        if (!DivisionBusRules.checkForParentSave(this.formViewObj, Institution.getClassTableId())) {
            return;
        }
        if (!DivisionBusRules.askForExitonChange("ASK_TO_ADD_DIV")) {
            return;
        }
        UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getResourceString("BUILD_DIV"), 20);
        this.isOKToCont = true;
        final AppContextMgr acm = AppContextMgr.getInstance();
        UIRegistry.loadAndPushResourceBundle("specifydbsetupwiz");
        final SpecifyDBSetupWizard wizardPanel = new SpecifyDBSetupWizard(SpecifyDBSetupWizard.WizardType.Division, null);
        String bldTitle = UIRegistry.getResourceString("CREATEDIV");
        final CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), "", true, 0, (Component)wizardPanel);
        dlg.setCustomTitleBar(bldTitle);
        wizardPanel.setListener(new SpecifyDBSetupWizard.WizardListener(){

            @Override
            public void cancelled() {
                DivisionBusRules.this.isOKToCont = false;
                dlg.setVisible(false);
            }

            @Override
            public void finished() {
                dlg.setVisible(false);
            }

            @Override
            public void hide() {
                dlg.setVisible(false);
            }

            @Override
            public void panelChanged(String title) {
                dlg.setTitle(title);
            }
        });
        UIHelper.centerAndShow(dlg);
        UIRegistry.popResourceBundle();
        if (!this.isOKToCont) {
            UIRegistry.clearSimpleGlassPaneMsg();
            return;
        }
        wizardPanel.processDataForNonBuild();
        final BuildSampleDatabase bldSampleDB = new BuildSampleDatabase();
        final ProgressFrame progressFrame = bldSampleDB.createProgressFrame(bldTitle);
        progressFrame.turnOffOverAll();
        progressFrame.setProcess(0, 17);
        progressFrame.setProcessPercent(true);
        progressFrame.getCloseBtn().setVisible(false);
        progressFrame.setAlwaysOnTop(true);
        progressFrame.adjustProgressFrame();
        UIHelper.centerAndShow(progressFrame);
        SwingWorker<Integer, Integer> bldWorker = new SwingWorker<Integer, Integer>(){
            private int steps = 0;
            private Division newDivision = null;

            @Override
            protected Integer doInBackground() throws Exception {
                block8: {
                    this.firePropertyChange(DivisionBusRules.PROGRESS, 0, ++this.steps);
                    bldSampleDB.setDataType(acm.getClassObject(DataType.class));
                    Division curDivCached = acm.getClassObject(Division.class);
                    Discipline curDispCached = acm.getClassObject(Discipline.class);
                    Collection curCollCached = acm.getClassObject(Collection.class);
                    acm.setClassObject(Division.class, null);
                    acm.setClassObject(Discipline.class, null);
                    acm.setClassObject(Collection.class, null);
                    Session session = null;
                    try {
                        try {
                            session = HibernateUtil.getNewSession();
                            HibernateDataProviderSession hSession = new HibernateDataProviderSession(session);
                            Institution inst = (Institution)DivisionBusRules.this.formViewObj.getMVParent().getMultiViewParent().getData();
                            Institution institution = hSession.get(Institution.class, inst.getId());
                            SpecifyUser specifyAdminUser = acm.getClassObject(SpecifyUser.class);
                            Properties props = wizardPanel.getProps();
                            institution = (Institution)session.merge((Object)institution);
                            specifyAdminUser = (SpecifyUser)hSession.getData("FROM SpecifyUser WHERE id = " + specifyAdminUser.getId());
                            bldSampleDB.setSession(session);
                            DisciplineType dispType = (DisciplineType)props.get("disciplineType");
                            this.newDivision = bldSampleDB.createEmptyDivision(institution, dispType, specifyAdminUser, props, true, false, true);
                            acm.setClassObject(Division.class, curDivCached);
                            acm.setClassObject(Discipline.class, curDispCached);
                            acm.setClassObject(Collection.class, curCollCached);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (session != null) {
                                session.close();
                            }
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                    if (session != null) {
                        session.close();
                    }
                }
                bldSampleDB.setDataType(null);
                return null;
            }

            @Override
            protected void done() {
                block11: {
                    super.done();
                    progressFrame.setVisible(false);
                    progressFrame.dispose();
                    if (this.newDivision != null) {
                        List<?> dataItems = null;
                        FormViewObj instFVO = DivisionBusRules.this.formViewObj.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
                        Institution inst = (Institution)instFVO.getDataObj();
                        DataProviderSessionIFace pSession = null;
                        try {
                            try {
                                pSession = DataProviderFactory.getInstance().createSession();
                                inst = (Institution)pSession.getData("FROM Institution WHERE id = " + inst.getId());
                                inst.forceLoad();
                                acm.setClassObject(Institution.class, inst);
                                dataItems = pSession.getDataList("FROM Institution");
                                if (dataItems.get(0) instanceof Object[]) {
                                    Vector dataList = new Vector();
                                    for (Object row : dataItems) {
                                        Object[] cols = (Object[])row;
                                        Institution div = (Institution)cols[0];
                                        div.forceLoad();
                                        dataList.add(div);
                                    }
                                    dataItems = dataList;
                                }
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                                ex.printStackTrace();
                                if (pSession != null) {
                                    pSession.close();
                                }
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            if (pSession != null) {
                                pSession.close();
                            }
                            throw throwable;
                        }
                        if (pSession != null) {
                            pSession.close();
                        }
                    }
                }
                UIRegistry.clearSimpleGlassPaneMsg();
                UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
                CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
            }
        };
        bldWorker.execute();
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        return true;
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (!(dataObj instanceof Division)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS nameStatus = this.isCheckDuplicateNumberOK("name", (FormDataObjIFace)dataObj, Division.class, "userGroupScopeId");
        return nameStatus != BusinessRulesIFace.STATUS.OK ? BusinessRulesIFace.STATUS.Error : BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public void okToDelete(Object dataObj, DataProviderSessionIFace session, BusinessRulesOkDeleteIFace deletable) {
        this.reasonList.clear();
        if (deletable != null) {
            Division division = (Division)dataObj;
            Integer id = division.getId();
            if (id != null) {
                boolean cont = false;
                Division currDiv = AppContextMgr.getInstance().getClassObject(Division.class);
                if (currDiv.getId().equals(division.getId())) {
                    UIRegistry.showError("You cannot delete the current Division.");
                } else {
                    String sql = "SELECT count(*) FROM agent WHERE DivisionID = " + division.getId();
                    int count = BasicSQLUtils.getCount(sql);
                    if (count > 0) {
                        String msg = String.format("There are too many agents associated with this the `%s` Division.\nDo you wish to delete them?", division.getName());
                        if (UIRegistry.askYesNoLocalized("DELETE", "CANCEL", msg, "DELETE") == 0) {
                            cont = true;
                        }
                    } else {
                        cont = true;
                    }
                }
                if (cont) {
                    final Integer divId = division.getId();
                    final SpecifyDeleteHelper delHelper = new SpecifyDeleteHelper();
                    SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){

                        @Override
                        protected Integer doInBackground() throws Exception {
                            try {
                                delHelper.delRecordFromTable(Division.class, divId, true);
                                delHelper.done(false);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(DivisionBusRules.class, ex);
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            super.done();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (DivisionBusRules.this.formViewObj != null) {
                                        DivisionBusRules.this.formViewObj.updateAfterRemove(true);
                                    }
                                    UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
                                    CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
                                }
                            });
                        }
                    };
                    String title = String.format("%s %s", UIRegistry.getResourceString("DELETING"), DBTableIdMgr.getInstance().getTitleForId(Division.getClassTableId()));
                    JDialog dlg = delHelper.initProgress(worker, title);
                    worker.execute();
                    UIHelper.centerAndShow(dlg);
                }
            } else {
                super.okToDelete(dataObj, session, deletable);
            }
        } else {
            super.okToDelete(dataObj, session, deletable);
        }
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        AppContextMgr.getInstance().setClassObject(Division.class, dataObj);
        return super.afterSaveCommit(dataObj, session);
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isAction("DivisionSaved")) {
            Division division = (Division)cmdAction.getData();
            this.formViewObj.getMVParent().getMultiViewParent().setData(division);
        } else {
            cmdAction.isAction("DivisionError");
        }
    }
}

