/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.TextFieldFromPickListTable;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizard;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.busrules.DivisionBusRules;
import edu.ku.brc.specify.dbsupport.HibernateDataProviderSession;
import edu.ku.brc.specify.dbsupport.SpecifyDeleteHelper;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.hibernate.Session;

public class DisciplineBusRules
extends BaseBusRules
implements CommandListener {
    private static final String CMD_TYPE = "DisciplineBusRules";
    private static final String PROGRESS = "progress";
    private boolean isOKToCont = false;

    public DisciplineBusRules() {
        super(Discipline.class);
        CommandDispatcher.register(CMD_TYPE, this);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        if (this.formViewObj != null) {
            Component comp;
            JButton newBtn;
            ResultSetController rsc;
            if (this.formViewObj.getMVParent().isTopLevel() && (rsc = this.formViewObj.getRsController()) != null) {
                if (rsc.getNewRecBtn() != null) {
                    rsc.getNewRecBtn().setVisible(false);
                }
                if (rsc.getDelRecBtn() != null) {
                    rsc.getDelRecBtn().setVisible(false);
                }
            }
            if (this.formViewObj.getRsController() != null && (newBtn = this.formViewObj.getRsController().getNewRecBtn()) != null) {
                ActionListener[] actionListenerArray = newBtn.getActionListeners();
                int n = actionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionListener al = actionListenerArray[n2];
                    newBtn.removeActionListener(al);
                    ++n2;
                }
                newBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DisciplineBusRules.this.addNewDiscipline();
                    }
                });
            }
            if ((comp = this.formViewObj.getControlByName("type")) instanceof ValComboBox) {
                final ValComboBox dspCbx = (ValComboBox)comp;
                for (DisciplineType dt : DisciplineType.getDisciplineList()) {
                    dspCbx.getComboBox().addItem(dt);
                }
                dspCbx.getComboBox().setSelectedIndex(-1);
                dspCbx.getComboBox().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DisciplineType dt = (DisciplineType)dspCbx.getComboBox().getSelectedItem();
                        if (dt != null) {
                            ((Discipline)DisciplineBusRules.this.formViewObj.getDataObj()).setType(dt.getName());
                        }
                    }
                });
            }
        }
    }

    private int getNameCount(String name) {
        return BasicSQLUtils.getCountAsInt(String.format("SELECT COUNT(*) FROM discipline WHERE Name = '%s'", name));
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        Component comp;
        this.reasonList.clear();
        if (this.formViewObj != null && (comp = this.formViewObj.getControlByName("name")) instanceof ValTextField) {
            Discipline discipline = (Discipline)this.formViewObj.getDataObj();
            Integer dspId = discipline.getId();
            String name = ((ValTextField)comp).getText();
            int cnt = this.getNameCount(name);
            if (cnt == 0 || cnt == 1 && dspId != null) {
                return true;
            }
            this.reasonList.add(UIRegistry.getLocalizedMessage("DISPNAME_DUP", name));
        }
        return false;
    }

    private void addNewDiscipline() {
        if (!DivisionBusRules.checkForParentSave(this.formViewObj, Division.getClassTableId())) {
            return;
        }
        if (!DivisionBusRules.askForExitonChange("ASK_TO_ADD_DISP")) {
            return;
        }
        UIRegistry.loadAndPushResourceBundle("specifydbsetupwiz");
        UIRegistry.writeSimpleGlassPaneMsg("Building Discipline...", 20);
        this.isOKToCont = true;
        final AppContextMgr acm = AppContextMgr.getInstance();
        final SpecifyDBSetupWizard wizardPanel = new SpecifyDBSetupWizard(SpecifyDBSetupWizard.WizardType.Discipline, null);
        final CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), "", true, 0, (Component)wizardPanel);
        dlg.setCustomTitleBar(UIRegistry.getResourceString("CREATEDISP"));
        wizardPanel.setListener(new SpecifyDBSetupWizard.WizardListener(){

            @Override
            public void cancelled() {
                DisciplineBusRules.this.isOKToCont = false;
                dlg.setVisible(false);
            }

            @Override
            public void finished() {
                dlg.setVisible(false);
            }

            @Override
            public void hide() {
                dlg.setVisible(false);
            }

            @Override
            public void panelChanged(String title) {
                dlg.setTitle(title);
            }
        });
        UIHelper.centerAndShow(dlg);
        UIRegistry.popResourceBundle();
        if (!this.isOKToCont) {
            UIRegistry.clearSimpleGlassPaneMsg();
            return;
        }
        wizardPanel.processDataForNonBuild();
        final BuildSampleDatabase bldSampleDB = new BuildSampleDatabase();
        final ProgressFrame progressFrame = bldSampleDB.createProgressFrame("Creating Disicipline");
        progressFrame.turnOffOverAll();
        progressFrame.setProcess(0, 17);
        progressFrame.setProcessPercent(true);
        progressFrame.getCloseBtn().setVisible(false);
        progressFrame.setAlwaysOnTop(true);
        progressFrame.adjustProgressFrame();
        UIHelper.centerAndShow(progressFrame);
        SwingWorker<Integer, Integer> bldWorker = new SwingWorker<Integer, Integer>(){
            private int steps = 0;
            Pair<Discipline, Collection> pair = null;

            @Override
            protected Integer doInBackground() throws Exception {
                block9: {
                    this.firePropertyChange(DisciplineBusRules.PROGRESS, 0, ++this.steps);
                    bldSampleDB.setDataType(acm.getClassObject(DataType.class));
                    Division curDivCached = acm.getClassObject(Division.class);
                    Discipline curDispCached = acm.getClassObject(Discipline.class);
                    Collection curCollCached = acm.getClassObject(Collection.class);
                    acm.setClassObject(Division.class, null);
                    acm.setClassObject(Discipline.class, null);
                    acm.setClassObject(Collection.class, null);
                    Session session = null;
                    try {
                        try {
                            session = HibernateUtil.getNewSession();
                            HibernateDataProviderSession hSession = new HibernateDataProviderSession(session);
                            Division curDiv = (Division)DisciplineBusRules.this.formViewObj.getMVParent().getMultiViewParent().getData();
                            Division division = hSession.get(Division.class, curDiv.getId());
                            SpecifyUser specifyAdminUser = acm.getClassObject(SpecifyUser.class);
                            Agent userAgent = (Agent)hSession.getData("FROM Agent WHERE id = " + Agent.getUserAgent().getId());
                            Properties props = wizardPanel.getProps();
                            DisciplineType dispType = (DisciplineType)props.get("disciplineType");
                            division = (Division)session.merge((Object)division);
                            specifyAdminUser = (SpecifyUser)hSession.getData("FROM SpecifyUser WHERE id = " + specifyAdminUser.getId());
                            bldSampleDB.setSession(session);
                            this.pair = bldSampleDB.createEmptyDisciplineAndCollection(division, props, dispType, userAgent, specifyAdminUser, true, true);
                            if (this.pair != null && this.pair.first != null && this.pair.second != null) {
                                acm.setClassObject(SpecifyUser.class, specifyAdminUser);
                                Agent.setUserAgent(userAgent);
                            }
                            acm.setClassObject(Division.class, curDivCached);
                            acm.setClassObject(Discipline.class, curDispCached);
                            acm.setClassObject(Collection.class, curCollCached);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (session != null) {
                                session.close();
                            }
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                    if (session != null) {
                        session.close();
                    }
                }
                bldSampleDB.setDataType(null);
                return null;
            }

            @Override
            protected void done() {
                block11: {
                    super.done();
                    progressFrame.setVisible(false);
                    progressFrame.dispose();
                    if (this.pair != null && this.pair.first != null && this.pair.second != null) {
                        List<?> dataItems = null;
                        FormViewObj divFVO = DisciplineBusRules.this.formViewObj.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
                        Division division = (Division)divFVO.getDataObj();
                        DataProviderSessionIFace pSession = null;
                        try {
                            try {
                                pSession = DataProviderFactory.getInstance().createSession();
                                division = (Division)pSession.getData("FROM Division WHERE id = " + division.getId());
                                division.forceLoad();
                                acm.setClassObject(Division.class, division);
                                dataItems = pSession.getDataList("FROM Division");
                                if (dataItems.get(0) instanceof Object[]) {
                                    Vector dataList = new Vector();
                                    for (Object row : dataItems) {
                                        Object[] cols = (Object[])row;
                                        Division div = (Division)cols[0];
                                        div.forceLoad();
                                        dataList.add(div);
                                    }
                                    dataItems = dataList;
                                }
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                                ex.printStackTrace();
                                if (pSession != null) {
                                    pSession.close();
                                }
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            if (pSession != null) {
                                pSession.close();
                            }
                            throw throwable;
                        }
                        if (pSession != null) {
                            pSession.close();
                        }
                    }
                }
                UIRegistry.clearSimpleGlassPaneMsg();
                UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
                CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
            }
        };
        bldWorker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DisciplineBusRules.PROGRESS.equals(evt.getPropertyName());
            }
        });
        bldWorker.execute();
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (this.formViewObj != null && dataObj != null) {
            Discipline discipline = (Discipline)dataObj;
            Component comp = this.formViewObj.getControlByName("type");
            if (comp instanceof TextFieldFromPickListTable) {
                TextFieldFromPickListTable tf = (TextFieldFromPickListTable)comp;
                tf.setValue(DisciplineType.getByName(discipline.getType()), "");
            } else if (comp instanceof ValTextField && discipline.getType() != null) {
                ValTextField tf = (ValTextField)comp;
                tf.setValue(DisciplineType.getByName(discipline.getType()), "");
            }
        }
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        CommandDispatcher.unregister(CMD_TYPE, this);
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (!(dataObj instanceof Discipline)) {
            this.reasonList.add("Object is of wrong Class.");
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS nameStatus = this.isCheckDuplicateNumberOK("name", (FormDataObjIFace)dataObj, Discipline.class, "userGroupScopeId");
        return nameStatus != BusinessRulesIFace.STATUS.OK ? BusinessRulesIFace.STATUS.Error : BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public void okToDelete(Object dataObj, DataProviderSessionIFace session, BusinessRulesOkDeleteIFace deletable) {
        this.reasonList.clear();
        if (deletable != null) {
            Discipline discipline = (Discipline)dataObj;
            Integer id = discipline.getId();
            if (id != null) {
                Discipline currDiscipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
                if (currDiscipline.getId().equals(discipline.getId())) {
                    UIRegistry.showError("You cannot delete the current Discipline.");
                } else {
                    try {
                        final Integer dispId = discipline.getId();
                        final SpecifyDeleteHelper delHelper = new SpecifyDeleteHelper();
                        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){

                            @Override
                            protected Integer doInBackground() throws Exception {
                                try {
                                    delHelper.delRecordFromTable(Discipline.class, dispId, true);
                                    delHelper.done(false);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(DivisionBusRules.class, ex);
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                super.done();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (DisciplineBusRules.this.formViewObj != null) {
                                            DisciplineBusRules.this.formViewObj.updateAfterRemove(true);
                                        }
                                        UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
                                        CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
                                    }
                                });
                            }
                        };
                        String title = String.format("%s %s", UIRegistry.getResourceString("DELETING"), DBTableIdMgr.getInstance().getTitleForId(Discipline.getClassTableId()));
                        JDialog dlg = delHelper.initProgress(worker, title);
                        worker.execute();
                        UIHelper.centerAndShow(dlg);
                        System.out.println("");
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(DisciplineBusRules.class, ex);
                        ex.printStackTrace();
                    }
                }
            } else {
                super.okToDelete(dataObj, session, deletable);
            }
        } else {
            super.okToDelete(dataObj, session, deletable);
        }
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        super.beforeMerge(dataObj, session);
        Discipline discipline = (Discipline)dataObj;
        if (this.formViewObj != null && dataObj != null) {
            ValComboBox dspCbx;
            DisciplineType dt;
            Component comp = this.formViewObj.getControlByName("type");
            if (comp instanceof ValComboBox && (dt = (DisciplineType)(dspCbx = (ValComboBox)comp).getComboBox().getSelectedItem()) != null) {
                discipline.setType(dt.getName());
            }
            for (Collection col : discipline.getCollections()) {
                if (col.getId() != null) continue;
                try {
                    for (AutoNumberingScheme ns : col.getNumberingSchemes()) {
                        session.saveOrUpdate(ns);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        Discipline discipline = (Discipline)dataObj;
        if (discipline.getTaxonTreeDef() == null) {
            TaxonTreeDef taxonTreeDef = DataBuilder.createTaxonTreeDef("Sample Taxon Tree Def");
            discipline.setTaxonTreeDef(taxonTreeDef);
        }
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        Discipline discipline = (Discipline)dataObj;
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        for (Collection collection : discipline.getCollections()) {
            int count = BasicSQLUtils.getCount("SELECT count(*) FROM picklist WHERE CollectionID = " + collection.getId());
            if (count != 0) continue;
            try {
                if (!(session instanceof HibernateDataProviderSession)) continue;
                HibernateDataProviderSession hibSession = (HibernateDataProviderSession)session;
                BuildSampleDatabase.createPickLists(hibSession.getSession(), null, false, collection);
                BuildSampleDatabase.createPickLists(hibSession.getSession(), collection.getDiscipline(), false, collection);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DisciplineBusRules.class, ex);
                ex.printStackTrace();
                UsageTracker.incrNetworkUsageCount();
            }
        }
        return true;
    }

    @Override
    public void afterDeleteCommit(Object dataObj) {
        super.afterDeleteCommit(dataObj);
        UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
        CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        if (dataObj instanceof Discipline) {
            DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(Discipline.getClassTableId());
            return UIRegistry.getLocalizedMessage("DISCIPLINE_DELETED", ti.getTitle());
        }
        return super.getDeleteMsg(dataObj);
    }

    @Override
    public void addChildrenToNewDataObjects(Object newDataObj) {
        super.addChildrenToNewDataObjects(newDataObj);
        SpecifyDBSetupWizard wizardPanel = new SpecifyDBSetupWizard(SpecifyDBSetupWizard.WizardType.Division, null);
        final CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), "", true, 0, (Component)wizardPanel);
        dlg.setCustomTitleBar(UIRegistry.getResourceString("CREATEDISP"));
        wizardPanel.setListener(new SpecifyDBSetupWizard.WizardListener(){

            @Override
            public void cancelled() {
            }

            @Override
            public void finished() {
                dlg.setVisible(false);
            }

            @Override
            public void hide() {
                dlg.setVisible(false);
            }

            @Override
            public void panelChanged(String title) {
                dlg.setTitle(title);
            }
        });
        UIHelper.centerAndShow(dlg);
        UIRegistry.popResourceBundle();
        DisciplineType disciplineType = wizardPanel.getDisciplineType();
        TaxonTreeDef taxonTreeDef = DataBuilder.createTaxonTreeDef("Taxon");
        GeographyTreeDef geoTreeDef = DataBuilder.createGeographyTreeDef("Geography");
        GeologicTimePeriodTreeDef gtpTreeDef = DataBuilder.createGeologicTimePeriodTreeDef("Chronos Stratigraphy");
        LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
        Discipline discipline = (Discipline)newDataObj;
        discipline.setType(disciplineType.getName());
        DataType dataType = AppContextMgr.getInstance().getClassObject(DataType.class);
        discipline.setDataType(dataType);
        taxonTreeDef.setDiscipline(discipline);
        discipline.setTaxonTreeDef(taxonTreeDef);
        geoTreeDef.getDisciplines().add(discipline);
        discipline.setGeographyTreeDef(geoTreeDef);
        gtpTreeDef.getDisciplines().add(discipline);
        discipline.setGeologicTimePeriodTreeDef(gtpTreeDef);
        lithoStratTreeDef.getDisciplines().add(discipline);
        discipline.setLithoStratTreeDef(lithoStratTreeDef);
    }

    @Override
    public Object beforeDelete(Object dataObj, DataProviderSessionIFace session) {
        super.beforeDelete(dataObj, session);
        return dataObj;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isAction("DisciplineSaved")) {
            Division divsion = (Division)cmdAction.getData();
            this.formViewObj.getMVParent().getMultiViewParent().setData(divsion);
        } else {
            cmdAction.isAction("DisciplineError");
        }
    }
}

