/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DeterminationBusRules
extends BaseBusRules {
    private static final Logger log = Logger.getLogger(DeterminationBusRules.class);
    private static final String DT_ALREADY_DETERMINATION = "DT_ALREADY_DETERMINATION";
    protected Determination determination = null;
    protected KeyListener nameChangeKL = null;
    protected boolean ignoreSelection = false;
    protected boolean checkedBlankUsageItem = false;
    protected boolean isNewObject = false;
    protected boolean isBlockingChange = false;
    protected ChangeListener chkbxCL = null;
    protected ValCheckBox isCurrentCheckbox = null;

    public DeterminationBusRules() {
        super(new Class[0]);
    }

    @Override
    public void beforeFormFill() {
        this.determination = null;
    }

    @Override
    public void afterFillForm(Object dataObj) {
        this.isBlockingChange = false;
        this.determination = null;
        if (this.formViewObj != null && this.formViewObj.getDataObj() instanceof Determination) {
            Component altNameComp;
            Component activeTax;
            this.determination = (Determination)this.formViewObj.getDataObj();
            Component currentComp = this.formViewObj.getControlByName("isCurrent");
            if (this.determination != null && currentComp != null) {
                if (this.isNewObject) {
                    if (this.determination.getCollectionObject() != null) {
                        if (currentComp instanceof ValCheckBox) {
                            if (this.formViewObj.isCreatingNewObject()) {
                                this.isBlockingChange = true;
                                ((ValCheckBox)currentComp).doClick();
                                this.isBlockingChange = false;
                                if (!((ValCheckBox)currentComp).isSelected()) {
                                    ((ValCheckBox)currentComp).doClick();
                                }
                                Set<Determination> detSet = this.determination.getCollectionObject().getDeterminations();
                                for (Determination d : detSet) {
                                    if (d == this.determination) continue;
                                    d.setIsCurrent(false);
                                }
                            }
                        } else {
                            log.error((Object)("IsCurrent not set to true because form control is of unexpected type: " + currentComp.getClass().getName()));
                        }
                    }
                } else {
                    ((ValCheckBox)currentComp).setValue(this.determination.getIsCurrent(), null);
                }
            }
            if ((activeTax = this.formViewObj.getControlByName("preferredTaxon")) != null) {
                JTextField activeTaxTF = (JTextField)activeTax;
                activeTaxTF.setFocusable(false);
                if (this.determination != null && this.determination.getPreferredTaxon() != null) {
                    activeTaxTF.setText(this.determination.getPreferredTaxon().getFullName());
                } else {
                    activeTaxTF.setText("");
                }
            }
            if (this.formViewObj.getAltView().getMode() != AltViewIFace.CreationMode.EDIT) {
                return;
            }
            Component nameUsageComp = this.formViewObj.getControlByName("nameUsage");
            if (nameUsageComp instanceof ValComboBox) {
                if (!this.checkedBlankUsageItem) {
                    ValComboBox cbx;
                    boolean fnd = false;
                    if (nameUsageComp instanceof ValComboBox && (cbx = (ValComboBox)nameUsageComp).getComboBox().getModel() instanceof PickListDBAdapterIFace) {
                        PickListDBAdapterIFace items = (PickListDBAdapterIFace)((Object)cbx.getComboBox().getModel());
                        for (PickListItemIFace item : items.getPickList().getItems()) {
                            if (!StringUtils.isBlank((String)item.getValue())) continue;
                            fnd = true;
                            break;
                        }
                        if (!fnd) {
                            boolean readOnly = items.getPickList().getReadOnly();
                            if (readOnly) {
                                items.getPickList().setReadOnly(false);
                            }
                            items.addItem("", null);
                            if (readOnly) {
                                items.getPickList().setReadOnly(true);
                            }
                        }
                    }
                    this.checkedBlankUsageItem = true;
                }
                nameUsageComp.setEnabled(true);
            }
            if ((altNameComp = this.formViewObj.getControlByName("alternateName")) != null && this.determination != null) {
                altNameComp.setEnabled(this.determination.getTaxon() == null);
            }
            if (currentComp != null && this.chkbxCL == null) {
                this.chkbxCL = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        DeterminationBusRules.this.adjustIsCurrentCheckbox();
                    }
                };
                this.isCurrentCheckbox = (ValCheckBox)currentComp;
                this.isCurrentCheckbox.addChangeListener(this.chkbxCL);
            }
        }
        this.isNewObject = false;
    }

    private void adjustIsCurrentCheckbox() {
        if (!this.isBlockingChange && this.formViewObj != null && this.isCurrentCheckbox != null) {
            this.determination = (Determination)this.formViewObj.getDataObj();
            if (this.determination != null && this.isCurrentCheckbox.isSelected() && this.determination.getCollectionObject() != null) {
                for (Determination d : this.determination.getCollectionObject().getDeterminations()) {
                    if (d == this.determination) continue;
                    d.setIsCurrent(false);
                }
            }
        }
    }

    protected void addListenerIfNecessary(KeyListener kl, Component comp) {
        boolean fnd = false;
        KeyListener[] keyListenerArray = comp.getKeyListeners();
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyListener existingKl = keyListenerArray[n2];
            if (existingKl == kl) {
                fnd = true;
                break;
            }
            ++n2;
        }
        if (!fnd) {
            comp.addKeyListener(kl);
        }
    }

    protected void nameChanged(KeyEvent e, ValComboBoxFromQuery taxComp, Component altNameComp) {
        if (e.getSource() != null) {
            if (e.getSource().equals(altNameComp)) {
                taxComp.setEnabled(StringUtils.isBlank((String)((JTextField)altNameComp).getText()));
            } else if (e.getSource().equals(taxComp)) {
                this.taxonChanged(taxComp, altNameComp);
            }
        }
    }

    @Override
    public void afterCreateNewObj(Object newDataObj) {
        this.isNewObject = true;
    }

    protected boolean checkDeterminationStatus(CollectionObject colObj, Determination deter) {
        if (deter.isCurrentDet()) {
            for (Determination det : colObj.getDeterminations()) {
                boolean isSameDet;
                if (det.getId() != null && deter.getId() != null) {
                    isSameDet = det.getId().equals(deter.getId());
                } else {
                    boolean bl = isSameDet = det == deter;
                }
                if (isSameDet || !det.isCurrentDet()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object parentDataObj, Object dataObj, boolean isExistingObject) {
        BusinessRulesIFace.STATUS status = super.processBusinessRules(parentDataObj, dataObj, isExistingObject);
        if (status == BusinessRulesIFace.STATUS.OK && !this.checkDeterminationStatus((CollectionObject)parentDataObj, (Determination)dataObj)) {
            this.reasonList.add(UIRegistry.getResourceString(DT_ALREADY_DETERMINATION));
            status = BusinessRulesIFace.STATUS.Error;
        }
        return status;
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        Object parentDataObj;
        MultiView mv;
        BusinessRulesIFace.STATUS status = super.processBusinessRules(dataObj);
        if (status == BusinessRulesIFace.STATUS.OK && this.formViewObj != null && this.formViewObj.getMVParent() != null && !(mv = this.formViewObj.getMVParent()).isTopLevel() && !this.checkDeterminationStatus((CollectionObject)(parentDataObj = mv.getMultiViewParent().getData()), (Determination)dataObj)) {
            this.reasonList.add(UIRegistry.getResourceString(DT_ALREADY_DETERMINATION));
            status = BusinessRulesIFace.STATUS.Error;
        }
        return status;
    }

    @Override
    public void afterDeleteCommit(Object dataObj) {
        this.determination = null;
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        this.determination = null;
        return super.afterSaveCommit(dataObj, session);
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        this.determination = null;
        this.chkbxCL = null;
    }

    @Override
    public boolean beforeSaveCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        return super.beforeSaveCommit(dataObj, session);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        GetSetValueIFace taxonField;
        super.initialize(viewableArg);
        if (this.formViewObj != null && (taxonField = (GetSetValueIFace)((Object)this.formViewObj.getControlByName("taxon"))) instanceof ValComboBoxFromQuery) {
            final ValComboBoxFromQuery parentCBX = (ValComboBoxFromQuery)taxonField;
            final Component altNameComp = this.formViewObj.getControlByName("alternateName");
            if (this.nameChangeKL == null) {
                this.nameChangeKL = new KeyAdapter(){

                    @Override
                    public void keyTyped(final KeyEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DeterminationBusRules.this.nameChanged(e, parentCBX, altNameComp);
                            }
                        });
                    }
                };
            }
            if (parentCBX != null) {
                parentCBX.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (e == null || !e.getValueIsAdjusting()) {
                            DeterminationBusRules.this.taxonChanged(parentCBX, altNameComp);
                        }
                    }
                });
                this.addListenerIfNecessary(this.nameChangeKL, parentCBX);
            }
            if (altNameComp != null) {
                this.addListenerIfNecessary(this.nameChangeKL, altNameComp);
            }
        }
    }

    protected void taxonChanged(ValComboBoxFromQuery taxonComboBox, Component altTaxName) {
        Component activeTax;
        Object objInForm = this.formViewObj.getDataObj();
        if (objInForm == null) {
            return;
        }
        Taxon formNode = ((Determination)objInForm).getTaxon();
        Taxon taxon = null;
        if (taxonComboBox.getValue() instanceof String) {
            taxonComboBox.getValue();
            taxon = formNode.getParent();
        } else {
            taxon = (Taxon)taxonComboBox.getValue();
        }
        String activeTaxName = null;
        if (taxon != null) {
            if (!taxon.getIsAccepted().booleanValue() && AppPreferences.getRemote().getBoolean("Determination.PromptToReplaceSynonym", false).booleanValue()) {
                PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, f:p:g, 5dlu", "7dlu, c:p, 5dlu, c:p, 10dlu"));
                String msg1 = String.format(UIRegistry.getResourceString("DeterminationBusRule.SynChoiceMsg1"), taxon.getFullName(), taxon.getAcceptedParent().getFullName());
                String msg2 = String.format(UIRegistry.getResourceString("DeterminationBusRule.SynChoiceMsg2"), taxon.getFullName(), taxon.getAcceptedParent().getFullName());
                CellConstraints cc = new CellConstraints();
                pb.add((Component)UIHelper.createLabel(msg1), cc.xy(2, 2));
                pb.add((Component)UIHelper.createLabel(msg2), cc.xy(2, 4));
                String formTitle = UIRegistry.getResourceString("DeterminationBusRules.SYNONYM_INFORMATION");
                CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), formTitle, true, 7, (Component)pb.getPanel());
                cd.setModal(true);
                cd.setOkLabel(UIRegistry.getResourceString("DeterminationBusRules.Change"));
                cd.setCancelLabel(UIRegistry.getResourceString("DeterminationBusRules.Keep"));
                UIHelper.centerAndShow(cd);
                if (cd.getBtnPressed() == 1) {
                    taxon = taxon.getAcceptedParent();
                    taxonComboBox.setValue(taxon, taxon.getFullName());
                }
            }
            activeTaxName = taxon.getIsAccepted() != false ? taxon.getFullName() : taxon.getAcceptedParent().getFullName();
        }
        if ((activeTax = this.formViewObj.getControlByName("preferredTaxon")) != null) {
            ((JTextField)activeTax).setText(activeTaxName);
        }
        if (altTaxName != null) {
            altTaxName.setEnabled(taxon == null);
        }
    }
}

