/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.IllustrativeBarCodeUI;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.specify.datamodel.DNASequence;
import edu.ku.brc.specify.datamodel.DNASequencingRun;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.DocumentAdaptor;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.apache.log4j.Logger;

public class DNASequenceBusRules
extends AttachmentOwnerBaseBusRules
implements CommandListener {
    private static final Logger dnalog = Logger.getLogger(DNASequenceBusRules.class);
    protected IllustrativeBarCodeUI barCodeUI = null;

    public DNASequenceBusRules() {
        super(DNASequence.class);
        CommandDispatcher.register("Data_Entry", this);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        if (this.formViewObj != null) {
            this.barCodeUI = (IllustrativeBarCodeUI)this.formViewObj.getControlById("8");
            if (this.barCodeUI == null) {
                this.barCodeUI = new IllustrativeBarCodeUI();
            }
            if (this.barCodeUI != null) {
                final JTextArea ta = (JTextArea)this.formViewObj.getCompById("4");
                ta.getDocument().addDocumentListener(new DocumentAdaptor(){

                    @Override
                    protected void changed(DocumentEvent e) {
                        if (DNASequenceBusRules.this.isEditMode()) {
                            DNASequenceBusRules.this.barCodeUI.setSequence(ta.getText());
                            DNASequenceBusRules.this.adjustTotals();
                        }
                    }
                });
            }
        }
    }

    private void setValue(String id, int value) {
        JTextField tf = (JTextField)this.formViewObj.getControlById(id);
        if (tf != null) {
            tf.setText(Integer.toString(value));
        } else {
            dnalog.debug((Object)("Couldn't find id[" + id + "] " + value));
        }
    }

    private void adjustTotals() {
        JTextArea ta = (JTextArea)this.formViewObj.getCompById("4");
        if (this.formViewObj != null && this.barCodeUI != null && ta != null) {
            this.barCodeUI.setSequence(ta.getText());
            int compA = this.barCodeUI.getTotal('A');
            int compG = this.barCodeUI.getTotal('G');
            int compT = this.barCodeUI.getTotal('T');
            int compC = this.barCodeUI.getTotal('C');
            int compX = this.barCodeUI.getTotal('X');
            int total = compA + compG + compC + compT + compX;
            this.setValue("residues", total);
            this.setValue("compA", compA);
            this.setValue("compG", compG);
            this.setValue("compT", compT);
            this.setValue("compC", compC);
            this.setValue("ambiguous", compX);
            DNASequence dnaSeq = (DNASequence)this.formViewObj.getDataObj();
            if (dnaSeq != null) {
                dnaSeq.setCompA(compA);
                dnaSeq.setCompG(compG);
                dnaSeq.setCompT(compT);
                dnaSeq.setCompC(compC);
                dnaSeq.setTotalResidues(total);
                dnaSeq.setAmbiguousResidues(compX);
            }
        }
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (this.formViewObj != null && dataObj != null) {
            this.adjustTotals();
        }
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        CommandDispatcher.unregister("Data_Entry", this);
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
    }

    @Override
    protected void addExtraObjectForProcessing(Object dObjAtt) {
        super.addExtraObjectForProcessing(dObjAtt);
        DNASequence dnaseq = (DNASequence)dObjAtt;
        for (DNASequencingRun dnasr : dnaseq.getDnaSequencingRuns()) {
            super.addExtraObjectForProcessing(dnasr);
        }
    }
}

