/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ContainerBusRules
extends BaseBusRules {
    private static final String CONTAINER_CO_USED = "CONTAINER_CO_USED";
    private static final String CONTAINER_CO_BAD = "CONTAINER_CO_BAD";
    private static final String GET_PARENT_SQL = "SELECT ParentID FROM container WHERE ContainerID = ";
    private ValComboBoxFromQuery parentQCBX = null;

    public ContainerBusRules() {
        super(ContainerBusRules.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        Component comp;
        super.initialize(viewableArg);
        if (this.parentQCBX == null && this.formViewObj != null && (comp = (Component)this.formViewObj.getCompById("parent")) != null && comp instanceof ValComboBoxFromQuery) {
            this.parentQCBX = (ValComboBoxFromQuery)comp;
            this.parentQCBX.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ContainerBusRules.this.parentSelected();
                }
            });
        }
    }

    private void parentSelected() {
        Container currContainer;
        Container parent;
        if (this.parentQCBX != null && (parent = (Container)this.parentQCBX.getValue()) != null && (currContainer = (Container)this.formViewObj.getDataObj()).getId() != null && !this.searchContainerChildren(parent.getId(), currContainer.getId())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String sql = "SELECT Name FROM container WHERE ContainerID = ";
                    String currName = (String)BasicSQLUtils.querySingleObj(String.valueOf(sql) + currContainer.getId());
                    String newParentName = (String)BasicSQLUtils.querySingleObj(String.valueOf(sql) + parent.getId());
                    UIRegistry.showLocalizedError("CONTAINER_BAD_PARENT", newParentName, currName);
                    ContainerBusRules.this.parentQCBX.setValue(null, null);
                }
            });
        }
    }

    private boolean searchContainerChildren(Integer pId, Integer currParentId) {
        String sql = "SELECT ContainerID FROM container WHERE ParentID = " + currParentId;
        Vector<Integer> childrenIds = BasicSQLUtils.queryForInts(sql);
        for (Integer id : childrenIds) {
            if (pId.equals(id)) {
                return false;
            }
            if (this.searchContainerChildren(pId, id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void okToDelete(Object dataObjArg, DataProviderSessionIFace sessionArg, BusinessRulesOkDeleteIFace deletable) {
        Container container;
        this.reasonList.clear();
        if (deletable != null && dataObjArg instanceof FormDataObjIFace && ((FormDataObjIFace)dataObjArg).getId() != null && ((container = (Container)dataObjArg).getChildren().size() > 0 || container.getCollectionObjects().size() > 0 || container.getCollectionObjectKids().size() > 0)) {
            UIRegistry.showLocalizedMsg("WARNING", "CONTAINER_KIDS_ERROR", new Object[0]);
        }
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (dataObj instanceof Container) {
            String catNum;
            String sql;
            Integer colObjId;
            UIFieldFormatterIFace catNumFmt = DBTableIdMgr.getFieldFormatterFor(CollectionObject.class, "CatalogNumber");
            Container container = (Container)dataObj;
            Container parent = container.getParent();
            if (container.getId() != null) {
                for (Container child : container.getChildren()) {
                    Object sql2;
                    Integer parentId;
                    if (parent != null && parent.getId().equals(child.getId())) {
                        this.reasonList.add(UIRegistry.getLocalizedMessage("CONTAINER_PARENT_CHILD", child.getName(), container.getName()));
                        return BusinessRulesIFace.STATUS.Error;
                    }
                    if (container.getId().equals(child.getId())) {
                        this.reasonList.add(UIRegistry.getLocalizedMessage("CONTAINER_SELF_CHILD", container.getName()));
                        return BusinessRulesIFace.STATUS.Error;
                    }
                    Integer id = container.getId();
                    while ((parentId = BasicSQLUtils.getCount((String)(sql2 = GET_PARENT_SQL + id))) != null) {
                        if (parentId.equals(child.getId())) {
                            this.reasonList.add(UIRegistry.getLocalizedMessage("CONTAINER_CYCLE", child.getName()));
                            return BusinessRulesIFace.STATUS.Error;
                        }
                        id = parentId;
                    }
                }
            }
            ArrayList<String> catNumsInError = new ArrayList<String>();
            HashMap<Integer, String> colObjIdsHash = new HashMap<Integer, String>();
            for (CollectionObject coKid : container.getCollectionObjectKids()) {
                String sql3 = "SELECT ContainerID, ContainerOwnerID FROM collectionobject WHERE (ContainerID IS NOT NULL OR ContainerOwnerID IS NOT NULL) AND CollectionObjectID = " + coKid.getId();
                Vector<Object[]> rows = BasicSQLUtils.query(sql3);
                if (rows.size() > 0) {
                    Integer cId = container.getId();
                    for (Object[] row : rows) {
                        Integer containerOwnerId;
                        Integer containerId = (Integer)row[0];
                        if (!(containerId == null || cId != null && containerId.equals(cId))) {
                            catNumsInError.add(coKid.getCatalogNumber());
                        }
                        if ((containerOwnerId = (Integer)row[1]) == null || cId != null && containerOwnerId.equals(cId)) continue;
                        catNumsInError.add(coKid.getCatalogNumber());
                    }
                }
                colObjIdsHash.put(coKid.getId(), coKid.getCatalogNumber());
            }
            if (catNumsInError.size() > 0) {
                for (String catNum2 : catNumsInError) {
                    this.reasonList.add(UIRegistry.getLocalizedMessage(CONTAINER_CO_USED, catNumFmt != null ? catNumFmt.formatToUI(catNum2) : catNum2));
                }
                return BusinessRulesIFace.STATUS.Error;
            }
            if (container.getId() != null && container.getCollectionObject() != null && (colObjId = BasicSQLUtils.getCount(sql = "SELECT CollectionObjectID FROM collectionobject WHERE ContainerID IS NOT NULL AND ContainerID = " + container.getId())) == null && (catNum = (String)colObjIdsHash.get(container.getCollectionObject().getId())) != null) {
                this.reasonList.add(UIRegistry.getLocalizedMessage(CONTAINER_CO_BAD, catNumFmt != null ? catNumFmt.formatToUI(catNum) : catNum));
                return BusinessRulesIFace.STATUS.Error;
            }
        } else {
            this.reasonList.add("Object is of wrong Class.");
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS nameStatus = this.isCheckDuplicateNumberOK("name", (FormDataObjIFace)dataObj, Container.class, "containerId");
        return nameStatus != BusinessRulesIFace.STATUS.OK ? BusinessRulesIFace.STATUS.Error : BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public void aboutToShutdown() {
        super.aboutToShutdown();
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
    }
}

