/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.ui.UIRegistry;
import java.util.Hashtable;

public class CollectorBusRules
extends BaseBusRules {
    public CollectorBusRules() {
        super(Collector.class);
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object parentDataObj, Object dataObj, boolean isExistingObject) {
        this.reasonList.clear();
        if (isExistingObject && parentDataObj instanceof CollectingEvent && dataObj instanceof Collector) {
            CollectingEvent ce = (CollectingEvent)parentDataObj;
            Collector col = (Collector)dataObj;
            Hashtable<Integer, Boolean> hash = new Hashtable<Integer, Boolean>();
            for (Collector collector : ce.getCollectors()) {
                Integer id = collector.getAgent().getAgentId();
                boolean isBad = false;
                if (hash.get(id) == null) {
                    if (collector.getId() != null && id.equals(col.getAgent().getAgentId())) {
                        isBad = true;
                    }
                    hash.put(id, true);
                } else {
                    isBad = true;
                }
                if (!isBad) continue;
                this.reasonList.add(String.format(UIRegistry.getResourceString("CE_DUPLICATE_COLLECTORS"), col.getIdentityTitle()));
                return BusinessRulesIFace.STATUS.Error;
            }
        }
        return super.processBusinessRules(parentDataObj, dataObj, isExistingObject);
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        super.beforeMerge(dataObj, session);
        Collector collector = (Collector)dataObj;
        if (collector.getDivision() == null) {
            collector.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        }
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        Collector collector = (Collector)dataObj;
        if (collector.getDivision() == null) {
            collector.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        }
    }
}

