/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.config.init.NumberingSchemeSetupDlg;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class CollectionSetupBusRules
extends BaseBusRules {
    protected Collection collection = null;

    public CollectionSetupBusRules() {
        super(Collection.class);
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        this.collection = (Collection)dataObj;
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        super.beforeMerge(dataObj, session);
        Collection col = (Collection)dataObj;
        try {
            for (AutoNumberingScheme ns : col.getNumberingSchemes()) {
                session.attach(ns);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
    }

    @Override
    public void addChildrenToNewDataObjects(Object newDataObj) {
        super.addChildrenToNewDataObjects(newDataObj);
        MultiView disciplineMV = this.formViewObj.getMVParent().getMultiViewParent();
        MultiView divisionMV = disciplineMV.getMultiViewParent();
        NumberingSchemeSetupDlg dlg = UIRegistry.getMostRecentWindow() instanceof Dialog ? new NumberingSchemeSetupDlg((Dialog)UIRegistry.getMostRecentWindow(), (Division)divisionMV.getData(), (Discipline)disciplineMV.getData(), (Collection)newDataObj) : new NumberingSchemeSetupDlg((Frame)UIRegistry.getMostRecentWindow(), (Division)divisionMV.getData(), (Discipline)disciplineMV.getData(), (Collection)newDataObj);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            this.collection.getNumberingSchemes().add(dlg.getNumScheme());
            dlg.getNumScheme().getCollections().add(this.collection);
            divisionMV.addToBeSavedItem(dlg.getNumScheme());
        }
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        JButton btn = (JButton)this.formViewObj.getCompById("newNumSchemeBTN");
        if (btn != null) {
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectionSetupBusRules.this.createNewNumScheme();
                }
            });
            btn = (JButton)this.formViewObj.getCompById("chooseNumSchemeBTN");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
    }

    @Override
    public Object beforeDelete(Object dataObj, DataProviderSessionIFace session) {
        return super.beforeDelete(dataObj, session);
    }

    protected void createNewNumScheme() {
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Dialog)UIRegistry.getMostRecentWindow(), null, "CatAutoNumberingScheme", null, "Create Numbering Scheme", null, AutoNumberingScheme.class.getName(), "autoNumberingSchemeId", true, 8);
        AutoNumberingScheme scheme = new AutoNumberingScheme();
        scheme.initialize();
        scheme.setTableNumber(CollectionObject.getClassTableId());
        dlg.setData(scheme);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            ValTextField numSchemTxt = (ValTextField)this.formViewObj.getCompById("numScheme");
            numSchemTxt.setText(scheme.getIdentityTitle());
            if (this.collection != null) {
                this.collection.getNumberingSchemes().add(scheme);
                scheme.getCollections().add(this.collection);
            }
        }
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        return super.okToEnableDelete(dataObj);
    }
}

