/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttribute;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.datamodel.DeaccessionPreparation;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.Project;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.specify.plugins.SeriesProcCatNumPlugin;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import org.apache.commons.lang.StringUtils;
import org.hibernate.LazyInitializationException;

public class CollectionObjectBusRules
extends AttachmentOwnerBaseBusRules {
    private static final String CATNUMNAME = "catalogNumber";
    public static final int MAXSERIESSIZE = 500;
    private static final String GLASSKEY = "DOBATCHCREATE";
    private static final String NonIncrementingCatNum = "NonIncrementingCatNum";
    private static final String BatchSaveSuccess = "CollectionObjectBusRules.BatchSaveSuccess";
    private static final String BatchSaveErrors = "CollectionObjectBusRules.BatchSaveErrors";
    private static final String BatchSaveErrorsTitle = "CollectionObjectBusRules.BatchSaveErrorsTitle";
    private static final String BatchRSBaseName = "CollectionObjectBusRules.BatchRSBaseName";
    private static final String InvalidEntryMsg = "CollectionObjectBusRules.InvalidEntryMsg";
    private static final String InvalidEntryTitle = "CollectionObjectBusRules.InvalidEntryTitle";
    private static final String InvalidBatchEntry = "CollectionObjectBusRules.InvalidBatchEntry";
    private static final String CatNumInUse = "CollectionObjectBusRules.CatNumInUse";
    private static final String IncompleteSaveFlag = "CollectionObjectBusRules.IncompleteSaveFlag";
    private static final String InvalidBatchItems = "CollectionObjectBusRules.InvalidBatchItems";
    private CollectingEvent cachedColEve = null;
    private JButton generateLabelBtn = null;
    private JCheckBox generateLabelChk = null;
    private AtomicBoolean processingSeries = new AtomicBoolean(false);
    private Integer defaultPrepTypeId = null;
    private String defValForPrepType = null;
    protected boolean checkFieldNumberDupl = false;

    public CollectionObjectBusRules() {
        super(CollectionObject.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        if (this.formViewObj != null && this.formViewObj.isEditing()) {
            this.checkFieldNumberDupl = AppPreferences.getRemote().getBoolean("CO_CHK_FIELDNUM_DUPS", false);
            Component comp = this.formViewObj.getControlByName("generateLabelBtn");
            if (comp instanceof JButton) {
                this.generateLabelBtn = (JButton)comp;
                this.generateLabelBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CommandAction cmdAction = new CommandAction("Data_Entry", "PrintColObjLabel", CollectionObjectBusRules.this.formViewObj.getDataObj());
                                CommandDispatcher.dispatch(cmdAction);
                            }
                        });
                    }
                });
            }
            if ((comp = this.formViewObj.getControlByName("generateLabelChk")) instanceof JCheckBox) {
                this.generateLabelChk = (JCheckBox)comp;
            }
        }
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (this.formViewObj != null && this.formViewObj.getDataObj() instanceof CollectionObject) {
            CollectionObject colObj = (CollectionObject)dataObj;
            MultiView mvParent = this.formViewObj.getMVParent();
            boolean isNewObj = colObj.getId() == null;
            boolean isEdit = mvParent.isEditable();
            if (this.generateLabelChk != null) {
                this.generateLabelChk.setVisible(isEdit);
            }
            if (this.generateLabelBtn != null) {
                this.generateLabelBtn.setVisible(isEdit);
                this.generateLabelBtn.setEnabled(!isNewObj);
            }
        }
    }

    public static PrepType getPrepTypeFromId(Integer id) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            PrepType prepType = session.get(PrepType.class, id);
            return prepType;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(CollectionObjectBusRules.class, ex);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    public static Integer getPrepTypeIdFromDefVal(String defaultValue) {
        Integer defPrepTypeId = null;
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            String sqlStr = String.format("SELECT PrepTypeId, Name FROM preptype WHERE collectionId = COLLID AND Name = '%s'", defaultValue);
            sqlStr = QueryAdjusterForDomain.getInstance().adjustSQL(sqlStr);
            defPrepTypeId = BasicSQLUtils.getNumRecords(sqlStr);
        }
        return defPrepTypeId;
    }

    protected Agent getDefaultPreparedByAgent() {
        return Agent.getUserAgent();
    }

    @Override
    public void addChildrenToNewDataObjects(Object newDataObj) {
        AppPreferences remotePrefs;
        super.addChildrenToNewDataObjects(newDataObj);
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        Boolean doCreateCE = collection.getIsEmbeddedCollectingEvent();
        CollectionObject colObj = (CollectionObject)newDataObj;
        if (doCreateCE.booleanValue() && colObj.getCollectingEvent() == null) {
            CollectingEvent ce = new CollectingEvent();
            ce.initialize();
            colObj.addReference(ce, "collectingEvent");
        }
        if ((remotePrefs = AppPreferences.getRemote()) != null) {
            boolean isOKToCreate;
            Integer colId = collection.getId();
            if (remotePrefs.getBoolean("CO_CREATE_COA_" + colId, false).booleanValue()) {
                CollectionObjectAttribute coa = new CollectionObjectAttribute();
                coa.initialize();
                colObj.addReference(coa, "collectionObjectAttribute");
            }
            CollectionObject carryFwdCO = null;
            List<FormViewObj.FVOFieldInfo> fieldList = null;
            boolean isCarryFwdReady = false;
            if (this.formViewObj != null && this.formViewObj.getCarryFwdDataObj() != null && this.formViewObj.isDoCarryForward() && this.formViewObj.getCarryFwdInfo() != null) {
                carryFwdCO = (CollectionObject)this.formViewObj.getCarryFwdDataObj();
                fieldList = this.formViewObj.getCarryFwdInfo().getFieldList();
                boolean bl = isCarryFwdReady = fieldList.size() > 0;
            }
            if (remotePrefs.getBoolean("CO_CREATE_PREP_" + colId, false).booleanValue()) {
                if (StringUtils.isEmpty((String)this.defValForPrepType)) {
                    this.defValForPrepType = CollectionObjectBusRules.getDefValForPrepTypeHaveOnForm();
                }
                if (this.defaultPrepTypeId == null && StringUtils.isNotEmpty((String)this.defValForPrepType)) {
                    this.defaultPrepTypeId = CollectionObjectBusRules.getPrepTypeIdFromDefVal(this.defValForPrepType);
                }
                if (this.defaultPrepTypeId != null) {
                    isOKToCreate = true;
                    if (isCarryFwdReady) {
                        boolean bl = isOKToCreate = fieldList.contains("Preparations") && carryFwdCO.getPreparations().size() == 0;
                    }
                    if (isOKToCreate) {
                        PrepType prepType = CollectionObjectBusRules.getPrepTypeFromId(this.defaultPrepTypeId);
                        if (prepType != null) {
                            Preparation prep = new Preparation();
                            prep.initialize();
                            prep.addReference(prepType, "prepType");
                            colObj.addReference(prep, "preparations");
                        } else {
                            UIRegistry.showError("Unable to load PrepType with id: " + this.defaultPrepTypeId);
                        }
                    }
                }
            }
            if (remotePrefs.getBoolean("CO_CREATE_DET_" + colId, false).booleanValue()) {
                isOKToCreate = true;
                if (isCarryFwdReady) {
                    boolean bl = isOKToCreate = fieldList.contains("Determinations") && carryFwdCO.getDeterminations().size() == 0;
                }
                if (isOKToCreate) {
                    Determination det = new Determination();
                    det.initialize();
                    det.setIsCurrent(true);
                    colObj.addReference(det, "determinations");
                }
            }
        }
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        BusinessRulesIFace.STATUS status = super.processBusinessRules(dataObj);
        CollectionObject colObj = (CollectionObject)dataObj;
        if (!this.processingSeries.get() && this.getBatchPlugIn() != null && colObj != null && colObj.getId() != null) {
            this.reasonList.add(UIRegistry.getResourceString("CollectionObjectBusRules.AttemptedEditOfBatch"));
            status = BusinessRulesIFace.STATUS.Error;
        }
        if (status == BusinessRulesIFace.STATUS.OK && colObj.getId() == null) {
            DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(1);
            DBFieldInfo fieldInfo = tblInfo.getFieldByName(CATNUMNAME);
            UIFieldFormatterIFace fmt = fieldInfo.getFormatter();
            if (fmt != null && fmt.getAutoNumber() == null || !this.formViewObj.isAutoNumberOn()) {
                status = this.processBusinessRules(null, dataObj, true);
            } else if (this.checkFieldNumberDupl) {
                status = this.checkForFieldNumDup(dataObj);
            }
        }
        if (status == BusinessRulesIFace.STATUS.OK && ((CollectionObject)dataObj).getDeterminations().size() > 0) {
            int currents = 0;
            for (Determination det : ((CollectionObject)dataObj).getDeterminations()) {
                if (!det.isCurrentDet()) continue;
                ++currents;
            }
            if (currents != 1) {
                status = BusinessRulesIFace.STATUS.Error;
            }
            if (currents == 0) {
                this.reasonList.add(UIRegistry.getResourceString("CollectionObjectBusRules.CURRENT_DET_REQUIRED"));
            } else {
                this.reasonList.add(UIRegistry.getResourceString("CollectionObjectBusRules.ONLY_ONE_CURRENT_DET"));
            }
        }
        return status;
    }

    public static FormCellFieldIFace getPrepTypeFieldCellField() {
        AltViewIFace altView;
        ViewIFace view = AppContextMgr.getInstance().getView("Preparation");
        if (view != null && (altView = view.getAltView("Preparation Edit")) != null && altView.getViewDef() instanceof FormViewDef) {
            FormViewDef fvd = (FormViewDef)altView.getViewDef();
            return (FormCellFieldIFace)fvd.getFormCellByName("prepType");
        }
        return null;
    }

    public static String getDefValForPrepTypeHaveOnForm() {
        FormCellFieldIFace fcf = CollectionObjectBusRules.getPrepTypeFieldCellField();
        if (fcf != null) {
            return fcf.getDefaultValue();
        }
        return null;
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        CollectionObject colObj = (CollectionObject)dataObj;
        super.beforeMerge(dataObj, session);
        if (AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent().booleanValue()) {
            this.cachedColEve = colObj.getCollectingEvent();
            if (colObj != null && this.cachedColEve != null) {
                colObj.setCollectingEvent(null);
                try {
                    this.cachedColEve.getCollectionObjects().clear();
                }
                catch (LazyInitializationException lazyInitializationException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void addExtraObjectForProcessing(Object dObjAtt) {
        super.addExtraObjectForProcessing(dObjAtt);
        CollectionObject colObj = (CollectionObject)dObjAtt;
        if (AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent().booleanValue() && (colObj.getCollectingEvent() != null || this.cachedColEve != null)) {
            super.addExtraObjectForProcessing(this.cachedColEve != null ? this.cachedColEve : colObj.getCollectingEvent());
        }
        for (Preparation prep : colObj.getPreparations()) {
            super.addExtraObjectForProcessing(prep);
        }
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        CollectionObject colObj = (CollectionObject)dataObj;
        super.beforeSave(dataObj, session);
        if (AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent().booleanValue()) {
            if (this.cachedColEve != null) {
                try {
                    if (this.cachedColEve != null && this.cachedColEve.getId() != null) {
                        this.cachedColEve = session.merge(this.cachedColEve);
                    } else {
                        session.save(this.cachedColEve);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(CollectionObjectBusRules.class, ex);
                }
            }
            if (this.cachedColEve != null && colObj != null) {
                colObj.setCollectingEvent(this.cachedColEve);
                this.cachedColEve.getCollectionObjects().add(colObj);
                this.cachedColEve = null;
            } else {
                this.log.error((Object)("The CE " + this.cachedColEve + " was null or the CO " + colObj + " was null"));
            }
        }
    }

    @Override
    public boolean beforeDeleteCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        boolean ok = super.beforeDeleteCommit(dataObj, session);
        if (ok && dataObj instanceof CollectionObject) {
            Container parentContainer;
            CollectingEvent ce;
            CollectionObject colObj = (CollectionObject)dataObj;
            Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
            if (collection != null && collection.getIsEmbeddedCollectingEvent().booleanValue() && (ce = colObj.getCollectingEvent()) != null) {
                try {
                    session.delete(ce);
                    return true;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(CollectionObjectBusRules.class, ex);
                    ex.printStackTrace();
                    return false;
                }
            }
            if (colObj.getContainerOwner() != null) {
                parentContainer = colObj.getContainerOwner();
                parentContainer.getChildren().remove(colObj);
                colObj.setContainerOwner(null);
                if (this.formViewObj != null) {
                    this.formViewObj.getMVParent().getTopLevel().addToBeSavedItem(parentContainer);
                }
            }
            if (colObj.getContainer() != null) {
                parentContainer = colObj.getContainer();
                parentContainer.getCollectionObjectKids().remove(colObj);
                colObj.setContainer(null);
                if (this.formViewObj != null) {
                    this.formViewObj.getMVParent().getTopLevel().addToBeSavedItem(parentContainer);
                }
            }
        }
        return ok;
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        Component comp;
        this.setLSID((FormDataObjIFace)dataObj);
        if (this.formViewObj != null && this.formViewObj.isEditing() && (comp = this.formViewObj.getControlByName("generateLabelChk")) instanceof JCheckBox && ((JCheckBox)comp).isSelected()) {
            CommandAction cmdAction = new CommandAction("Data_Entry", "PrintColObjLabel", this.formViewObj.getDataObj());
            CommandDispatcher.dispatch(cmdAction);
        }
        return super.afterSaveCommit(dataObj, session);
    }

    @Override
    public void saveFinalization(Object dataObj) {
        super.saveFinalization(dataObj);
        this.doSeriesProcessing();
    }

    private BusinessRulesIFace.STATUS isCheckDuplicateBatchNumbersOK(boolean batchBeginIsDup) {
        SeriesProcCatNumPlugin batchCtrl;
        BusinessRulesIFace.STATUS result = BusinessRulesIFace.STATUS.OK;
        if (!this.processingSeries.get() && (batchCtrl = this.getBatchPlugIn()) != null && (result = this.processBatchContents(batchCtrl.getStartAndEndCatNumbers(), true, batchBeginIsDup, new Vector<String>())).equals((Object)BusinessRulesIFace.STATUS.Error)) {
            if (batchBeginIsDup) {
                this.reasonList.remove(this.reasonList.size() - 1);
            }
            this.reasonList.add(UIRegistry.getResourceString(InvalidBatchEntry));
        }
        return result;
    }

    protected void showBatchErrorObjects(Vector<String> badObjects, String TitleKey, String MsgKey) {
        JPanel pane = new JPanel(new BorderLayout());
        JLabel lbl = UIHelper.createLabel(UIRegistry.getResourceString(MsgKey));
        lbl.setBorder(new EmptyBorder(3, 1, 2, 0));
        pane.add((Component)lbl, "North");
        JPanel lstPane = new JPanel(new BorderLayout());
        JList lst = UIHelper.createList(badObjects);
        lst.setBorder(new SoftBevelBorder(1));
        lstPane.setBorder(new EmptyBorder(1, 1, 10, 1));
        lstPane.add((Component)lst, "Center");
        JScrollPane sp = new JScrollPane(lstPane);
        pane.add((Component)sp, "Center");
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString(TitleKey), true, 5, (Component)pane);
        UIHelper.centerAndShow(dlg);
        dlg.dispose();
    }

    private BusinessRulesIFace.STATUS processBatchContents(Pair<String, String> catNumPair, boolean validate, boolean invalidStart, Vector<String> nums) {
        DBFieldInfo CatNumFld = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId()).getFieldByColumnName("CatalogNumber");
        UIFieldFormatterIFace formatter = CatNumFld.getFormatter();
        if (!formatter.isIncrementer()) {
            return BusinessRulesIFace.STATUS.Error;
        }
        Vector<String> duplicates = new Vector<String>();
        String catNum = catNumPair.getFirst();
        if (invalidStart) {
            duplicates.add(formatter.formatToUI(catNum) + " - " + UIRegistry.getResourceString(CatNumInUse));
        }
        Integer collId = AppContextMgr.getInstance().getClassObject(Collection.class).getId();
        String coIdSql = "select CollectionObjectID from collectionobject where CollectionMemberID = " + collId + " and CatalogNumber = '";
        while (!catNum.equals(catNumPair.getSecond()) && nums.size() <= 500) {
            catNum = formatter.getNextNumber(catNum, true);
            if (!validate || BasicSQLUtils.querySingleObj(String.valueOf(coIdSql) + catNum + "'") == null) {
                nums.add(catNum);
                continue;
            }
            duplicates.add(formatter.formatToUI(catNum) + " - " + UIRegistry.getResourceString(CatNumInUse));
        }
        if (nums.size() > 500 || duplicates.size() > 0) {
            if (nums.size() > 500) {
                duplicates.clear();
            }
            if (duplicates.size() == 0) {
                UIRegistry.displayErrorDlgLocalized(InvalidEntryMsg, 500);
            } else {
                this.showBatchErrorObjects(duplicates, InvalidEntryTitle, InvalidBatchItems);
            }
            return BusinessRulesIFace.STATUS.Error;
        }
        return BusinessRulesIFace.STATUS.OK;
    }

    private SeriesProcCatNumPlugin getBatchPlugIn() {
        DBTableInfo tblInfo;
        DBFieldInfo fieldInfo;
        UIFieldFormatterIFace fmt;
        SeriesProcCatNumPlugin spCatNumPlugin;
        Component catNumComp;
        if (this.formViewObj != null && (catNumComp = this.formViewObj.getControlByName(CATNUMNAME)) instanceof SeriesProcCatNumPlugin && (spCatNumPlugin = (SeriesProcCatNumPlugin)catNumComp).isExpanded() && (fmt = (fieldInfo = (tblInfo = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId())).getFieldByName(CATNUMNAME)).getFormatter()) != null && fmt.getAutoNumber() != null && !this.formViewObj.isAutoNumberOn()) {
            return spCatNumPlugin;
        }
        return null;
    }

    public void doSeriesProcessing() {
        SeriesProcCatNumPlugin spCatNumPlugin;
        if (!this.processingSeries.get() && (spCatNumPlugin = this.getBatchPlugIn()) != null) {
            this.doCreateBatchOfColObj(spCatNumPlugin.getStartAndEndCatNumbers());
        }
    }

    public void doCreateBatchOfColObj(final Pair<String, String> catNumPair) {
        if (catNumPair.getFirst().equals(catNumPair.getSecond())) {
            return;
        }
        DBFieldInfo CatNumFld = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId()).getFieldByColumnName("CatalogNumber");
        final UIFieldFormatterIFace formatter = CatNumFld.getFormatter();
        if (!formatter.isIncrementer()) {
            UIRegistry.showLocalizedError(NonIncrementingCatNum);
            return;
        }
        final Vector<String> nums = new Vector<String>();
        this.processBatchContents(catNumPair, false, false, nums);
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){
            private Vector<Pair<Integer, String>> objectsAdded = new Vector();
            private Vector<String> objectsNotAdded = new Vector();
            private RecordSet batchRS;

            @Override
            protected Integer doInBackground() throws Exception {
                CollectionObject carryForwardCo;
                String catNum = (String)catNumPair.getFirst();
                Integer collId = AppContextMgr.getInstance().getClassObject(Collection.class).getId();
                String coIdSql = "select CollectionObjectID from collectionobject where CollectionMemberID = " + collId + " and CatalogNumber = '";
                this.objectsAdded.add(new Pair<Integer, String>((Integer)BasicSQLUtils.querySingleObj(String.valueOf(coIdSql) + catNum + "'"), catNum));
                int cnt = 0;
                CollectionObject co = null;
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    carryForwardCo = session.get(CollectionObject.class, ((CollectionObject)CollectionObjectBusRules.this.formViewObj.getDataObj()).getId());
                }
                finally {
                    session.close();
                }
                Thread.sleep(666L);
                try {
                    for (String currentCat : nums) {
                        try {
                            co = new CollectionObject();
                            co.initialize();
                            co.setCollection(AppContextMgr.getInstance().getClassObject(Collection.class));
                            co.setModifiedByAgent(carryForwardCo.getModifiedByAgent());
                            co.setCatalogNumber(currentCat);
                            CollectionObjectBusRules.this.formViewObj.setNewObject(co);
                            if (CollectionObjectBusRules.this.formViewObj.saveObject()) {
                                this.objectsAdded.add(new Pair<Integer, String>((Integer)BasicSQLUtils.querySingleObj(String.valueOf(coIdSql) + co.getCatalogNumber() + "'"), co.getCatalogNumber()));
                            } else {
                                this.objectsNotAdded.add(formatter.formatToUI(co.getCatalogNumber()).toString());
                            }
                        }
                        catch (Exception ex) {
                            CollectionObjectBusRules.this.log.error((Object)ex);
                            this.objectsNotAdded.add(formatter.formatToUI(currentCat) + ": " + (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()));
                        }
                        this.firePropertyChange(CollectionObjectBusRules.GLASSKEY, 0, ++cnt);
                    }
                    this.firePropertyChange(CollectionObjectBusRules.GLASSKEY, 0, nums.size());
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(Uploader.class, ex);
                }
                CollectionObjectBusRules.this.formViewObj.setDataObj(carryForwardCo);
                this.saveBatchObjectsToRS();
                return this.objectsAdded.size();
            }

            protected void saveBatchObjectsToRS() {
                block7: {
                    this.batchRS = new RecordSet();
                    this.batchRS.initialize();
                    this.batchRS.setDbTableId(CollectionObject.getClassTableId());
                    String name = String.valueOf(UIRegistry.getResourceString(CollectionObjectBusRules.BatchRSBaseName)) + " " + formatter.formatToUI(catNumPair.getFirst()) + "-" + formatter.formatToUI(catNumPair.getSecond());
                    if (this.objectsNotAdded.size() > 0) {
                        name = String.valueOf(name) + "-" + UIRegistry.getResourceString(CollectionObjectBusRules.IncompleteSaveFlag);
                    }
                    this.batchRS.setName(name);
                    for (Pair<Integer, String> obj : this.objectsAdded) {
                        this.batchRS.addItem(obj.getFirst());
                    }
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    boolean transOpen = false;
                    try {
                        BusinessRulesIFace busRule = DBTableIdMgr.getInstance().getBusinessRule(RecordSet.class);
                        if (busRule != null) {
                            busRule.beforeSave(this.batchRS, session);
                        }
                        this.batchRS.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
                        this.batchRS.setOwner(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
                        session.beginTransaction();
                        transOpen = true;
                        session.save(this.batchRS);
                        if (busRule != null && !busRule.beforeSaveCommit(this.batchRS, session)) {
                            session.rollback();
                            throw new Exception("Business rules processing failed");
                        }
                        session.commit();
                        transOpen = false;
                        if (busRule != null) {
                            busRule.afterSaveCommit(this.batchRS, session);
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(Uploader.class, ex);
                        if (!transOpen) break block7;
                        session.rollback();
                    }
                }
            }

            protected void addBatchRSToUI() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandAction cmd = new CommandAction("Record_Set", "AddToNavBox");
                        cmd.setData(batchRS);
                        CommandDispatcher.dispatch(cmd);
                    }
                });
            }

            @Override
            protected void done() {
                super.done();
                CollectionObjectBusRules.this.processingSeries.set(false);
                this.addBatchRSToUI();
                UIRegistry.clearSimpleGlassPaneMsg();
                if (this.objectsNotAdded.size() == 0) {
                    UIRegistry.displayLocalizedStatusBarText(CollectionObjectBusRules.BatchSaveSuccess, formatter.formatToUI(catNumPair.getFirst()), formatter.formatToUI(catNumPair.getSecond()));
                } else {
                    CollectionObjectBusRules.this.showBatchErrorObjects(this.objectsNotAdded, CollectionObjectBusRules.BatchSaveErrorsTitle, CollectionObjectBusRules.BatchSaveErrors);
                }
            }
        };
        final SimpleGlassPane gp = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getResourceString("CollectionObjectBusRules.SAVING_BATCH"), 24);
        gp.setProgress(0);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (CollectionObjectBusRules.GLASSKEY.equals(evt.getPropertyName())) {
                    double value = ((Integer)evt.getNewValue()).intValue();
                    int percent = (int)(value / (double)nums.size() * 100.0);
                    gp.setProgress(percent);
                }
            }
        });
        this.processingSeries.set(true);
        worker.execute();
    }

    @Override
    public void okToDelete(Object dataObjArg, DataProviderSessionIFace sessionArg, BusinessRulesOkDeleteIFace deletable) {
        this.reasonList.clear();
        boolean isOK = true;
        if (deletable != null && dataObjArg instanceof FormDataObjIFace && ((FormDataObjIFace)dataObjArg).getId() != null) {
            DataProviderSessionIFace session;
            Object dataObj;
            block15: {
                block14: {
                    Integer count = BasicSQLUtils.getCount("SELECT COUNT(*) FROM collectionobject WHERE CollectionObjectID = " + ((FormDataObjIFace)dataObjArg).getId());
                    if (count != null && count == 0) {
                        UIRegistry.showLocalizedMsg("NO_RECORD_FOUND_TITLE", "NO_RECORD_FOUND", new Object[0]);
                        return;
                    }
                    dataObj = dataObjArg;
                    session = sessionArg != null ? sessionArg : DataProviderFactory.getInstance().createSession();
                    try {
                        try {
                            dataObj = session.merge(dataObj);
                            CollectionObject colObj = (CollectionObject)dataObj;
                            if (!isOK) break block14;
                            for (Preparation prep : colObj.getPreparations()) {
                                if (prep == null) continue;
                                if (prep.getLoanPreparations() != null && !prep.getLoanPreparations().isEmpty()) {
                                    isOK = false;
                                    this.addDeleteReason(LoanPreparation.getClassTableId());
                                }
                                if (prep.getDeaccessionPreparations() != null && !prep.getDeaccessionPreparations().isEmpty()) {
                                    isOK = false;
                                    this.addDeleteReason(DeaccessionPreparation.getClassTableId());
                                }
                                if (isOK) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(CollectionObjectBusRules.class, ex);
                            ex.printStackTrace();
                            if (sessionArg == null && session != null) {
                                session.close();
                                session = null;
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (sessionArg == null && session != null) {
                            session.close();
                            session = null;
                        }
                        throw throwable;
                    }
                }
                if (sessionArg == null && session != null) {
                    session.close();
                    session = null;
                }
            }
            deletable.doDeleteDataObj(dataObj, session, isOK);
        } else {
            super.okToDelete(dataObjArg, sessionArg, deletable);
        }
    }

    @Override
    public boolean shouldCloneField(String fieldName) {
        if (fieldName.equals("collectingEvent")) {
            return AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent();
        }
        if (fieldName.equals("paleoContext")) {
            DisciplineType dt;
            Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
            return discipline != null && (dt = DisciplineType.getByName(discipline.getType())) != null && dt.isPaleo();
        }
        return fieldName.equals("collectionObjectAttribute");
    }

    protected boolean currentEntryIsASeries() {
        SeriesProcCatNumPlugin batchCtrl = this.getBatchPlugIn();
        return batchCtrl != null && batchCtrl.isExpanded();
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object parentDataObj, Object dataObj, boolean isEdit) {
        this.reasonList.clear();
        if (!(dataObj instanceof CollectionObject)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS duplicateNumberStatus = this.isCheckDuplicateNumberOK(CATNUMNAME, (FormDataObjIFace)dataObj, CollectionObject.class, "collectionObjectId");
        if (duplicateNumberStatus == BusinessRulesIFace.STATUS.OK && this.checkFieldNumberDupl) {
            duplicateNumberStatus = this.checkForFieldNumDup(dataObj);
        }
        if (!this.processingSeries.get()) {
            return this.isCheckDuplicateBatchNumbersOK(!duplicateNumberStatus.equals((Object)BusinessRulesIFace.STATUS.OK));
        }
        return duplicateNumberStatus;
    }

    private BusinessRulesIFace.STATUS checkForFieldNumDup(Object dataObj) {
        return this.isCheckDuplicateNumberOK("fieldNumber", (FormDataObjIFace)dataObj, CollectionObject.class, "collectionObjectId");
    }

    @Override
    public boolean isOkToAssociateSearchObject(Object parentdataObj, Object dataObjectFromSearch) {
        block3: {
            block2: {
                if (!(parentdataObj instanceof Accession)) break block2;
                this.reasonList.clear();
                Accession acc = (Accession)parentdataObj;
                CollectionObject colObj = (CollectionObject)dataObjectFromSearch;
                for (CollectionObject co : acc.getCollectionObjects()) {
                    if (!co.getId().equals(colObj.getId())) continue;
                    this.reasonList.add(UIRegistry.getLocalizedMessage("CO_DUP", colObj.getIdentityTitle()));
                    return false;
                }
                break block3;
            }
            if (!(parentdataObj instanceof Project)) break block3;
            this.reasonList.clear();
            Project prj = (Project)parentdataObj;
            CollectionObject colObj = (CollectionObject)dataObjectFromSearch;
            for (CollectionObject co : prj.getCollectionObjects()) {
                if (!co.getId().equals(colObj.getId())) continue;
                this.reasonList.add(UIRegistry.getLocalizedMessage("CO_DUP", colObj.getIdentityTitle()));
                return false;
            }
        }
        return true;
    }

    public static void fixDupColObjAttrs() {
        String sql = "SELECT * FROM (SELECT CollectionObjectAttributeID, count(*) as cnt FROM collectionobject c WHERE CollectionObjectAttributeID IS NOT NULL group by CollectionObjectAttributeID) T1 WHERE cnt > 1";
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        if (rows != null) {
            for (Object[] row : rows) {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        CollectionObjectAttribute colObjAttr = session.get(CollectionObjectAttribute.class, (Integer)row[1]);
                        int cnt = 0;
                        for (CollectionObject co : colObjAttr.getCollectionObjects()) {
                            if (cnt > 0) {
                                CollectionObjectAttribute colObjAttribute = (CollectionObjectAttribute)colObjAttr.clone();
                                co.setCollectionObjectAttribute(colObjAttribute);
                                colObjAttribute.getCollectionObjects().add(co);
                                session.beginTransaction();
                                session.saveOrUpdate(colObjAttribute);
                                session.saveOrUpdate(co);
                                session.commit();
                            }
                            ++cnt;
                        }
                    }
                    catch (Exception ex) {
                        session.rollback();
                        ex.printStackTrace();
                        if (session == null) continue;
                        session.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session == null) continue;
                session.close();
            }
        }
    }
}

