/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizard;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.busrules.DisciplineBusRules;
import edu.ku.brc.specify.datamodel.busrules.DivisionBusRules;
import edu.ku.brc.specify.dbsupport.HibernateDataProviderSession;
import edu.ku.brc.specify.dbsupport.SpecifyDeleteHelper;
import edu.ku.brc.specify.ui.DisciplineBasedUIFieldFormatterMgr;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class CollectionBusRules
extends BaseBusRules {
    private boolean isOKToCont = false;
    private HashMap<Integer, DisciplineBasedUIFieldFormatterMgr> fmtHash = new HashMap();

    public CollectionBusRules() {
        super(new Class[0]);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        AbstractButton newBtn = null;
        if (this.formViewObj != null) {
            ResultSetController rsc = this.formViewObj.getRsController();
            if (rsc != null) {
                if (this.formViewObj.getMVParent().isTopLevel()) {
                    if (rsc.getNewRecBtn() != null) {
                        rsc.getNewRecBtn().setVisible(false);
                    }
                    if (rsc.getDelRecBtn() != null) {
                        rsc.getDelRecBtn().setVisible(false);
                    }
                } else {
                    newBtn = rsc.getNewRecBtn();
                }
            }
            ValCheckBox chkBox = (ValCheckBox)this.formViewObj.getCompById("6");
            boolean showColEventChkbx = AppPreferences.getLocalPrefs().getBoolean("show.cecheckbox", false);
            chkBox.setVisible(showColEventChkbx);
        }
        if (newBtn != null) {
            ActionListener[] actionListenerArray = newBtn.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener al = actionListenerArray[n2];
                newBtn.removeActionListener(al);
                ++n2;
            }
            newBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectionBusRules.this.addNewCollection();
                }
            });
        }
    }

    private int getNameCount(String name) {
        return BasicSQLUtils.getCountAsInt(String.format("SELECT COUNT(*) FROM collection WHERE CollectionName = '%s'", name));
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        Component comp;
        this.reasonList.clear();
        if (this.formViewObj != null && (comp = this.formViewObj.getControlByName("collectionName")) instanceof ValTextField) {
            Collection collection = (Collection)this.formViewObj.getDataObj();
            Integer colId = collection.getId();
            String name = ((ValTextField)comp).getText();
            int cnt = this.getNameCount(name);
            if (cnt == 0 || cnt == 1 && colId != null) {
                return true;
            }
            this.reasonList.add(UIRegistry.getLocalizedMessage("COLLNAME_DUP", name));
        }
        return false;
    }

    private void addNewCollection() {
        if (!DivisionBusRules.checkForParentSave(this.formViewObj, Discipline.getClassTableId())) {
            return;
        }
        UIRegistry.loadAndPushResourceBundle("specifydbsetupwiz");
        UIRegistry.writeSimpleGlassPaneMsg("Building Collection...", 20);
        this.isOKToCont = true;
        final AppContextMgr acm = AppContextMgr.getInstance();
        final SpecifyDBSetupWizard wizardPanel = new SpecifyDBSetupWizard(SpecifyDBSetupWizard.WizardType.Collection, null);
        String msg = UIRegistry.getResourceString("CREATECOLL");
        final CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), "", true, 0, (Component)wizardPanel);
        dlg.setCustomTitleBar(msg);
        wizardPanel.setListener(new SpecifyDBSetupWizard.WizardListener(){

            @Override
            public void cancelled() {
                CollectionBusRules.this.isOKToCont = false;
                dlg.setVisible(false);
            }

            @Override
            public void finished() {
                dlg.setVisible(false);
            }

            @Override
            public void hide() {
                dlg.setVisible(false);
            }

            @Override
            public void panelChanged(String title) {
                dlg.setTitle(title);
            }
        });
        dlg.createUI();
        dlg.pack();
        UIHelper.centerAndShow(dlg);
        UIRegistry.popResourceBundle();
        if (!this.isOKToCont) {
            UIRegistry.clearSimpleGlassPaneMsg();
            return;
        }
        wizardPanel.processDataForNonBuild();
        final BuildSampleDatabase bldSampleDB = new BuildSampleDatabase();
        final ProgressFrame progressFrame = bldSampleDB.createProgressFrame(msg);
        progressFrame.turnOffOverAll();
        progressFrame.setProcess(0, 4);
        progressFrame.setProcessPercent(true);
        progressFrame.getCloseBtn().setVisible(false);
        progressFrame.setAlwaysOnTop(true);
        progressFrame.adjustProgressFrame();
        UIHelper.centerAndShow(progressFrame);
        SwingWorker<Integer, Integer> bldWorker = new SwingWorker<Integer, Integer>(){
            Collection newCollection = null;

            @Override
            protected Integer doInBackground() throws Exception {
                block8: {
                    Session session = null;
                    try {
                        try {
                            session = HibernateUtil.getNewSession();
                            HibernateDataProviderSession hSession = new HibernateDataProviderSession(session);
                            Discipline discipline = (Discipline)CollectionBusRules.this.formViewObj.getMVParent().getMultiViewParent().getData();
                            SpecifyUser specifyAdminUser = acm.getClassObject(SpecifyUser.class);
                            Agent userAgent = (Agent)hSession.getData("FROM Agent WHERE id = " + Agent.getUserAgent().getId());
                            Properties props = wizardPanel.getProps();
                            DisciplineType disciplineType = DisciplineType.getByName(discipline.getType());
                            discipline = (Discipline)session.merge((Object)discipline);
                            specifyAdminUser = (SpecifyUser)hSession.getData("FROM SpecifyUser WHERE id = " + specifyAdminUser.getId());
                            bldSampleDB.setSession(session);
                            AutoNumberingScheme catNumScheme = bldSampleDB.createAutoNumScheme(props, "catnumfmt", "Catalog Numbering Scheme", CollectionObject.getClassTableId());
                            this.newCollection = bldSampleDB.createEmptyCollection(discipline, props.getProperty("collPrefix").toString(), props.getProperty("collName").toString(), userAgent, specifyAdminUser, catNumScheme, disciplineType.isEmbeddedCollecingEvent());
                            acm.setClassObject(SpecifyUser.class, specifyAdminUser);
                            Agent.setUserAgent(userAgent);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (session != null) {
                                session.close();
                            }
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                    if (session != null) {
                        session.close();
                    }
                }
                bldSampleDB.setDataType(null);
                return null;
            }

            @Override
            protected void done() {
                super.done();
                progressFrame.setVisible(false);
                progressFrame.dispose();
                if (this.newCollection != null) {
                    FormViewObj dispFVO;
                    List<?> dataItems;
                    block11: {
                        dataItems = null;
                        dispFVO = CollectionBusRules.this.formViewObj.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
                        Discipline discipline = (Discipline)dispFVO.getDataObj();
                        DataProviderSessionIFace pSession = null;
                        try {
                            try {
                                pSession = DataProviderFactory.getInstance().createSession();
                                discipline = (Discipline)pSession.getData("FROM Discipline WHERE id = " + discipline.getId());
                                acm.setClassObject(Discipline.class, discipline);
                                dataItems = pSession.getDataList("FROM Discipline");
                                if (dataItems.get(0) instanceof Object[]) {
                                    Vector dataList = new Vector();
                                    for (Object row : dataItems) {
                                        Object[] cols = (Object[])row;
                                        dataList.add(cols[0]);
                                    }
                                    dataItems = dataList;
                                }
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                                ex.printStackTrace();
                                if (pSession != null) {
                                    pSession.close();
                                }
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            if (pSession != null) {
                                pSession.close();
                            }
                            throw throwable;
                        }
                        if (pSession != null) {
                            pSession.close();
                        }
                    }
                    int curInx = dispFVO.getRsController().getCurrentIndex();
                    dispFVO.setDataObj(dataItems);
                    dispFVO.getRsController().setIndex(curInx);
                    UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
                    CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
                }
                UIRegistry.clearSimpleGlassPaneMsg();
            }
        };
        bldWorker.execute();
    }

    @Override
    public Object beforeDelete(Object dataObj, DataProviderSessionIFace session) {
        return super.beforeDelete(dataObj, session);
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        super.beforeMerge(dataObj, session);
        Collection collection = (Collection)dataObj;
        for (AutoNumberingScheme ans : collection.getNumberingSchemes()) {
            try {
                session.saveOrUpdate(ans);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(CollectionBusRules.class, ex);
            }
        }
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        this.beforeMerge(dataObj, session);
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        Collection collection = (Collection)dataObj;
        Discipline appCntxtDiscipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        JTextField txt = (JTextField)this.formViewObj.getControlById("4");
        if (txt != null && collection != null && collection.getId() != null) {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    Collection coll = session.get(Collection.class, collection.getId());
                    if (coll != null) {
                        Discipline discipline = coll.getDiscipline();
                        Set<AutoNumberingScheme> set = coll.getNumberingSchemes();
                        if (set != null && set.size() > 0) {
                            UIFieldFormatterMgr ffMgr = null;
                            if (discipline.getId().equals(appCntxtDiscipline.getId())) {
                                ffMgr = UIFieldFormatterMgr.getInstance();
                            } else {
                                Integer dispId = coll.getDiscipline().getId();
                                DisciplineBasedUIFieldFormatterMgr tempFFMgr = this.fmtHash.get(dispId);
                                if (tempFFMgr == null) {
                                    tempFFMgr = new DisciplineBasedUIFieldFormatterMgr(dispId);
                                    tempFFMgr.load();
                                    this.fmtHash.put(dispId, tempFFMgr);
                                }
                                ffMgr = tempFFMgr;
                            }
                            AutoNumberingScheme ans = set.iterator().next();
                            if (ans != null) {
                                UIFieldFormatterIFace fmt = ffMgr.getFormatter(ans.getFormatName());
                                txt.setText(String.valueOf(ans.getIdentityTitle()) + (fmt != null ? " (" + fmt.toPattern() + ")" : ""));
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(CollectionBusRules.class, ex);
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    @Override
    public void addChildrenToNewDataObjects(Object newDataObj) {
        super.addChildrenToNewDataObjects(newDataObj);
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (!(dataObj instanceof Collection)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS nameStatus = this.isCheckDuplicateNumberOK("collectionName", (FormDataObjIFace)dataObj, Collection.class, "userGroupScopeId", false);
        BusinessRulesIFace.STATUS titleStatus = this.isCheckDuplicateNumberOK("collectionPrefix", (FormDataObjIFace)dataObj, Collection.class, "userGroupScopeId", true, false);
        return nameStatus != BusinessRulesIFace.STATUS.OK || titleStatus != BusinessRulesIFace.STATUS.OK ? BusinessRulesIFace.STATUS.Error : BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        if (dataObj != null) {
            Collection col = AppContextMgr.getInstance().getClassObject(Collection.class);
            Collection dataCol = (Collection)dataObj;
            if (col.getId() != null && dataCol.getId() != null && col.getId().equals(dataCol.getId())) {
                return false;
            }
            this.reasonList.clear();
            boolean isOK = this.okToDelete("collectionobject", "CollectionID", ((FormDataObjIFace)dataObj).getId());
            if (!isOK) {
                return false;
            }
            Collection collection = (Collection)dataObj;
            String colMemName = "CollectionMemberID";
            Vector<String> tableList = new Vector<String>();
            block0: for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                for (DBFieldInfo fi : ti.getFields()) {
                    String colName = fi.getColumn();
                    if (!StringUtils.isNotEmpty((String)colName) || !colName.equals(colMemName)) continue;
                    tableList.add(ti.getName());
                    continue block0;
                }
            }
            int inx = 0;
            String[] tableFieldNamePairs = new String[tableList.size() * 2];
            for (String tableName : tableList) {
                tableFieldNamePairs[inx++] = tableName;
                tableFieldNamePairs[inx++] = colMemName;
            }
            isOK = this.okToDelete(tableFieldNamePairs, collection.getId());
            return isOK;
        }
        return false;
    }

    @Override
    public void okToDelete(Object dataObj, DataProviderSessionIFace session, BusinessRulesOkDeleteIFace deletable) {
        this.reasonList.clear();
        if (deletable != null) {
            Collection collection = (Collection)dataObj;
            Integer id = collection.getId();
            if (id != null) {
                Collection currCollection = AppContextMgr.getInstance().getClassObject(Collection.class);
                if (currCollection.getId().equals(collection.getId())) {
                    UIRegistry.showLocalizedError("CollectionBusRule.CURR_COL_ERR");
                } else {
                    DataProviderSessionIFace pSession = null;
                    try {
                        pSession = session != null ? session : DataProviderFactory.getInstance().createSession();
                        pSession.attach(collection);
                        if (collection.getLeftSideRelTypes().size() > 0 || collection.getRightSideRelTypes().size() > 0) {
                            if (pSession != null && session == null) {
                                pSession.close();
                            }
                            UIRegistry.showLocalizedError("CollectionBusRule.RELS_ERR");
                            return;
                        }
                        pSession.beginTransaction();
                        Set<AutoNumberingScheme> colANSSet = collection.getNumberingSchemes();
                        for (AutoNumberingScheme ans : new Vector<AutoNumberingScheme>(colANSSet)) {
                            pSession.attach(ans);
                        }
                        for (AutoNumberingScheme ans : new Vector<AutoNumberingScheme>(colANSSet)) {
                            pSession.attach(ans);
                            colANSSet.remove(ans);
                            ans.getCollections().remove(collection);
                            if (ans.getCollections().size() != 0) continue;
                            pSession.delete(ans);
                        }
                        pSession.saveOrUpdate(collection);
                        pSession.commit();
                        final Integer collId = collection.getId();
                        final SpecifyDeleteHelper delHelper = new SpecifyDeleteHelper();
                        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){

                            @Override
                            protected Integer doInBackground() throws Exception {
                                try {
                                    delHelper.delRecordFromTable(Collection.class, collId, true);
                                    delHelper.done(false);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(DivisionBusRules.class, ex);
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                super.done();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (CollectionBusRules.this.formViewObj != null) {
                                            CollectionBusRules.this.formViewObj.updateAfterRemove(true);
                                        }
                                        UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
                                        CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
                                    }
                                });
                            }
                        };
                        String title = String.format("%s %s %s", UIRegistry.getResourceString("DELETING"), DBTableIdMgr.getInstance().getTitleForId(Collection.getClassTableId()), collection.getCollectionName());
                        JDialog dlg = delHelper.initProgress(worker, title);
                        worker.execute();
                        UIHelper.centerAndShow(dlg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(DisciplineBusRules.class, ex);
                    }
                }
            } else {
                super.okToDelete(dataObj, session, deletable);
            }
        } else {
            super.okToDelete(dataObj, session, deletable);
        }
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        AppContextMgr.getInstance().setClassObject(Collection.class, dataObj);
        return super.afterSaveCommit(dataObj, session);
    }

    @Override
    public void aboutToShutdown() {
        super.aboutToShutdown();
        for (DisciplineBasedUIFieldFormatterMgr mgr : this.fmtHash.values()) {
            mgr.shutdown();
        }
    }
}

