/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpTaskSemaphore;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.specify.datamodel.busrules.TreeableSearchQueryBuilder;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgrCallerIFace;
import edu.ku.brc.specify.treeutils.TreeDataService;
import edu.ku.brc.specify.treeutils.TreeDataServiceFactory;
import edu.ku.brc.specify.treeutils.TreeHelper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Rankable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class BaseTreeBusRules<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends AttachmentOwnerBaseBusRules {
    public static final boolean ALLOW_CONCURRENT_FORM_ACCESS = true;
    private static final Logger log = Logger.getLogger(BaseTreeBusRules.class);
    private boolean processedRules = false;

    public BaseTreeBusRules(Class<?> ... dataClasses) {
        super(dataClasses);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        GetSetValueIFace parentField = (GetSetValueIFace)((Object)this.formViewObj.getControlByName("parent"));
        Component comp = this.formViewObj.getControlByName("definitionItem");
        if (comp instanceof ValComboBox) {
            ValComboBoxFromQuery parentCBX;
            ValComboBoxFromQuery acceptedParentWidget;
            final ValComboBox rankComboBox = (ValComboBox)comp;
            final JCheckBox acceptedCheckBox = (JCheckBox)this.formViewObj.getControlByName("isAccepted");
            Component apComp = this.formViewObj.getControlByName("acceptedParent");
            ValComboBoxFromQuery valComboBoxFromQuery = acceptedParentWidget = apComp instanceof ValComboBoxFromQuery ? (ValComboBoxFromQuery)apComp : null;
            if (parentField instanceof ValComboBoxFromQuery && (parentCBX = (ValComboBoxFromQuery)parentField) != null && rankComboBox != null) {
                parentCBX.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (e == null || !e.getValueIsAdjusting()) {
                            BaseTreeBusRules.this.parentChanged(BaseTreeBusRules.this.formViewObj, parentCBX, rankComboBox, acceptedCheckBox, acceptedParentWidget);
                        }
                    }
                });
                rankComboBox.getComboBox().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BaseTreeBusRules.this.rankChanged(BaseTreeBusRules.this.formViewObj, parentCBX, rankComboBox, acceptedCheckBox, acceptedParentWidget);
                    }
                });
            }
            if (acceptedCheckBox != null && acceptedParentWidget != null) {
                acceptedCheckBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (acceptedCheckBox.isSelected()) {
                            acceptedParentWidget.setValue(null, null);
                            acceptedParentWidget.setChanged(true);
                            acceptedParentWidget.setEnabled(false);
                        } else {
                            acceptedParentWidget.setEnabled(true);
                        }
                    }
                });
            }
        }
    }

    public abstract String[] getRelatedTableAndColumnNames();

    public String[] getAllRelatedTableAndColumnNames() {
        return this.getRelatedTableAndColumnNames();
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        TreeDefItemIface treeDefItem;
        String viewName = this.formViewObj.getView().getName();
        if (StringUtils.contains((String)viewName, (String)"TreeDef") && (treeDefItem = (TreeDefItemIface)dataObj) != null && treeDefItem.getTreeDef() != null) {
            return treeDefItem.getTreeDef().isRequiredLevel(treeDefItem.getRankId());
        }
        return super.okToEnableDelete(dataObj);
    }

    public boolean okToDeleteNode(T node) {
        List<?> childIDs;
        String[] relationships;
        block14: {
            if (node.getDefinition() != null && !node.getDefinition().getNodeNumbersAreUpToDate() && !node.getDefinition().isUploadInProgress()) {
                throw new RuntimeException(String.valueOf(node.getDefinition().getName()) + " has out of date node numbers.");
            }
            if (node.getDefinition() != null && node.getDefinition().isUploadInProgress()) {
                return true;
            }
            Integer id = node.getTreeId();
            if (id == null) {
                return true;
            }
            relationships = this.getRelatedTableAndColumnNames();
            if (!super.okToDelete(relationships, node.getTreeId())) {
                return false;
            }
            DataProviderSessionIFace session = null;
            childIDs = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    String queryStr = "SELECT n.id FROM " + node.getClass().getName() + " n WHERE n.nodeNumber <= :highChild AND n.nodeNumber > :nodeNum ORDER BY n.rankId DESC";
                    DataProviderSessionIFace.QueryIFace query = session.createQuery(queryStr, false);
                    query.setParameter("highChild", node.getHighestChildNodeNumber());
                    query.setParameter("nodeNum", node.getNodeNumber());
                    childIDs = query.list();
                }
                catch (Exception ex) {
                    ExceptionTracker.getInstance().capture(BaseTreeBusRules.class, ex);
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        if (childIDs != null && childIDs.size() == 0) {
            return true;
        }
        int chunkSize = 250;
        int lastRecordChecked = -1;
        boolean childrenDeletable = true;
        while (lastRecordChecked + 1 < childIDs.size() && childrenDeletable) {
            int startOfChunk = lastRecordChecked + 1;
            int endOfChunk = Math.min(lastRecordChecked + 1 + chunkSize, childIDs.size());
            List<?> chunk = childIDs.subList(startOfChunk, endOfChunk);
            Integer[] idChunk = chunk.toArray(new Integer[1]);
            childrenDeletable = super.okToDelete(relationships, idChunk);
            lastRecordChecked = endOfChunk - 1;
        }
        return childrenDeletable;
    }

    @Override
    protected String getExtraWhereColumns(DBTableInfo tableInfo) {
        Vector<Object> cols;
        String result = super.getExtraWhereColumns(tableInfo);
        if (CollectionMember.class.isAssignableFrom(tableInfo.getClassObj()) && (cols = BasicSQLUtils.querySingleCol("select distinct CollectionID from collection where DisciplineID = " + AppContextMgr.getInstance().getClassObject(Discipline.class).getId())) != null) {
            String colList = "";
            for (Object col : cols) {
                if (!"".equals(colList)) {
                    colList = String.valueOf(colList) + ",";
                }
                colList = String.valueOf(colList) + col;
            }
            if (!"".equals(colList)) {
                result = "((" + result + ") or " + tableInfo.getAbbrev() + ".CollectionMemberID in(" + colList + "))";
            }
        }
        return result;
    }

    protected void rankChanged(final FormViewObj form, ValComboBoxFromQuery parentComboBox, ValComboBox rankComboBox, final JCheckBox acceptedCheckBox, final ValComboBoxFromQuery acceptedParentWidget) {
        if (form.getAltView().getMode() != AltViewIFace.CreationMode.EDIT) {
            return;
        }
        Object objInForm = form.getDataObj();
        if (objInForm == null) {
            return;
        }
        final Treeable formNode = (Treeable)objInForm;
        Treeable parent = null;
        if (parentComboBox.getValue() instanceof String) {
            log.debug((Object)("Form is in mode (" + (Object)((Object)form.getAltView().getMode()) + ") but the parent data is a String"));
            parentComboBox.getValue();
            parent = formNode.getParent();
        } else {
            parent = (Treeable)parentComboBox.getValue();
        }
        final Treeable theParent = parent;
        TreeDefItemIface rankObj = (TreeDefItemIface)rankComboBox.getValue();
        final int rank = rankObj == null ? -2 : rankObj.getRankId();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean canSynonymize = false;
                if (BaseTreeBusRules.this.canAccessSynonymy(formNode, rank)) {
                    boolean bl = canSynonymize = formNode.getDefinition() != null && formNode.getDefinition().getSynonymizedLevel() <= rank && formNode.getDescendantCount() == 0;
                }
                if (acceptedCheckBox != null && acceptedParentWidget != null) {
                    acceptedCheckBox.setEnabled(canSynonymize && theParent != null);
                    if (acceptedCheckBox.isSelected() && acceptedCheckBox.isEnabled()) {
                        acceptedParentWidget.setValue(null, null);
                        acceptedParentWidget.setChanged(true);
                        acceptedParentWidget.setEnabled(false);
                    }
                }
                form.getValidator().validateForm();
            }
        });
    }

    protected void parentChanged(final FormViewObj form, final ValComboBoxFromQuery parentComboBox, final ValComboBox rankComboBox, final JCheckBox acceptedCheckBox, final ValComboBoxFromQuery acceptedParentWidget) {
        if (form.getAltView().getMode() != AltViewIFace.CreationMode.EDIT) {
            return;
        }
        Object objInForm = form.getDataObj();
        if (objInForm == null) {
            return;
        }
        Treeable formNode = (Treeable)objInForm;
        this.adjustRankComboBoxModel(parentComboBox, rankComboBox, formNode);
        Treeable parent = null;
        if (parentComboBox.getValue() instanceof String) {
            log.debug((Object)("Form is in mode (" + (Object)((Object)form.getAltView().getMode()) + ") but the parent data is a String"));
            parentComboBox.getValue();
            parent = formNode.getParent();
        } else {
            parent = (Treeable)parentComboBox.getValue();
        }
        if (parent != null) {
            formNode.setDefinition(parent.getDefinition());
            formNode.setParent(parent);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean rnkEnabled = rankComboBox.getComboBox().getModel().getSize() > 0;
                rankComboBox.setEnabled(rnkEnabled);
                JLabel label = form.getLabelFor(rankComboBox);
                if (label != null) {
                    label.setEnabled(rnkEnabled);
                }
                if (rankComboBox.hasFocus() && !rnkEnabled) {
                    parentComboBox.requestFocus();
                }
                BaseTreeBusRules.this.rankChanged(BaseTreeBusRules.this.formViewObj, parentComboBox, rankComboBox, acceptedCheckBox, acceptedParentWidget);
                form.getValidator().validateForm();
            }
        });
    }

    protected void adjustRankComboBoxModel(GetSetValueIFace parentField, ValComboBox rankComboBox, T nodeInForm) {
        log.debug((Object)"Adjusting the model for the 'rank' combo box in a tree node form");
        log.debug((Object)("nodeInForm = " + nodeInForm.getName()));
        if (nodeInForm == null) {
            return;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)rankComboBox.getModel();
        model.removeAllElements();
        TreeDefItemIface topItem = null;
        Rankable bottomItem = null;
        Object value = parentField.getValue();
        Treeable parent = null;
        parent = value instanceof String ? (Treeable)nodeInForm.getParent() : (Treeable)parentField.getValue();
        if (parent == null) {
            return;
        }
        topItem = (TreeDefItemIface)parent.getDefinitionItem().getChild();
        log.debug((Object)("highest valid tree level: " + topItem));
        if (topItem == null) {
            log.warn((Object)"Chosen node cannot be a parent node.  It is at the lowest defined level of the tree.");
            return;
        }
        if (!nodeInForm.getChildren().isEmpty()) {
            for (Treeable child : nodeInForm.getChildren()) {
                if (bottomItem != null && child.getRankId() <= bottomItem.getRankId()) continue;
                bottomItem = (Rankable)child.getDefinitionItem().getParent();
            }
        }
        log.debug((Object)("lowest valid tree level:  " + bottomItem));
        TreeDefItemIface item = topItem;
        boolean done = false;
        while (!done) {
            model.addElement(item);
            if (item.getChild() == null || item.getIsEnforced() == Boolean.TRUE || bottomItem != null && item.getRankId().intValue() == bottomItem.getRankId().intValue()) {
                done = true;
            }
            item = item.getChild();
        }
        if (nodeInForm.getDefinitionItem() != null) {
            Object defItem = nodeInForm.getDefinitionItem();
            int i = 0;
            while (i < model.getSize()) {
                TreeDefItemIface modelItem = (TreeDefItemIface)model.getElementAt(i);
                if (modelItem.getRankId().equals(defItem.getRankId())) {
                    log.debug((Object)("setting rank selected value to " + modelItem));
                    model.setSelectedItem(modelItem);
                }
                ++i;
            }
        } else if (model.getSize() == 1) {
            Object defItem = model.getElementAt(0);
            log.debug((Object)("setting rank selected value to the only available option: " + defItem));
            model.setSelectedItem(defItem);
        }
    }

    @Override
    public void afterFillForm(Object dataObj) {
        String viewName = this.formViewObj.getView().getName();
        if (StringUtils.contains((String)viewName, (String)"TreeDef")) {
            if (this.formViewObj.getAltView().getMode() != AltViewIFace.CreationMode.EDIT) {
                return;
            }
            if (!StringUtils.contains((String)viewName, (String)"TreeDefItem")) {
                return;
            }
            TreeDefItemIface nodeInForm = (TreeDefItemIface)this.formViewObj.getDataObj();
            if (nodeInForm != null && nodeInForm.getTreeDef() != null) {
                if (!viewName.endsWith("TreeDefItem")) {
                    return;
                }
                List<TreeDefItemStandardEntry> stds = nodeInForm.getTreeDef().getStandardLevels();
                TreeDefItemStandardEntry stdLevel = null;
                for (TreeDefItemStandardEntry std : stds) {
                    if (std.getRank() != nodeInForm.getRankId().intValue()) continue;
                    stdLevel = std;
                    break;
                }
                if (stdLevel != null) {
                    Component enforcedCtrl;
                    ValTextField nameCtrl = (ValTextField)this.formViewObj.getControlByName("name");
                    Component rankCtrl = this.formViewObj.getControlByName("rankId");
                    if (nameCtrl != null) {
                        nameCtrl.setEnabled(false);
                    }
                    if (rankCtrl != null) {
                        rankCtrl.setEnabled(false);
                    }
                    if (nodeInForm.getTreeDef().isRequiredLevel(stdLevel.getRank()) && (enforcedCtrl = this.formViewObj.getControlByName("isEnforced")) != null) {
                        enforcedCtrl.setEnabled(false);
                    }
                }
            }
            return;
        }
        Treeable nodeInForm = (Treeable)this.formViewObj.getDataObj();
        if (this.formViewObj.getAltView().getMode() != AltViewIFace.CreationMode.EDIT) {
            Component comp;
            if (nodeInForm != null && (comp = this.formViewObj.getControlByName("definitionItem")) instanceof JTextField) {
                ((JTextField)comp).setText(nodeInForm.getDefinitionItem().getName());
            }
        } else {
            this.processedRules = false;
            GetSetValueIFace parentField = (GetSetValueIFace)((Object)this.formViewObj.getControlByName("parent"));
            Component comp = this.formViewObj.getControlByName("definitionItem");
            if (comp instanceof ValComboBox) {
                ValComboBoxFromQuery parentCBX;
                ValComboBox rankComboBox = (ValComboBox)comp;
                if (parentField instanceof ValComboBoxFromQuery && (parentCBX = (ValComboBoxFromQuery)parentField) != null && rankComboBox != null && nodeInForm != null) {
                    parentCBX.registerQueryBuilder(new TreeableSearchQueryBuilder(nodeInForm, rankComboBox, 0));
                }
                if (nodeInForm != null && nodeInForm.getDefinitionItem() != null) {
                    UIValidator.setIgnoreAllValidation(this, true);
                    this.adjustRankComboBoxModel(parentField, rankComboBox, nodeInForm);
                    UIValidator.setIgnoreAllValidation(this, false);
                }
                JCheckBox acceptedCheckBox = (JCheckBox)this.formViewObj.getControlByName("isAccepted");
                ValComboBoxFromQuery acceptedParentWidget = (ValComboBoxFromQuery)this.formViewObj.getControlByName("acceptedParent");
                if (this.canAccessSynonymy(nodeInForm)) {
                    if (acceptedCheckBox != null && acceptedParentWidget != null) {
                        if (acceptedCheckBox.isSelected() && nodeInForm != null && nodeInForm.getDefinition() != null) {
                            boolean canSynonymize = nodeInForm.getDefinition().getSynonymizedLevel() <= nodeInForm.getRankId() && nodeInForm.getDescendantCount() == 0;
                            acceptedCheckBox.setEnabled(canSynonymize);
                        }
                        acceptedParentWidget.setEnabled(!acceptedCheckBox.isSelected() && acceptedCheckBox.isEnabled());
                        if (acceptedCheckBox.isSelected()) {
                            acceptedParentWidget.setValue(null, null);
                        }
                        if (nodeInForm != null && acceptedParentWidget != null && rankComboBox != null) {
                            acceptedParentWidget.registerQueryBuilder(new TreeableSearchQueryBuilder(nodeInForm, rankComboBox, 1));
                        }
                    }
                } else {
                    if (acceptedCheckBox != null) {
                        acceptedCheckBox.setEnabled(false);
                    }
                    if (acceptedParentWidget != null) {
                        acceptedParentWidget.setEnabled(false);
                    }
                }
                if (parentField instanceof ValComboBoxFromQuery) {
                    this.parentChanged(this.formViewObj, (ValComboBoxFromQuery)parentField, rankComboBox, acceptedCheckBox, acceptedParentWidget);
                }
            }
        }
    }

    protected String getSqlSelectTemplate(DBTableInfo tableInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("select %s1 FROM ");
        sb.append(tableInfo.getClassName());
        sb.append(" as ");
        sb.append(tableInfo.getAbbrev());
        String joinSnipet = QueryAdjusterForDomain.getInstance().getJoinClause(tableInfo, true, null, false);
        if (joinSnipet != null) {
            sb.append(' ');
            sb.append(joinSnipet);
        }
        sb.append(' ');
        return sb.toString();
    }

    protected boolean canAccessSynonymy(T dataObj) {
        if (dataObj == null) {
            return false;
        }
        if (dataObj.getChildren().size() > 0) {
            return false;
        }
        Object defItem = dataObj.getDefinitionItem();
        if (defItem == null) {
            return false;
        }
        Object def = dataObj.getDefinition();
        if (def == null) {
            def = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefForClass(dataObj.getClass());
        }
        if (!def.isSynonymySupported()) {
            return false;
        }
        return defItem.getRankId() >= def.getSynonymizedLevel();
    }

    protected boolean canAccessSynonymy(T dataObj, int rank) {
        if (dataObj == null) {
            return false;
        }
        if (dataObj.getChildren().size() > 0) {
            return false;
        }
        TreeDefIface<?, ?, ?> def = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefForClass(dataObj.getClass());
        if (!def.isSynonymySupported()) {
            return false;
        }
        return rank >= def.getSynonymizedLevel();
    }

    protected void updateFullNamesIfNecessary(T node, DataProviderSessionIFace session) {
        boolean rankChanged;
        if (node.getTreeId() == null) {
            return;
        }
        boolean updateNodeFullName = false;
        boolean updateDescFullNames = false;
        DataProviderSessionIFace tmpSession = DataProviderFactory.getInstance().createSession();
        Treeable fromDB = (Treeable)tmpSession.get(node.getClass(), node.getTreeId());
        tmpSession.close();
        if (fromDB == null) {
            fromDB = node;
        }
        Object origParent = fromDB.getParent();
        boolean parentChanged = false;
        Object currentParent = node.getParent();
        if (currentParent == null && origParent != null || currentParent != null && origParent == null) {
            parentChanged = true;
        }
        if (currentParent != null && origParent != null && !currentParent.getTreeId().equals(origParent.getTreeId())) {
            parentChanged = true;
        }
        boolean higherLevelsIncluded = false;
        if (parentChanged) {
            higherLevelsIncluded = this.higherLevelsIncludedInFullname(node);
            higherLevelsIncluded |= this.higherLevelsIncludedInFullname(fromDB);
        }
        if (parentChanged && higherLevelsIncluded) {
            updateNodeFullName = true;
            updateDescFullNames = true;
        }
        boolean nameChanged = !fromDB.getName().equals(node.getName());
        boolean bl = rankChanged = !fromDB.getRankId().equals(node.getRankId());
        if (rankChanged || nameChanged) {
            updateNodeFullName = true;
            if (this.booleanValue(fromDB.getDefinitionItem().getIsInFullName(), false)) {
                updateDescFullNames = true;
            }
            if (this.booleanValue(node.getDefinitionItem().getIsInFullName(), false)) {
                updateDescFullNames = true;
            }
        } else if (fromDB == node) {
            updateNodeFullName = true;
        }
        if (updateNodeFullName) {
            if (updateDescFullNames) {
                TreeHelper.fixFullnameForNodeAndDescendants(node);
            } else {
                String fullname = TreeHelper.generateFullname(node);
                node.setFullName(fullname);
            }
        }
    }

    protected boolean higherLevelsIncludedInFullname(T node) {
        boolean higherLevelsIncluded = false;
        Object l = node.getParent();
        while (l != null) {
            if (l.getDefinitionItem().getIsInFullName() != null && l.getDefinitionItem().getIsInFullName().booleanValue()) {
                higherLevelsIncluded = true;
                break;
            }
            l = l.getParent();
        }
        return higherLevelsIncluded;
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        if (dataObj instanceof Treeable) {
            Treeable node = (Treeable)dataObj;
            if (!node.getDefinition().getNodeNumbersAreUpToDate() && !node.getDefinition().isUploadInProgress()) {
                throw new RuntimeException(String.valueOf(node.getDefinition().getName()) + " has out of date node numbers.");
            }
            String fullname = TreeHelper.generateFullname(node);
            node.setFullName(fullname);
        }
    }

    @Override
    public boolean beforeSaveCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        if (!super.beforeSaveCommit(dataObj, session)) {
            return false;
        }
        boolean success = true;
        if (dataObj instanceof Treeable) {
            boolean added;
            Treeable node = (Treeable)dataObj;
            if (!node.getDefinition().getNodeNumbersAreUpToDate() && !node.getDefinition().isUploadInProgress()) {
                throw new RuntimeException(String.valueOf(node.getDefinition().getName()) + " has out of date node numbers.");
            }
            boolean bl = added = node.getNodeNumber() == null;
            if (node.getDefinition().getDoNodeNumberUpdates() && node.getDefinition().getNodeNumbersAreUpToDate()) {
                log.info((Object)"Saved tree node was added.  Updating node numbers appropriately.");
                TreeDataService dataServ = TreeDataServiceFactory.createService();
                success = added ? dataServ.updateNodeNumbersAfterNodeAddition(node, session) : dataServ.updateNodeNumbersAfterNodeEdit(node, session);
            } else {
                node.getDefinition().setNodeNumbersAreUpToDate(false);
            }
        }
        return success;
    }

    @Override
    public boolean beforeDeleteCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        if (!super.beforeDeleteCommit(dataObj, session)) {
            return false;
        }
        if (this.viewable != null) {
            return this.getRequiredLocks();
        }
        return true;
    }

    @Override
    public void afterDeleteCommit(Object dataObj) {
        block13: {
            try {
                if (!(dataObj instanceof Treeable)) break block13;
                Treeable node = (Treeable)dataObj;
                if (!node.getDefinition().getNodeNumbersAreUpToDate() && !node.getDefinition().isUploadInProgress()) {
                    throw new RuntimeException(String.valueOf(node.getDefinition().getName()) + " has out of date node numbers.");
                }
                if (node.getDefinition().getDoNodeNumberUpdates() && node.getDefinition().getNodeNumbersAreUpToDate()) {
                    log.info((Object)"A tree node was deleted.  Updating node numbers appropriately.");
                    TreeDataService dataServ = TreeDataServiceFactory.createService();
                    DataProviderSessionIFace session = null;
                    try {
                        try {
                            session = DataProviderFactory.getInstance().createSession();
                            dataServ.updateNodeNumbersAfterNodeDeletion(node, session);
                        }
                        catch (Exception ex) {
                            ExceptionTracker.getInstance().capture(BaseTreeBusRules.class, ex);
                            ex.printStackTrace();
                            if (session != null) {
                                session.close();
                            }
                            break block13;
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                node.getDefinition().setNodeNumbersAreUpToDate(false);
            }
            finally {
                if (this.viewable != null) {
                    this.freeLocks();
                }
            }
        }
    }

    protected void beforeSaveTreeDefItem(I defItem) {
        boolean sepChanged;
        DataProviderSessionIFace tmpSession = DataProviderFactory.getInstance().createSession();
        TreeDefItemIface fromDB = (TreeDefItemIface)tmpSession.load(defItem.getClass(), defItem.getTreeDefItemId());
        tmpSession.close();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        session.attach(defItem);
        boolean changeThisLevel = false;
        boolean changeAllDescendants = false;
        boolean fromDBIsInFullname = this.makeNotNull(fromDB.getIsInFullName());
        boolean currentIsInFullname = this.makeNotNull(defItem.getIsInFullName());
        if (fromDBIsInFullname != currentIsInFullname) {
            changeAllDescendants = true;
        }
        String fromDbBeforeText = this.makeNotNull(fromDB.getTextBefore());
        String fromDbAfterText = this.makeNotNull(fromDB.getTextAfter());
        String fromDbSeparator = this.makeNotNull(fromDB.getFullNameSeparator());
        String before = this.makeNotNull(defItem.getTextBefore());
        String after = this.makeNotNull(defItem.getTextAfter());
        String separator = this.makeNotNull(defItem.getFullNameSeparator());
        boolean textFieldChanged = false;
        boolean beforeChanged = !before.equals(fromDbBeforeText);
        boolean afterChanged = !after.equals(fromDbAfterText);
        boolean bl = sepChanged = !separator.equals(fromDbSeparator);
        if (beforeChanged || afterChanged || sepChanged) {
            textFieldChanged = true;
        }
        if (textFieldChanged) {
            if (currentIsInFullname) {
                changeAllDescendants = true;
            }
            changeThisLevel = true;
        }
        if (changeThisLevel && !changeAllDescendants) {
            Set levelNodes = defItem.getTreeEntries();
            for (Treeable node : levelNodes) {
                String generated = TreeHelper.generateFullname(node);
                node.setFullName(generated);
            }
        } else if (changeThisLevel && changeAllDescendants) {
            Set levelNodes = defItem.getTreeEntries();
            for (Treeable node : levelNodes) {
                TreeHelper.fixFullnameForNodeAndDescendants(node);
            }
        } else if (!changeThisLevel && changeAllDescendants) {
            Set levelNodes = defItem.getTreeEntries();
            for (Treeable node : levelNodes) {
                for (Treeable child : node.getChildren()) {
                    TreeHelper.fixFullnameForNodeAndDescendants(child);
                }
            }
        }
        session.close();
    }

    protected boolean booleanValue(Boolean bool, boolean defaultIfNull) {
        if (bool != null) {
            return bool;
        }
        return defaultIfNull;
    }

    private String makeNotNull(String s) {
        return s == null ? "" : s;
    }

    private boolean makeNotNull(Boolean b) {
        return b == null ? false : b;
    }

    @Override
    public Object beforeDelete(Object dataObj, DataProviderSessionIFace session) {
        Treeable node;
        super.beforeDelete(dataObj, session);
        if (dataObj instanceof Treeable && (node = (Treeable)dataObj).getAcceptedParent() != null) {
            ((Treeable)node.getAcceptedParent()).getAcceptedChildren().remove(node);
            node.setAcceptedParent(null);
        }
        return dataObj;
    }

    protected boolean parentHasChildWithSameName(Object parentDataObj, Object dataObj) {
        if (dataObj instanceof Treeable) {
            Object parent;
            Treeable node = (Treeable)dataObj;
            Object object = parent = parentDataObj == null ? node.getParent() : (Treeable)parentDataObj;
            if (parent != null) {
                String tblName = DBTableIdMgr.getInstance().getInfoById(node.getTableId()).getName();
                String sql = "SELECT count(*) FROM " + tblName + " where isAccepted " + "and name = " + BasicSQLUtils.getEscapedSQLStrExpr(node.getName());
                if (parent.getTreeId() != null) {
                    sql = String.valueOf(sql) + " and parentid = " + parent.getTreeId();
                }
                if (node.getTreeId() != null) {
                    sql = String.valueOf(sql) + " and " + tblName + "id != " + node.getTreeId();
                }
                return BasicSQLUtils.getNumRecords(sql) > 0;
            }
        }
        return false;
    }

    public BusinessRulesIFace.STATUS checkForSiblingWithSameName(Object parentDataObj, Object dataObj, boolean isExistingObject) {
        BusinessRulesIFace.STATUS result = BusinessRulesIFace.STATUS.OK;
        if (this.parentHasChildWithSameName(parentDataObj, dataObj)) {
            String parentName = parentDataObj == null ? ((Treeable)dataObj).getParent().getFullName() : ((Treeable)parentDataObj).getFullName();
            boolean saveIt = UIRegistry.displayConfirm(UIRegistry.getResourceString("BaseTreeBusRules.IDENTICALLY_NAMED_SIBLING_TITLE"), String.format(UIRegistry.getResourceString("BaseTreeBusRules.IDENTICALLY_NAMED_SIBLING_MSG"), parentName, ((Treeable)dataObj).getName()), UIRegistry.getResourceString("SAVE"), UIRegistry.getResourceString("CANCEL"), 3);
            if (!saveIt) {
                this.reasonList.add(UIRegistry.getResourceString("BaseTreeBusRules.IDENTICALLY_NAMED_SIBLING"));
                result = BusinessRulesIFace.STATUS.Error;
            }
        }
        return result;
    }

    protected BusinessRulesIFace.STATUS checkForRequiredFields(Object dataObj) {
        if (dataObj instanceof Treeable) {
            String fldTitle;
            DBFieldInfo fld;
            DBTableInfo info;
            BusinessRulesIFace.STATUS result = BusinessRulesIFace.STATUS.OK;
            Treeable obj = (Treeable)dataObj;
            if (obj.getParent() == null) {
                if (obj.getDefinitionItem() != null && ((TreeDefItemIface)obj.getDefinitionItem()).getParent() == null) {
                    return result;
                }
                result = BusinessRulesIFace.STATUS.Error;
                info = DBTableIdMgr.getInstance().getInfoById(obj.getTableId());
                fld = info.getFieldByColumnName("Parent");
                fldTitle = fld != null ? fld.getTitle() : UIRegistry.getResourceString("PARENT");
                this.reasonList.add(String.format(UIRegistry.getResourceString("GENERIC_FIELD_MISSING"), fldTitle));
            }
            if (obj.getIsAccepted() == null || !obj.getIsAccepted().booleanValue() && obj.getAcceptedParent() == null) {
                result = BusinessRulesIFace.STATUS.Error;
                info = DBTableIdMgr.getInstance().getInfoById(obj.getTableId());
                fld = info.getFieldByColumnName("AcceptedParent");
                fldTitle = fld != null ? fld.getTitle() : UIRegistry.getResourceString("ACCEPTED");
                this.reasonList.add(String.format(UIRegistry.getResourceString("GENERIC_FIELD_MISSING"), fldTitle));
            }
            return result;
        }
        return BusinessRulesIFace.STATUS.None;
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object parentDataObj, Object dataObj, boolean isExistingObject) {
        this.reasonList.clear();
        BusinessRulesIFace.STATUS result = BusinessRulesIFace.STATUS.OK;
        if (!this.processedRules && dataObj instanceof Treeable) {
            result = this.checkForSiblingWithSameName(parentDataObj, dataObj, isExistingObject);
            if (result == BusinessRulesIFace.STATUS.OK) {
                result = this.checkForRequiredFields(dataObj);
            }
            if (result == BusinessRulesIFace.STATUS.OK) {
                this.processedRules = true;
            }
        }
        return result;
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        boolean result = super.isOkToSave(dataObj, session);
        if (result && !this.getRequiredLocks()) {
            result = false;
            this.reasonList.add(this.getUnableToLockMsg());
        }
        return result;
    }

    protected boolean getRequiredLocks() {
        TaskSemaphoreMgr.USER_ACTION result = TaskSemaphoreMgr.lock(this.getFormSaveLockTitle(), this.getFormSaveLockName(), "save", TaskSemaphoreMgr.SCOPE.Discipline, false, new TaskSemaphoreMgrCallerIFace(){

            @Override
            public TaskSemaphoreMgr.USER_ACTION resolveConflict(SpTaskSemaphore semaphore, boolean previouslyLocked, String prevLockBy) {
                return TaskSemaphoreMgr.USER_ACTION.Error;
            }
        }, false);
        return result == TaskSemaphoreMgr.USER_ACTION.OK;
    }

    protected abstract Class<?> getNodeClass();

    protected String getFormSaveLockTitle() {
        return String.format(UIRegistry.getResourceString("BaseTreeBusRules.SaveLockTitle"), this.getNodeClass().getSimpleName());
    }

    protected String getFormSaveLockName() {
        return String.valueOf(this.getNodeClass().getSimpleName()) + "Save";
    }

    protected String getUnableToLockMsg() {
        return UIRegistry.getResourceString("BaseTreeBusRules.UnableToLockForSave");
    }

    protected void freeLocks() {
        TaskSemaphoreMgr.unlock(this.getFormSaveLockTitle(), this.getFormSaveLockName(), TaskSemaphoreMgr.SCOPE.Discipline);
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        boolean result = false;
        if (!super.afterSaveCommit(dataObj, session)) {
            result = false;
        }
        if (this.viewable != null) {
            this.freeLocks();
        }
        return result;
    }

    @Override
    public void afterSaveFailure(Object dataObj, DataProviderSessionIFace session) {
        super.afterSaveFailure(dataObj, session);
        if (this.viewable != null) {
            this.freeLocks();
        }
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        BusinessRulesIFace.STATUS result = BusinessRulesIFace.STATUS.OK;
        if (!this.processedRules) {
            result = super.processBusinessRules(dataObj);
            if (result == BusinessRulesIFace.STATUS.OK) {
                result = this.checkForSiblingWithSameName(null, dataObj, false);
            }
            if (result == BusinessRulesIFace.STATUS.OK) {
                result = this.checkForRequiredFields(dataObj);
            }
        } else {
            this.processedRules = false;
        }
        return result;
    }
}

