/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.AccessionAttachment;
import edu.ku.brc.specify.datamodel.AgentAttachment;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.BorrowAttachment;
import edu.ku.brc.specify.datamodel.CollectingEventAttachment;
import edu.ku.brc.specify.datamodel.CollectionObjectAttachment;
import edu.ku.brc.specify.datamodel.ConservDescriptionAttachment;
import edu.ku.brc.specify.datamodel.ConservEventAttachment;
import edu.ku.brc.specify.datamodel.DNASequenceAttachment;
import edu.ku.brc.specify.datamodel.DNASequencingRunAttachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.FieldNotebookAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageSetAttachment;
import edu.ku.brc.specify.datamodel.GiftAttachment;
import edu.ku.brc.specify.datamodel.LoanAttachment;
import edu.ku.brc.specify.datamodel.LocalityAttachment;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.datamodel.PermitAttachment;
import edu.ku.brc.specify.datamodel.PreparationAttachment;
import edu.ku.brc.specify.datamodel.ReferenceWorkAttachment;
import edu.ku.brc.specify.datamodel.RepositoryAgreementAttachment;
import edu.ku.brc.specify.datamodel.TaxonAttachment;
import edu.ku.brc.specify.datamodel.busrules.AttachmentBusRules;
import edu.ku.brc.util.AttachmentUtils;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AttachmentReferenceBaseBusRules
extends BaseBusRules {
    protected static Logger log = Logger.getLogger(AttachmentReferenceBaseBusRules.class);

    public AttachmentReferenceBaseBusRules() {
        super(AccessionAttachment.class, AgentAttachment.class, BorrowAttachment.class, CollectingEventAttachment.class, CollectionObjectAttachment.class, ConservDescriptionAttachment.class, ConservEventAttachment.class, DNASequenceAttachment.class, DNASequencingRunAttachment.class, FieldNotebookAttachment.class, FieldNotebookPageAttachment.class, FieldNotebookPageSetAttachment.class, GiftAttachment.class, LoanAttachment.class, LocalityAttachment.class, PermitAttachment.class, PreparationAttachment.class, ReferenceWorkAttachment.class, RepositoryAgreementAttachment.class, TaxonAttachment.class);
    }

    @Override
    public void afterDeleteCommit(Object dataObj) {
        boolean okToDelete;
        this.reasonList.clear();
        ObjectAttachmentIFace attRef = (ObjectAttachmentIFace)dataObj;
        Attachment a = attRef.getAttachment();
        AttachmentBusRules attachBusRules = new AttachmentBusRules();
        boolean bl = okToDelete = a.getId() != null && attachBusRules.okToEnableDelete(a);
        if (okToDelete) {
            try {
                AttachmentUtils.getAttachmentManager().deleteAttachmentFiles(a);
            }
            catch (IOException e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AttachmentReferenceBaseBusRules.class, e);
                log.warn((Object)"Failed to delete attachment files from disk", (Throwable)e);
            }
        }
        super.afterDeleteCommit(dataObj);
    }

    private BusinessRulesIFace getBusRuleForClass(Object dObj) {
        BusinessRulesIFace busRule = null;
        DataModelObjBase brObj = (DataModelObjBase)dObj;
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(brObj.getTableId());
        if (tblInfo != null) {
            busRule = tblInfo.getBusinessRule();
        }
        return busRule;
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        super.beforeMerge(dataObj, session);
        ObjectAttachmentIFace attRef = (ObjectAttachmentIFace)dataObj;
        this.getBusRuleForClass(attRef.getAttachment()).beforeMerge(attRef.getAttachment(), session);
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        ObjectAttachmentIFace attRef = (ObjectAttachmentIFace)dataObj;
        this.getBusRuleForClass(attRef.getAttachment()).beforeSave(attRef.getAttachment(), session);
    }

    @Override
    public boolean beforeSaveCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        ObjectAttachmentIFace attRef = (ObjectAttachmentIFace)dataObj;
        return this.getBusRuleForClass(attRef.getAttachment()).afterSaveCommit(attRef.getAttachment(), session);
    }

    @Override
    public boolean doesSearchObjectRequireNewParent() {
        return true;
    }

    @Override
    public Object processSearchObject(Object newParentDataObj, Object dataObjectFromSearch) {
        if (newParentDataObj instanceof ObjectAttachmentIFace) {
            ObjectAttachmentIFace objAtt = (ObjectAttachmentIFace)newParentDataObj;
            objAtt.setAttachment((Attachment)dataObjectFromSearch);
            return objAtt;
        }
        return dataObjectFromSearch;
    }
}

