/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.datamodel.busrules.AttachmentBusRules;
import edu.ku.brc.util.AttachmentUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AttachmentOwnerBaseBusRules
extends BaseBusRules {
    protected Logger log = Logger.getLogger(AttachmentOwnerBaseBusRules.class);
    private boolean processOwnersAndRefs = false;
    private HashMap<Class<?>, HashSet<String>> attachHashMap = new HashMap();
    private Set<Object> hashSet = new HashSet<Object>();

    public AttachmentOwnerBaseBusRules(Class<?> ... classes) {
        super(classes);
    }

    @Override
    public void startProcessingBeforeAfterRules() {
        this.attachHashMap.clear();
        this.attachOwners.clear();
    }

    protected void clearOwners() {
        this.attachOwners.clear();
    }

    @Override
    public void endProcessingBeforeAfterRules() {
    }

    private HashSet<String> getHashSetForClass(Object dObj) {
        Class<?> cls = dObj.getClass();
        HashSet<String> hSet = this.attachHashMap.get(cls);
        if (hSet == null) {
            hSet = new HashSet();
            this.attachHashMap.put(cls, hSet);
        }
        return hSet;
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        if (this.processOwnersAndRefs) {
            return;
        }
        this.addExtraObjectForProcessing(dataObj);
        for (AttachmentOwnerIFace aOwner : this.attachOwners) {
            for (ObjectAttachmentIFace objAtt : aOwner.getAttachmentReferences()) {
                Attachment a = objAtt.getAttachment();
                if (a == null || a.getAttachmentLocation() != null) continue;
                AttachmentUtils.getAttachmentManager().setStorageLocationIntoAttachment(a, true);
                this.getHashSetForClass(dataObj).add(a.getAttachmentLocation());
            }
        }
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        this.clearOwners();
        this.addExtraObjectForProcessing(dataObj);
        super.beforeSave(dataObj, session);
        if (this.processOwnersAndRefs) {
            return;
        }
        for (AttachmentOwnerIFace aOwner : this.attachOwners) {
            for (ObjectAttachmentIFace objAtt : aOwner.getAttachmentReferences()) {
                Attachment a = objAtt.getAttachment();
                if (a == null || a.getAttachmentLocation() == null || !this.getHashSetForClass(dataObj).contains(a.getAttachmentLocation())) continue;
                a.setStoreFile(true);
            }
        }
    }

    @Override
    public boolean beforeSaveCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        boolean retVal = super.beforeSaveCommit(dataObj, session);
        if (!retVal) {
            return retVal;
        }
        if (this.processOwnersAndRefs) {
            return true;
        }
        for (AttachmentOwnerIFace aOwner : this.attachOwners) {
            for (ObjectAttachmentIFace oa : aOwner.getAttachmentReferences()) {
                Attachment a = oa.getAttachment();
                if (a == null || !a.isStoreFile()) continue;
                try {
                    a.storeFile(true);
                }
                catch (IOException e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(AttachmentOwnerBaseBusRules.class, e);
                    this.log.error((Object)"Unable to store attached file", (Throwable)e);
                }
            }
        }
        return true;
    }

    @Override
    public Object beforeDelete(Object dataObj, DataProviderSessionIFace session) {
        super.beforeDelete(dataObj, session);
        if (dataObj instanceof AttachmentOwnerIFace) {
            AttachmentOwnerIFace owner = (AttachmentOwnerIFace)dataObj;
            try {
                owner = session.merge(owner);
                this.hashSet.clear();
                this.hashSet.addAll(owner.getAttachmentReferences());
                return owner;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return dataObj;
    }

    @Override
    public boolean beforeDeleteCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        boolean retVal = super.beforeDeleteCommit(dataObj, session);
        if (!retVal) {
            return retVal;
        }
        if (this.processOwnersAndRefs) {
            return true;
        }
        if (dataObj instanceof AttachmentOwnerIFace) {
            AttachmentOwnerIFace owner = (AttachmentOwnerIFace)dataObj;
            AttachmentBusRules attachBusRules = new AttachmentBusRules();
            for (Object attachRefObj : this.hashSet) {
                ObjectAttachmentIFace attachRef = (ObjectAttachmentIFace)attachRefObj;
                Attachment attach = attachRef.getAttachment();
                Integer totalCount = attachBusRules.getTotalCountOfAttachments(attach.getId());
                if (totalCount == null || totalCount != 1) continue;
                session.delete(attach);
                owner.getAttachmentReferences().remove(attach);
            }
            this.hashSet.clear();
        }
        return retVal;
    }

    public boolean isProcessOwnersAndRefs() {
        return this.processOwnersAndRefs;
    }

    public void setProcessOwnersAndRefs(boolean processOwnersAndRefs) {
        this.processOwnersAndRefs = processOwnersAndRefs;
    }
}

