/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.EditViewCompSwitcherPanel;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.validation.ValBrowseBtnPanel;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentManagerIface;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttachmentBusRules
extends BaseBusRules {
    protected Logger log = Logger.getLogger(AttachmentBusRules.class);
    String[] tableNames = new String[]{"accessionattachment", "agentattachment", "borrowattachment", "collectingeventattachment", "collectionobjectattachment", "conservdescriptionattachment", "conserveventattachment", "dnasequenceattachment", "dnasequencerunattachment", "fieldnotebookattachment", "fieldnotebookpageattachment", "fieldnotebookpagesetattachment", "giftattachment", "loanattachment", "localityattachment", "permitattachment", "preparationattachment", "referenceworkattachment", "repositoryagreementattachment", "taxonattachment"};
    private static String BROWSE_DIR_PREF = "AttachmentBrowseDir";
    private ValBrowseBtnPanel browser = null;
    private Component morphbankPanel = null;
    private Component origComp = null;
    private MultiView imageAttributeMultiView = null;

    public AttachmentBusRules() {
        super(Attachment.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        if (this.formViewObj != null) {
            MultiView multiView = this.imageAttributeMultiView = this.formViewObj.getKids() != null && this.formViewObj.getKids().size() > 0 ? this.formViewObj.getKids().get(0) : null;
            if (this.imageAttributeMultiView != null) {
                this.morphbankPanel = (Component)this.imageAttributeMultiView.getCurrentViewAsFormViewObj().getCompById("morphbankpanel");
            }
            this.origComp = (Component)this.formViewObj.getCompById("origFilename");
            Component titleComp = (Component)this.formViewObj.getCompById("title");
            if (this.origComp instanceof EditViewCompSwitcherPanel) {
                EditViewCompSwitcherPanel evcsp = (EditViewCompSwitcherPanel)this.origComp;
                this.browser = (ValBrowseBtnPanel)evcsp.getComp(true);
                String dir = AppPreferences.getLocalPrefs().get(BROWSE_DIR_PREF, null);
                if (dir != null) {
                    this.browser.setCurrentDir(dir);
                }
            }
            if (this.browser != null) {
                if (titleComp instanceof ValTextField) {
                    final ValTextField titleTF = (ValTextField)titleComp;
                    final ValTextField browserTF = this.browser.getValTextField();
                    browserTF.getDocument().addDocumentListener(new DocumentAdaptor(){

                        @Override
                        protected void changed(DocumentEvent e) {
                            if (AttachmentBusRules.this.formViewObj.getDataObj() != null && ((DataModelObjBase)AttachmentBusRules.this.formViewObj.getDataObj()).getId() == null) {
                                String filePath = browserTF.getText();
                                if (!filePath.isEmpty()) {
                                    titleTF.setText(FilenameUtils.getBaseName((String)browserTF.getText()));
                                    AttachmentBusRules.this.addImageAttributeIfNecessary();
                                } else if (!titleTF.getText().isEmpty()) {
                                    titleTF.setText(null);
                                }
                            }
                        }
                    });
                    browserTF.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusLost(FocusEvent e) {
                            super.focusLost(e);
                            if (AttachmentBusRules.this.formViewObj.getDataObj() != null && ((DataModelObjBase)AttachmentBusRules.this.formViewObj.getDataObj()).getId() == null) {
                                String filePath = browserTF.getText();
                                if (titleTF.getText().isEmpty() && !filePath.isEmpty()) {
                                    titleTF.setText(FilenameUtils.getBaseName((String)filePath));
                                }
                            }
                        }
                    });
                }
                if (this.formViewObj.getRsController() != null && this.formViewObj.getRsController().getNewRecBtn() != null) {
                    this.formViewObj.getRsController().getNewRecBtn().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AttachmentBusRules.this.browser.getBrowseBtn().doClick();
                                }
                            });
                        }
                    });
                }
            }
        }
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        this.reasonList.clear();
        if (dataObj instanceof Attachment) {
            Attachment attach = (Attachment)dataObj;
            Integer id = attach.getId();
            if (id == null) {
                return true;
            }
            String[] stringArray = this.tableNames;
            int n = this.tableNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tName = stringArray[n2];
                if (!super.okToDelete(tName, "AttachmentID", id)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected void addImageAttributeIfNecessary() {
        if (this.browser != null) {
            FormViewObj aiafv;
            boolean isImage;
            Integer width = null;
            Integer height = null;
            File file = new File(this.browser.getValue().toString());
            String mimeType = file == null ? null : AttachmentUtils.getMimeType(file.getName());
            boolean bl = isImage = mimeType != null && mimeType.startsWith("image");
            if (isImage) {
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(file);
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        reader.setInput(iis, true);
                        width = reader.getWidth(0);
                        height = reader.getHeight(0);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            FormViewObj formViewObj = aiafv = this.imageAttributeMultiView == null ? null : this.imageAttributeMultiView.getCurrentViewAsFormViewObj();
            if (aiafv != null) {
                aiafv.getNewRecBtn().setVisible(false);
                aiafv.getDelRecBtn().setVisible(false);
                if (isImage) {
                    if (aiafv.getDataObj() == null) {
                        aiafv.getNewRecBtn().doClick();
                    }
                    System.out.println(this.browser.getValue() + "height " + height + " width " + width);
                    try {
                        aiafv.setDataIntoUIComp("height", height);
                        aiafv.setControlChanged("height");
                        aiafv.setDataIntoUIComp("width", width);
                        aiafv.setControlChanged("width");
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Unable set image attribute data. Controls may be missing from form definition");
                    }
                } else if (aiafv.getDataObj() != null) {
                    aiafv.getDelRecBtn().doClick();
                }
            }
            this.setupImageAttributeView();
        }
    }

    public Integer getTotalCountOfAttachments(Integer ... ids) {
        String[] tableColCombos = new String[this.tableNames.length * 2];
        int inx = 0;
        String[] stringArray = this.tableNames;
        int n = this.tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tName = stringArray[n2];
            tableColCombos[inx++] = tName;
            tableColCombos[inx++] = "AttachmentID";
            ++n2;
        }
        return this.getTotalCount(tableColCombos, ids);
    }

    @Override
    public boolean beforeSaveCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        boolean retVal = super.beforeSaveCommit(dataObj, session);
        if (!retVal) {
            return retVal;
        }
        if (!(dataObj instanceof Attachment)) {
            return true;
        }
        Attachment attachment = (Attachment)dataObj;
        Thumbnailer thumbnailGen = AttachmentUtils.getThumbnailer();
        AttachmentManagerIface attachmentMgr = AttachmentUtils.getAttachmentManager();
        File origFile = new File(attachment.getOrigFilename());
        File thumbFile = null;
        try {
            thumbFile = File.createTempFile("sp6_thumb_", null);
            thumbFile.deleteOnExit();
            thumbnailGen.generateThumbnail(attachment.getOrigFilename(), thumbFile.getAbsolutePath(), false);
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(AttachmentBusRules.class, e);
            thumbFile = null;
        }
        try {
            attachmentMgr.storeAttachmentFile(attachment, origFile, thumbFile);
        }
        catch (IOException ex) {
            AppPreferences prefs = AppPreferences.getGlobalPrefs().getBoolean("USE_GLOBAL_PREFS", false) != false ? AppPreferences.getGlobalPrefs() : AppPreferences.getLocalPrefs();
            boolean useFilePath = prefs.getBoolean("attachment.use_path", true);
            String msgKey = "ATTCH_NOT_SAVED_REPOS" + (useFilePath ? "" : "_WEB");
            String errMsg = ex.getMessage();
            UIRegistry.showLocalizedError(msgKey, origFile.getName(), StringUtils.isNotEmpty((String)errMsg) ? errMsg : "");
            throw ex;
        }
        return true;
    }

    @Override
    public boolean beforeDeleteCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        return super.beforeDeleteCommit(dataObj, session);
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (this.morphbankPanel != null) {
            this.morphbankPanel.setEnabled(this.formViewObj.getAltView().getMode() != AltViewIFace.CreationMode.EDIT);
        }
        this.setupImageAttributeView();
    }

    private void setupImageAttributeView() {
        if (this.origComp != null) {
            String fileName;
            String string = fileName = this.origComp instanceof JTextField ? ((JTextField)this.origComp).getText() : this.browser.getValue().toString();
            if (fileName != null && !fileName.isEmpty()) {
                boolean isImage;
                String mimeType = fileName == null ? null : AttachmentUtils.getMimeType(fileName);
                boolean bl = isImage = mimeType != null && mimeType.startsWith("image");
                if (this.imageAttributeMultiView != null) {
                    this.imageAttributeMultiView.setVisible(isImage);
                    Dialog dlg = UIHelper.getDialog(this.imageAttributeMultiView);
                    if (dlg != null) {
                        dlg.pack();
                    }
                }
            }
        }
    }

    @Override
    public void aboutToShutdown() {
        super.aboutToShutdown();
        if (this.browser != null) {
            String dir = this.browser.getCurrentDir();
            if (dir != null) {
                AppPreferences.getLocalPrefs().put(BROWSE_DIR_PREF, dir);
            }
            System.out.println(this.browser.getCurrentDir());
        }
    }
}

