/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.db.TextFieldFromPickListTable;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.specify.plugins.PartialDateUI;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class AgentBusRules
extends AttachmentOwnerBaseBusRules {
    protected Hashtable<FormViewObj, Agent> formToAgentHash = new Hashtable();
    protected Component typeComp = null;
    protected boolean ignoreSet = false;
    protected JLabel lastLabel;
    protected JTextField lastNameText;
    protected String[] typeTitles;
    protected ArrayList<Agent> cachedAgents = new ArrayList();

    public AgentBusRules() {
        super(Agent.class);
        String[] typeTitleKeys = new String[]{"Agent_ORG", "Agent_PERSON", "Agent_OTHER", "Agent_GROUP"};
        this.typeTitles = new String[typeTitleKeys.length];
        int i = 0;
        String[] stringArray = typeTitleKeys;
        int n = typeTitleKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.typeTitles[i++] = UIRegistry.getResourceString(key);
            ++n2;
        }
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        if (this.formViewObj != null) {
            this.typeComp = (Component)this.formViewObj.getCompById("0");
            this.lastLabel = this.formViewObj.getLabelFor("3");
            this.lastNameText = (JTextField)this.formViewObj.getCompById("3");
            if (this.typeComp instanceof ValComboBox) {
                ValComboBox typeCBX = (ValComboBox)this.typeComp;
                typeCBX.getComboBox().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!AgentBusRules.this.ignoreSet) {
                            AgentBusRules.this.fixUpTypeCBX((JComboBox)e.getSource());
                        }
                    }
                });
                if (typeCBX.getComboBox().getModel().getSize() == 0) {
                    String[] stringArray = this.typeTitles;
                    int n = this.typeTitles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String t = stringArray[n2];
                        typeCBX.getComboBox().addItem(t);
                        ++n2;
                    }
                }
            }
        }
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        this.typeComp = null;
        this.lastLabel = null;
        this.lastNameText = null;
    }

    protected void enableFieldAndLabel(String id, boolean enabled, String value, Agent agent) {
        Component field = (Component)this.formViewObj.getCompById(id);
        if (field != null) {
            field.setEnabled(enabled);
            if (field instanceof TextFieldFromPickListTable) {
                String title = "";
                PickListDBAdapterIFace adaptor = ((TextFieldFromPickListTable)field).getPickListAdapter();
                if (adaptor != null) {
                    for (PickListItemIFace pli : adaptor.getList()) {
                        if (!pli.getValue().equals(value)) continue;
                        title = pli.getTitle();
                        break;
                    }
                    ((TextFieldFromPickListTable)field).setText(title);
                } else {
                    this.log.error((Object)("Adapter was null for id [" + id + "] on the Agent Form."));
                }
                return;
            }
            if (field instanceof JComboBox || field instanceof ValComboBox) {
                JComboBox cbx = field instanceof ValComboBox ? ((ValComboBox)field).getComboBox() : (JComboBox)field;
                int inx = -1;
                if (value != null) {
                    AbstractListModel model = (AbstractListModel)((Object)cbx.getModel());
                    int i = 0;
                    while (i < model.getSize()) {
                        Object item = model.getElementAt(i);
                        if (item instanceof PickListItemIFace) {
                            PickListItemIFace pli = (PickListItemIFace)item;
                            if (pli.getValue().equals(value)) {
                                inx = i;
                                break;
                            }
                        } else if (item.toString().equals(value)) {
                            inx = i;
                            break;
                        }
                        ++i;
                    }
                }
                cbx.setSelectedIndex(inx);
            } else if (field instanceof JTextComponent) {
                ((JTextComponent)field).setText(value != null ? value : "");
            } else if (field instanceof PartialDateUI) {
                PartialDateUI plugin = (PartialDateUI)field;
                plugin.setValue(agent, null);
            } else {
                this.log.debug((Object)("******** unhandled component type: " + field));
            }
            JLabel label = this.formViewObj.getLabelFor(field);
            if (label != null) {
                label.setEnabled(enabled);
            }
        }
    }

    protected void fixUpFormForAgentType(Agent agent, boolean doSetOtherValues) {
        Component groupPersonSubForm;
        boolean isPerson;
        boolean bl = isPerson = agent.getAgentType() == null || agent.getAgentType() == 1;
        if (!isPerson) {
            agent.setFirstName(null);
            agent.setMiddleInitial(null);
        }
        this.enableFieldAndLabel("1", isPerson, doSetOtherValues ? agent.getTitle() : null, agent);
        this.enableFieldAndLabel("5", isPerson, doSetOtherValues ? agent.getFirstName() : null, agent);
        this.enableFieldAndLabel("4", isPerson, doSetOtherValues ? agent.getMiddleInitial() : null, agent);
        this.enableFieldAndLabel("19", isPerson, null, agent);
        this.enableFieldAndLabel("20", isPerson, null, agent);
        this.enableFieldAndLabel("11", isPerson, doSetOtherValues ? agent.getGuid() : null, agent);
        this.enableFieldAndLabel("12", isPerson, doSetOtherValues ? agent.getInitials() : null, agent);
        this.enableFieldAndLabel("13", isPerson, doSetOtherValues ? agent.getInterests() : null, agent);
        this.enableFieldAndLabel("14", isPerson, doSetOtherValues ? agent.getJobTitle() : null, agent);
        this.enableFieldAndLabel("16", true, doSetOtherValues ? agent.getRemarks() : null, agent);
        this.enableFieldAndLabel("17", true, doSetOtherValues ? agent.getUrl() : null, agent);
        String lbl = UIRegistry.getResourceString(isPerson ? "AG_LASTNAME" : "AG_NAME");
        this.lastLabel.setText(String.valueOf(lbl) + ":");
        boolean useAgentVariant = AppPreferences.getRemote().getBoolean("Agent.Use.Variants." + AppContextMgr.getInstance().getClassObject(Discipline.class).getType(), Discipline.isCurrentDiscipline(DisciplineType.STD_DISCIPLINES.botany));
        Component agentVarSubView = (Component)this.formViewObj.getCompById("10");
        if (agentVarSubView != null) {
            agentVarSubView.setVisible(useAgentVariant);
        }
        if ((groupPersonSubForm = (Component)this.formViewObj.getCompById("31")) != null) {
            groupPersonSubForm.setVisible(agent.getAgentType() == 3);
        }
    }

    protected void fixUpTypeCBX(JComboBox cbx) {
        Agent agent;
        if (this.formViewObj != null && (agent = (Agent)this.formViewObj.getDataObj()) != null) {
            final Component addrSubView = (Component)this.formViewObj.getCompById("9");
            boolean isVisible = addrSubView.isVisible();
            byte agentType = (byte)cbx.getSelectedIndex();
            if (agentType != 1) {
                agent.setMiddleInitial(null);
                agent.setFirstName(null);
                agent.setTitle(null);
                boolean enable = agentType == 0;
                addrSubView.setVisible(enable);
            } else {
                if (!isVisible) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Window topMost;
                            Window topComp = UIHelper.getWindow(addrSubView);
                            if (topComp != (topMost = UIRegistry.getTopWindow()) && topComp != null) {
                                topComp.pack();
                            }
                        }
                    });
                }
                addrSubView.setVisible(true);
            }
            agent.setAgentType(agentType);
            this.fixUpFormForAgentType(agent, true);
        }
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        block7: {
            this.setLSID((FormDataObjIFace)dataObj);
            if (this.cachedAgents.size() > 0) {
                try {
                    try {
                        session.beginTransaction();
                        for (Agent agent : this.cachedAgents) {
                            agent = session.merge(agent);
                            session.saveOrUpdate(agent);
                        }
                        session.commit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        session.rollback();
                        this.cachedAgents.clear();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.cachedAgents.clear();
                    throw throwable;
                }
                this.cachedAgents.clear();
            }
        }
        return super.afterSaveCommit(dataObj, session);
    }

    @Override
    public void afterFillForm(Object dataObjArg) {
        Object dataObj = dataObjArg;
        if (!(this.viewable instanceof FormViewObj) || !(dataObj instanceof Agent)) {
            if (dataObj == null) {
                Component addrSubView;
                Component groupPersonSubForm;
                Component agentVarSubView = (Component)this.formViewObj.getCompById("10");
                if (agentVarSubView != null) {
                    agentVarSubView.setVisible(false);
                }
                if ((groupPersonSubForm = (Component)this.formViewObj.getCompById("31")) != null) {
                    groupPersonSubForm.setVisible(false);
                }
                if ((addrSubView = (Component)this.formViewObj.getCompById("9")) != null) {
                    addrSubView.setVisible(false);
                }
            }
            return;
        }
        Agent agent = (Agent)dataObj;
        Byte agentType = agent.getAgentType();
        this.fixUpFormForAgentType(agent, true);
        if (this.typeComp instanceof ValComboBox) {
            ValComboBox typeCBX = (ValComboBox)this.typeComp;
            if (typeCBX != null) {
                this.ignoreSet = true;
                typeCBX.getComboBox().setSelectedIndex(agentType == null ? (byte)1 : agentType);
                this.ignoreSet = false;
                this.fixUpTypeCBX(typeCBX.getComboBox());
            }
        } else {
            JTextField typeTxt = (JTextField)this.typeComp;
            if (typeTxt != null) {
                typeTxt.setText(this.typeTitles[agentType]);
            }
        }
        boolean shouldBeVisible = agentType == 1 || agentType == 0;
        final Component addrSubView = (Component)this.formViewObj.getCompById("9");
        if (addrSubView != null) {
            boolean isVisible = addrSubView.isVisible();
            if (!isVisible != shouldBeVisible) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Window topMost;
                        Window topComp = UIHelper.getWindow(addrSubView);
                        if (topComp != (topMost = UIRegistry.getTopWindow()) && topComp != null) {
                            topComp.pack();
                        }
                    }
                });
            }
            addrSubView.setVisible(shouldBeVisible);
        }
    }

    @Override
    public void okToDelete(Object dataObj, DataProviderSessionIFace session, BusinessRulesOkDeleteIFace deletable) {
        this.reasonList.clear();
        boolean isOK = false;
        if (deletable != null) {
            FormDataObjIFace dbObj = (FormDataObjIFace)dataObj;
            Integer id = dbObj.getId();
            if (id == null) {
                isOK = true;
            } else {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(Agent.getClassTableId());
                String[] tableFieldList = this.gatherTableFieldsForDelete(new String[]{"agent", "address", "agentvariant"}, tableInfo);
                isOK = this.okToDelete(tableFieldList, dbObj.getId());
                if (isOK && ((Agent)dbObj).getSpecifyUser() != null) {
                    DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(SpecifyUser.getClassTableId());
                    this.reasonList.add(ti.getTitle());
                    isOK = false;
                }
            }
            deletable.doDeleteDataObj(dataObj, session, isOK);
        } else {
            super.okToDelete(dataObj, session, deletable);
        }
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        if (AppContextMgr.getInstance().getClassObject(Discipline.class) != null) {
            Agent agent = (Agent)dataObj;
            Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
            discipline = session.get(Discipline.class, discipline.getId());
            if (agent.getId() != null && agent.getSpecifyUser() != null) {
                DataProviderSessionIFace tmpSession = null;
                try {
                    try {
                        this.cachedAgents.clear();
                        tmpSession = DataProviderFactory.getInstance().createSession();
                        String hql = String.format("SELECT a FROM Agent AS a INNER JOIN a.specifyUser AS su WHERE su.id = %d AND a.id <> %d", agent.getSpecifyUser().getId(), agent.getId());
                        this.log.debug((Object)hql);
                        List<?> agents = tmpSession.getDataList(hql);
                        for (Object agtObj : agents) {
                            Agent agt = (Agent)agtObj;
                            Agent dupAgent = (Agent)agent.clone();
                            dupAgent.setAgentId(agt.getId());
                            dupAgent.setVersion(agt.getVersion());
                            dupAgent.setDivision(agt.getDivision());
                            this.cachedAgents.add(dupAgent);
                            System.out.println(agt.getId() + agt.getLastName());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        ex.printStackTrace();
                        if (tmpSession != null) {
                            tmpSession.close();
                        }
                    }
                }
                finally {
                    if (tmpSession != null) {
                        tmpSession.close();
                    }
                }
            }
        }
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        super.beforeMerge(dataObj, session);
        Agent agent = (Agent)dataObj;
        if (agent.getDivision() == null) {
            agent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        }
        if (agent.getAgentType() == null && this.typeComp instanceof ValComboBox) {
            JComboBox cbx = ((ValComboBox)this.typeComp).getComboBox();
            byte agentType = (byte)cbx.getSelectedIndex();
            if (agentType == -1) {
                agentType = 1;
            }
            agent.setAgentType(agentType);
        }
    }

    @Override
    public boolean beforeSaveCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        Agent agent = (Agent)dataObj;
        byte agentType = agent.getAgentType();
        if (agent.getAddresses().size() > 0 && (agentType == 2 || agentType == 3)) {
            for (Address addr : new ArrayList<Address>(agent.getAddresses())) {
                agent.removeReference(addr, "addresses");
                session.delete(addr);
            }
        }
        return super.beforeSaveCommit(dataObj, session);
    }

    public static boolean createUserAgent(SpecifyUser specifyUser, Division division) {
        boolean hasData;
        JTextField fName = UIHelper.createTextField(20);
        JTextField lName = UIHelper.createTextField();
        JTextField email = UIHelper.createTextField();
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p,4px,p,4px,p,4px"));
        pb.add((Component)UIHelper.createFormLabel("First Name"), cc.xy(1, 1));
        pb.add((Component)UIHelper.createFormLabel("Last Name"), cc.xy(1, 3));
        pb.add((Component)UIHelper.createFormLabel("Email"), cc.xy(1, 5));
        pb.add((Component)fName, cc.xy(3, 1));
        pb.add((Component)lName, cc.xy(3, 3));
        pb.add((Component)email, cc.xy(3, 5));
        pb.setDefaultDialogBorder();
        CustomDialog dlg = new CustomDialog(null, "Create Agent", true, 3, (Component)pb.getPanel());
        UIHelper.centerAndShow(dlg);
        boolean bl = hasData = StringUtils.isNotEmpty((String)lName.getText()) && StringUtils.isNotEmpty((String)fName.getText());
        if (hasData && !dlg.isCancelled()) {
            Agent usrAgent = new Agent();
            usrAgent.initialize();
            DataProviderSessionIFace session = null;
            try {
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                SpecifyUser spUser = session.merge(specifyUser);
                usrAgent.setLastName(lName.getText());
                usrAgent.setFirstName(fName.getText());
                usrAgent.setEmail(email.getText());
                usrAgent.setSpecifyUser(spUser);
                spUser.getAgents().add(usrAgent);
                usrAgent.setDivision(division);
                session.saveOrUpdate(usrAgent);
                session.saveOrUpdate(spUser);
                session.commit();
                return true;
            }
            catch (Exception ex) {
                if (session != null) {
                    session.rollback();
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return false;
    }
}

