/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AddressBusRules
extends BaseBusRules {
    protected Address address = null;
    protected ActionListener addrAL = null;

    public AddressBusRules() {
        super(new Class[0]);
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (this.formViewObj.getDataObj() instanceof Address) {
            Component comp;
            this.address = (Address)this.formViewObj.getDataObj();
            if (this.isEditMode() && (comp = this.formViewObj.getControlByName("isPrimary")) instanceof ValCheckBox && this.addrAL == null) {
                this.addrAL = new ActionListener(){

                    @Override
                    public void actionPerformed(final ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AddressBusRules.this.primaryAddressSelected(e);
                            }
                        });
                    }
                };
                ((ValCheckBox)comp).addActionListener(this.addrAL);
            }
        }
    }

    protected void primaryAddressSelected(ActionEvent e) {
        Agent agent;
        JCheckBox cbx;
        boolean isSelected;
        if (this.address != null && (isSelected = (cbx = (JCheckBox)e.getSource()).isSelected()) && (agent = this.address.getAgent()) != null) {
            for (Address addr : agent.getAddresses()) {
                if (!addr.getIsPrimary().booleanValue()) continue;
                JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("ADDR_HASPRIMARY_ALREADY"));
                cbx.setSelected(false);
                break;
            }
        }
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        this.addrAL = null;
        this.address = null;
    }
}

