/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AccessionBusRules
extends AttachmentOwnerBaseBusRules {
    public AccessionBusRules() {
        super(Accession.class);
    }

    @Override
    public void addChildrenToNewDataObjects(Object newDataObj) {
        super.addChildrenToNewDataObjects(newDataObj);
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        if (collection != null) {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    session.attach(collection);
                    Division division = collection.getDiscipline().getDivision();
                    if (division != null) {
                        Accession accession = (Accession)newDataObj;
                        accession.setDivision(division);
                    }
                }
                catch (Exception ex) {
                    ExceptionTracker.getInstance().capture(AccessionBusRules.class, ex);
                    ex.printStackTrace();
                    UsageTracker.incrNetworkUsageCount();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    @Override
    public boolean shouldCreateSubViewData(String fieldName) {
        return false;
    }

    @Override
    public void afterFillForm(Object dataObj) {
        Component divComp;
        super.afterFillForm(dataObj);
        if (!(this.viewable instanceof FormViewObj) || dataObj == null) {
            return;
        }
        Accession accession = (Accession)dataObj;
        DBTableInfo divisionTI = DBTableIdMgr.getInstance().getInfoById(Division.getClassTableId());
        FormViewObj fvo = (FormViewObj)this.viewable;
        JLabel label = fvo.getLabelById("divLabel");
        if (label != null) {
            label.setText(String.valueOf(divisionTI.getTitle()) + ":");
        }
        if ((divComp = fvo.getControlById("4")) instanceof ValComboBox) {
            ValComboBox cbx = (ValComboBox)divComp;
            DefaultComboBoxModel model = (DefaultComboBoxModel)cbx.getModel();
            model.removeAllElements();
            model.addElement(accession.getDivision());
            cbx.getComboBox().setSelectedIndex(0);
        } else {
            JTextField tf = (JTextField)divComp;
            tf.setText(accession.getDivision().getName());
        }
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (!(dataObj instanceof Accession)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        Accession accession = (Accession)dataObj;
        Hashtable<String, Boolean> agentRoleHash = new Hashtable<String, Boolean>();
        for (AccessionAgent aa : accession.getAccessionAgents()) {
            Agent agent = aa.getAgent();
            if (agent == null) continue;
            String key = agent.getId() + " _ " + aa.getRole();
            if (agentRoleHash.get(key) == null) {
                agentRoleHash.put(key, true);
                continue;
            }
            this.reasonList.add(UIRegistry.getLocalizedMessage("ACCESSION_DUP_AGENTROLE", agent.toString(), aa.getRole()));
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS duplicateNumberStatus = this.isCheckDuplicateNumberOK("accessionNumber", (FormDataObjIFace)dataObj, Accession.class, "accessionId");
        return duplicateNumberStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean okToEnableDelete(Object dataObj) {
        this.reasonList.clear();
        if (dataObj == null) return false;
        if (!(dataObj instanceof Accession)) throw new RuntimeException("Data Obj is not an Accession [" + dataObj.getClass().getSimpleName() + "]");
        Accession accession = (Accession)dataObj;
        if (accession.getAccessionId() == null) return true;
        try {
            Statement stmt = DBConnection.getInstance().getConnection().createStatement();
            ResultSet rs = stmt.executeQuery("select count(*) from collectionobject where AccessionID = " + accession.getAccessionId());
            if (rs.next()) {
                return rs.getInt(1) == 0;
            }
            rs.close();
            stmt.close();
            throw new RuntimeException("Data Obj is not an Accession [" + dataObj.getClass().getSimpleName() + "]");
        }
        catch (Exception ex) {
            ExceptionTracker.getInstance().capture(AccessionBusRules.class, ex);
            this.log.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        if (dataObj instanceof Accession) {
            return UIRegistry.getLocalizedMessage("ACCESSION_DELETED", ((Accession)dataObj).getAccessionNumber());
        }
        return super.getDeleteMsg(dataObj);
    }

    @Override
    public void setObjectIdentity(Object dataObj, DraggableRecordIdentifier draggableIcon) {
        if (dataObj == null) {
            draggableIcon.setLabel("");
        }
        if (dataObj instanceof Accession) {
            Accession accession = (Accession)dataObj;
            draggableIcon.setLabel(accession.getAccessionNumber());
            Object data = draggableIcon.getData();
            if (data == null) {
                RecordSet rs = new RecordSet();
                rs.initialize();
                rs.addItem(accession.getAccessionId());
                data = rs;
                draggableIcon.setData(data);
            } else if (data instanceof RecordSetIFace) {
                RecordSetIFace rs = (RecordSetIFace)data;
                rs.clearItems();
                rs.addItem(accession.getAccessionId());
            }
        }
    }
}

