/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AccessionAgentBusRules
extends BaseBusRules {
    protected Hashtable<String, Boolean> hash = new Hashtable();
    protected ValComboBoxFromQuery agentQCBX = null;
    protected ValComboBox roleCBX = null;

    public AccessionAgentBusRules() {
        super(AccessionAgentBusRules.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        if (this.formViewObj != null && this.formViewObj.isEditing()) {
            this.agentQCBX = (ValComboBoxFromQuery)this.formViewObj.getCompById("1");
            if (this.agentQCBX != null) {
                this.agentQCBX.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (e != null && !e.getValueIsAdjusting()) {
                            AccessionAgentBusRules.this.checkForDuplicate();
                        }
                    }
                });
            }
            this.roleCBX = (ValComboBox)this.formViewObj.getCompById("2");
            if (this.roleCBX != null) {
                this.roleCBX.getComboBox().addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            AccessionAgentBusRules.this.checkForDuplicate();
                        }
                    }
                });
                this.roleCBX.getComboBox().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                });
            }
        }
    }

    private void checkForDuplicate() {
        FormDataObjIFace parentDataObj = (FormDataObjIFace)this.formViewObj.getParentDataObj();
        AccessionAgent accAgent = (AccessionAgent)this.formViewObj.getDataObj();
        Agent agent = accAgent.getAgent();
        String role = accAgent.getRole();
        if (agent == null) {
            agent = (Agent)this.agentQCBX.getValue();
        }
        if (role == null) {
            role = (String)this.roleCBX.getValue();
        }
        if (parentDataObj instanceof Accession) {
            Accession accession = (Accession)parentDataObj;
            if (agent != null && role != null && accession.getAccessionAgents() != null) {
                this.hash.clear();
                for (AccessionAgent aa : accession.getAccessionAgents()) {
                    if (aa.getAgent() == null || aa.getRole() == null || aa == accAgent) continue;
                    String key = aa.getAgent().getId() + "_" + aa.getRole();
                    this.hash.put(key, true);
                }
            }
        } else {
            RepositoryAgreement reposAgreement = (RepositoryAgreement)parentDataObj;
            if (reposAgreement != null && agent != null && role != null && reposAgreement.getRepositoryAgreementAgents() != null) {
                this.hash.clear();
                for (AccessionAgent aa : reposAgreement.getRepositoryAgreementAgents()) {
                    if (aa.getAgent() == null || aa.getRole() == null || aa == accAgent) continue;
                    String key = aa.getAgent().getId() + "_" + aa.getRole();
                    this.hash.put(key, true);
                }
            }
        }
        String key = agent.getId() + "_";
        this.hash.remove(key);
        key = String.valueOf(key) + (role == null ? "" : role);
        if (this.hash.get(key) != null) {
            UIRegistry.showLocalizedError("ACCESSION_DUP_AGENTROLE", agent.getIdentityTitle(), role);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccessionAgentBusRules.this.roleCBX.setValue(null, null);
                }
            });
        }
    }

    @Override
    public Object beforeDelete(Object dataObj, DataProviderSessionIFace session) {
        AccessionAgent accAgent = (AccessionAgent)dataObj;
        Agent agent = accAgent.getAgent();
        if (agent != null && session != null) {
            accAgent.setAgent(null);
        }
        if (accAgent.getAccession() != null) {
            AccessionAgentBusRules.removeById(accAgent.getAccession().getAccessionAgents(), accAgent);
            accAgent.setAccession(null);
        }
        return dataObj;
    }
}

