/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.GridTableHeader;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dom4j.Element;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="workbenchtemplatemappingitem")
public class WorkbenchTemplateMappingItem
extends DataModelObjBase
implements Serializable,
GridTableHeader {
    public static final short UNKNOWN = 0;
    public static final short TEXTFIELD = 1;
    public static final short TEXTAREA = 2;
    public static final short CHECKBOX = 3;
    public static final short TEXTFIELD_DATE = 4;
    public static final short COMBOBOX = 5;
    protected Integer workbenchTemplateMappingItemId;
    protected String tableName;
    protected Integer srcTableId;
    protected String fieldName;
    protected String importedColName;
    protected String caption;
    protected Short viewOrder;
    protected Short origImportColumnIndex;
    protected Short dataFieldLength;
    protected Short fieldType;
    protected WorkbenchTemplate workbenchTemplate;
    protected Boolean isExportableToContent;
    protected Boolean isIncludedInTitle;
    protected Boolean isRequired;
    protected Set<WorkbenchDataItem> workbenchDataItems;
    protected Boolean isEditable;
    protected String metaData;
    protected Short xCoord;
    protected Short yCoord;
    protected Boolean carryForward;
    protected Class<?> dataFieldClass = null;
    protected DBFieldInfo fieldInfo = null;
    private static int importedColNameMaxLength = 64;

    public WorkbenchTemplateMappingItem() {
    }

    public WorkbenchTemplateMappingItem(Integer workbenchTemplateMappingItemId) {
        this.workbenchTemplateMappingItemId = workbenchTemplateMappingItemId;
    }

    @Override
    public void initialize() {
        super.init();
        this.workbenchTemplateMappingItemId = null;
        this.tableName = null;
        this.srcTableId = null;
        this.fieldName = null;
        this.importedColName = null;
        this.caption = null;
        this.viewOrder = null;
        this.origImportColumnIndex = null;
        this.dataFieldLength = -1;
        this.fieldType = null;
        this.workbenchTemplate = null;
        this.metaData = null;
        this.xCoord = -1;
        this.yCoord = -1;
        this.carryForward = false;
        this.isExportableToContent = true;
        this.isIncludedInTitle = false;
        this.isRequired = false;
        this.isEditable = false;
        this.workbenchDataItems = new HashSet<WorkbenchDataItem>();
        this.dataFieldClass = null;
        this.fieldInfo = null;
    }

    @Id
    @GeneratedValue
    @Column(name="WorkbenchTemplateMappingItemID")
    public Integer getWorkbenchTemplateMappingItemId() {
        return this.workbenchTemplateMappingItemId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.workbenchTemplateMappingItemId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return WorkbenchTemplateMappingItem.class;
    }

    public void setWorkbenchTemplateMappingItemId(Integer workbenchTemplateMappingItemId) {
        this.workbenchTemplateMappingItemId = workbenchTemplateMappingItemId;
    }

    @Override
    @Column(name="TableName", length=64)
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Column(name="TableId", length=64)
    public Integer getSrcTableId() {
        return this.srcTableId;
    }

    public void setSrcTableId(Integer srcTableId) {
        this.srcTableId = srcTableId;
    }

    @Override
    @Column(name="FieldName")
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Column(name="ImportedColName")
    public String getImportedColName() {
        return this.importedColName;
    }

    public void setImportedColName(String importedColName) {
        this.importedColName = importedColName;
    }

    @Override
    @Column(name="Caption", length=64)
    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Override
    @Column(name="ViewOrder")
    public Short getViewOrder() {
        return this.viewOrder;
    }

    public void setViewOrder(Short viewOrder) {
        this.viewOrder = viewOrder;
    }

    @Column(name="DataColumnIndex")
    public Short getOrigImportColumnIndex() {
        return this.origImportColumnIndex;
    }

    public void setOrigImportColumnIndex(Short dataColumnIndex) {
        this.origImportColumnIndex = dataColumnIndex;
    }

    @Override
    @Column(name="DataFieldLength")
    public Short getDataFieldLength() {
        return this.dataFieldLength;
    }

    public void setDataFieldLength(Short dataLength) {
        this.dataFieldLength = dataLength;
    }

    @Column(name="FieldType")
    public Short getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Short fieldType) {
        this.fieldType = fieldType;
    }

    @Column(name="MetaData", length=128)
    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    @Column(name="XCoord")
    public Short getXCoord() {
        return this.xCoord;
    }

    public void setXCoord(Short coord) {
        this.xCoord = coord;
    }

    @Column(name="YCoord")
    public Short getYCoord() {
        return this.yCoord;
    }

    public void setYCoord(Short coord) {
        this.yCoord = coord;
    }

    @Column(name="CarryForward")
    public Boolean getCarryForward() {
        return this.carryForward;
    }

    public void setCarryForward(Boolean carryForward) {
        this.carryForward = carryForward;
    }

    @Column(name="IsExportableToContent")
    public Boolean getIsExportableToContent() {
        return this.isExportableToContent;
    }

    public void setIsExportableToContent(Boolean isExportableToContent) {
        this.isExportableToContent = isExportableToContent;
    }

    @Column(name="IsEditable")
    public Boolean getIsEditable() {
        return this.isEditable;
    }

    public void setIsEditable(Boolean isEditable) {
        this.isEditable = isEditable;
    }

    @Column(name="IsIncludedInTitle")
    public Boolean getIsIncludedInTitle() {
        return this.isIncludedInTitle;
    }

    public void setIsIncludedInTitle(Boolean isIncludedInTitle) {
        this.isIncludedInTitle = isIncludedInTitle;
    }

    @Column(name="IsRequired")
    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="WorkbenchTemplateID", nullable=false)
    public WorkbenchTemplate getWorkbenchTemplate() {
        return this.workbenchTemplate;
    }

    public void setWorkbenchTemplate(WorkbenchTemplate workbenchTemplate) {
        this.workbenchTemplate = workbenchTemplate;
    }

    @OneToMany(mappedBy="workbenchTemplateMappingItem")
    public Set<WorkbenchDataItem> getWorkbenchDataItems() {
        return this.workbenchDataItems;
    }

    public void setWorkbenchDataItems(Set<WorkbenchDataItem> workbenchDataItems) {
        this.workbenchDataItems = workbenchDataItems;
    }

    @Override
    public int compareTo(GridTableHeader obj) {
        return this.viewOrder.compareTo(obj.getViewOrder());
    }

    @Transient
    public DBFieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public void setFieldInfo(DBFieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    @Override
    public String toString() {
        return this.fieldInfo != null ? this.fieldInfo.getTitle() : (this.caption != null ? this.caption : this.fieldName);
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Override
    @Transient
    public int getTableId() {
        return WorkbenchTemplateMappingItem.getClassTableId();
    }

    @Transient
    public String getTitle() {
        return this.fieldInfo != null ? this.fieldInfo.getTitle() : this.getCaption();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WorkbenchTemplateMappingItem wbtmi = (WorkbenchTemplateMappingItem)super.clone();
        wbtmi.workbenchTemplateMappingItemId = null;
        wbtmi.workbenchTemplate = null;
        wbtmi.workbenchDataItems = new HashSet<WorkbenchDataItem>();
        wbtmi.timestampCreated = new Timestamp(System.currentTimeMillis());
        wbtmi.timestampModified = null;
        wbtmi.modifiedByAgent = null;
        return wbtmi;
    }

    public void toXML(StringBuilder sb) {
        sb.append("<workbenchtemplatemappingitem ");
        XMLHelper.addAttr(sb, "tableName", this.tableName);
        XMLHelper.addAttr(sb, "srcTableId", this.srcTableId);
        XMLHelper.addAttr(sb, "fieldName", this.fieldName);
        XMLHelper.addAttr(sb, "importedColName", this.importedColName);
        XMLHelper.addAttr(sb, "caption", this.caption);
        XMLHelper.addAttr(sb, "viewOrder", this.viewOrder);
        XMLHelper.addAttr(sb, "origImportColumnIndex", this.origImportColumnIndex);
        XMLHelper.addAttr(sb, "dataFieldLength", this.dataFieldLength);
        XMLHelper.addAttr(sb, "fieldType", this.fieldType);
        XMLHelper.addAttr(sb, "metaData", this.metaData);
        XMLHelper.addAttr(sb, "xCoord", this.xCoord);
        XMLHelper.addAttr(sb, "yCoord", this.yCoord);
        XMLHelper.addAttr(sb, "carryForward", this.carryForward);
        XMLHelper.addAttr(sb, "isExportableToContent", this.isExportableToContent);
        XMLHelper.addAttr(sb, "isIncludedInTitle", this.isIncludedInTitle);
        XMLHelper.addAttr(sb, "isRequired", this.isRequired);
        sb.append(" />");
    }

    public void fromXML(Element element) {
        this.tableName = XMLHelper.getAttr(element, "tableName", null);
        this.srcTableId = XMLHelper.getAttr(element, "srcTableId", -1);
        this.fieldName = XMLHelper.getAttr(element, "fieldName", null);
        this.importedColName = XMLHelper.getAttr(element, "importedColName", null);
        this.caption = XMLHelper.getAttr(element, "caption", null);
        this.viewOrder = (short)XMLHelper.getAttr(element, "viewOrder", -1);
        this.origImportColumnIndex = (short)XMLHelper.getAttr(element, "origImportColumnIndex", -1);
        this.dataFieldLength = (short)XMLHelper.getAttr(element, "dataFieldLength", -1);
        this.fieldType = (short)XMLHelper.getAttr(element, "fieldType", -1);
        this.metaData = XMLHelper.getAttr(element, "metaData", null);
        this.xCoord = (short)XMLHelper.getAttr(element, "xCoord", -1);
        this.yCoord = (short)XMLHelper.getAttr(element, "yCoord", -1);
        this.carryForward = XMLHelper.getAttr(element, "carryForward", false);
        this.isExportableToContent = XMLHelper.getAttr(element, "isExportableToContent", false);
        this.isIncludedInTitle = XMLHelper.getAttr(element, "isIncludedInTitle", false);
        this.isRequired = XMLHelper.getAttr(element, "isRequired", false);
    }

    public static int getClassTableId() {
        return 82;
    }

    public static int getImportedColNameMaxLength() {
        return importedColNameMaxLength;
    }

    @Override
    @Transient
    public Class<?> getDataType() {
        return WorkbenchTask.getDataType(this);
    }
}

