/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.util.Pair;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="workbenchtemplate")
public class WorkbenchTemplate
extends DataModelObjBase
implements Serializable,
Comparable<WorkbenchTemplate> {
    protected Integer workbenchTemplateId;
    protected String name;
    protected String remarks;
    protected Set<Workbench> workbenches;
    protected Set<WorkbenchTemplateMappingItem> workbenchTemplateMappingItems;
    protected SpecifyUser specifyUser;
    protected String srcFilePath;

    public WorkbenchTemplate() {
    }

    public WorkbenchTemplate(Integer workbenchTemplateId) {
        this.workbenchTemplateId = workbenchTemplateId;
    }

    @Override
    public void initialize() {
        super.init();
        this.workbenchTemplateId = null;
        this.name = null;
        this.srcFilePath = null;
        this.remarks = null;
        this.workbenches = new HashSet<Workbench>();
        this.workbenchTemplateMappingItems = new HashSet<WorkbenchTemplateMappingItem>();
        this.specifyUser = null;
    }

    @Override
    public void forceLoad() {
        for (WorkbenchTemplateMappingItem item : this.getWorkbenchTemplateMappingItems()) {
            item.getFieldName();
        }
        for (Workbench wb : this.getWorkbenches()) {
            wb.getName();
        }
    }

    public void checkMappings(DBTableIdMgr schema) {
        Element remapDom = XMLHelper.readDOMFromConfigDir("specify_workbench_remappings.xml");
        if (remapDom == null) {
            return;
        }
        HashMap<String, Pair<String, String>> remaps = new HashMap<String, Pair<String, String>>();
        Iterator i = remapDom.elementIterator("remapping");
        while (i.hasNext()) {
            Element remap = (Element)i.next();
            String from = String.valueOf(remap.attributeValue("table")) + "." + remap.attributeValue("field");
            Pair<String, String> to = new Pair<String, String>(remap.attributeValue("newtable"), remap.attributeValue("newfield"));
            remaps.put(from, to);
        }
        for (WorkbenchTemplateMappingItem item : this.getWorkbenchTemplateMappingItems()) {
            String key = String.valueOf(item.getTableName()) + "." + item.getFieldName();
            Pair remap = (Pair)remaps.get(key);
            if (remap == null) continue;
            item.setTableName((String)remap.getFirst());
            item.setFieldName((String)remap.getSecond());
            DBTableInfo tblInfo = schema.getInfoByTableName((String)remap.getFirst());
            item.setFieldInfo(tblInfo.getFieldByName((String)remap.getSecond()));
            item.setSrcTableId(tblInfo.getTableId());
        }
    }

    @Id
    @GeneratedValue
    @Column(name="WorkbenchTemplateID")
    public Integer getWorkbenchTemplateId() {
        return this.workbenchTemplateId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.workbenchTemplateId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return WorkbenchTemplate.class;
    }

    public void setWorkbenchTemplateId(Integer workbenchTemplateId) {
        this.workbenchTemplateId = workbenchTemplateId;
    }

    @Column(name="Name", length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="SrcFilePath", length=255)
    public String getSrcFilePath() {
        return this.srcFilePath;
    }

    public void setSrcFilePath(String srcFilePath) {
        this.srcFilePath = srcFilePath;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @OneToMany(mappedBy="workbenchTemplate")
    public Set<Workbench> getWorkbenches() {
        return this.workbenches;
    }

    public void setWorkbenches(Set<Workbench> workbenches) {
        this.workbenches = workbenches;
    }

    @OneToMany(mappedBy="workbenchTemplate")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<WorkbenchTemplateMappingItem> getWorkbenchTemplateMappingItems() {
        return this.workbenchTemplateMappingItems;
    }

    public void setWorkbenchTemplateMappingItems(Set<WorkbenchTemplateMappingItem> workbenchTemplateMappingItems) {
        this.workbenchTemplateMappingItems = workbenchTemplateMappingItems;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="SpecifyUserID", nullable=false)
    public SpecifyUser getSpecifyUser() {
        return this.specifyUser;
    }

    public void setSpecifyUser(SpecifyUser owner) {
        this.specifyUser = owner;
    }

    public void addWorkbenchDataItem(Workbench workbench) {
        this.workbenches.add(workbench);
        workbench.setWorkbenchTemplate(this);
    }

    public void addWorkbenches(Workbench workbench) {
        this.workbenches.add(workbench);
        workbench.setWorkbenchTemplate(this);
    }

    public void removeWorkbenchDataItem(Workbench workbench) {
        this.workbenches.remove(workbench);
        workbench.setWorkbenchTemplate(null);
    }

    public void removeWorkbench(Workbench workbench) {
        this.workbenches.remove(workbench);
        workbench.setWorkbenchTemplate(null);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(WorkbenchTemplate obj) {
        return this.name != null && obj != null && obj.name != null ? this.name.compareTo(obj.name) : 0;
    }

    public boolean containsAllMappings(WorkbenchTemplate template) {
        Comparator<WorkbenchTemplateMappingItem> comp = new Comparator<WorkbenchTemplateMappingItem>(){

            @Override
            public int compare(WorkbenchTemplateMappingItem arg0, WorkbenchTemplateMappingItem arg1) {
                int result = arg0.getTableName().compareTo(arg1.getTableName());
                if (result == 0) {
                    result = arg0.getFieldName().compareTo(arg1.getFieldName());
                }
                return result;
            }
        };
        TreeSet<WorkbenchTemplateMappingItem> theseMaps = new TreeSet<WorkbenchTemplateMappingItem>(comp);
        theseMaps.addAll(this.workbenchTemplateMappingItems);
        return theseMaps.containsAll(template.workbenchTemplateMappingItems);
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Override
    @Transient
    public int getTableId() {
        return WorkbenchTemplate.getClassTableId();
    }

    public static int getClassTableId() {
        return 81;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : super.getIdentityTitle();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WorkbenchTemplate wbt = (WorkbenchTemplate)super.clone();
        wbt.workbenchTemplateId = null;
        wbt.workbenches = new HashSet<Workbench>();
        wbt.workbenchTemplateMappingItems = new HashSet<WorkbenchTemplateMappingItem>();
        for (WorkbenchTemplateMappingItem item : this.workbenchTemplateMappingItems) {
            WorkbenchTemplateMappingItem newItem = (WorkbenchTemplateMappingItem)item.clone();
            newItem.setWorkbenchTemplate(wbt);
            wbt.workbenchTemplateMappingItems.add(newItem);
        }
        return wbt;
    }

    public void toXML(StringBuilder sb) {
        sb.append("<workbenchtemplate ");
        XMLHelper.addAttr(sb, "name", this.name);
        XMLHelper.addAttr(sb, "remarks", this.remarks);
        sb.append(">\r\n");
        sb.append("<items>");
        for (WorkbenchTemplateMappingItem item : this.workbenchTemplateMappingItems) {
            item.toXML(sb);
            sb.append("\r\n");
        }
        sb.append("</items>\r\n");
        sb.append("</workbenchtemplate>\r\n");
    }

    public void fromXML(Element element) {
        this.name = XMLHelper.getAttr(element, "name", null);
        this.remarks = XMLHelper.getAttr(element, "remarks", null);
        for (Object obj : element.selectNodes("items/workbenchtemplatemappingitem")) {
            Element itemEl = (Element)obj;
            WorkbenchTemplateMappingItem item = new WorkbenchTemplateMappingItem();
            item.initialize();
            item.fromXML(itemEl);
            item.setWorkbenchTemplate(this);
            this.workbenchTemplateMappingItems.add(item);
        }
    }
}

