/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.WorkbenchRow;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.swing.ImageIcon;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="workbenchrowimage")
public class WorkbenchRowImage
implements Serializable,
Comparable<WorkbenchRowImage> {
    protected Integer workbenchRowImageId;
    protected Integer imageOrder;
    protected byte[] cardImageData;
    protected String cardImageFullPath;
    protected String attachToTableName;
    protected WorkbenchRow workbenchRow;
    protected SoftReference<ImageIcon> fullSizeImageSR = null;
    protected SoftReference<ImageIcon> reducedSizeImageSR = null;
    protected ImageIcon thumbnail = null;

    public void initialize() {
        this.workbenchRowImageId = null;
        this.imageOrder = null;
        this.cardImageData = null;
        this.cardImageFullPath = null;
        this.attachToTableName = null;
        this.workbenchRow = null;
    }

    @Id
    @GeneratedValue
    @Column(name="WorkbenchRowImageID", nullable=false)
    public Integer getWorkbenchRowImageId() {
        return this.workbenchRowImageId;
    }

    public void setWorkbenchRowImageId(Integer workbenchRowImageId) {
        this.workbenchRowImageId = workbenchRowImageId;
    }

    @Transient
    public Integer getId() {
        return this.workbenchRowImageId;
    }

    @Lob
    @Column(name="CardImageData", length=16000000)
    public byte[] getCardImageData() {
        return this.cardImageData;
    }

    public void setCardImageData(byte[] cardImageData) {
        this.cardImageData = cardImageData;
    }

    @Column(name="CardImageFullPath", length=255)
    public String getCardImageFullPath() {
        return this.cardImageFullPath;
    }

    public void setCardImageFullPath(String cardImageFullPath) {
        this.cardImageFullPath = cardImageFullPath;
    }

    @Column(name="AttachToTableName", length=64)
    public String getAttachToTableName() {
        return this.attachToTableName;
    }

    public void setAttachToTableName(String attachToTableName) {
        this.attachToTableName = attachToTableName;
    }

    @Column(name="ImageOrder")
    public Integer getImageOrder() {
        return this.imageOrder;
    }

    public void setImageOrder(Integer imageOrder) {
        this.imageOrder = imageOrder;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="WorkbenchRowID", nullable=false)
    public WorkbenchRow getWorkbenchRow() {
        return this.workbenchRow;
    }

    public void setWorkbenchRow(WorkbenchRow workbenchRow) {
        this.workbenchRow = workbenchRow;
    }

    public String toString() {
        return this.imageOrder + ": " + this.cardImageFullPath;
    }

    @Transient
    public ImageIcon getReducedImage() {
        ImageIcon reducedSizeImage = null;
        if (this.reducedSizeImageSR != null) {
            reducedSizeImage = this.reducedSizeImageSR.get();
        }
        if (reducedSizeImage == null || reducedSizeImage.getIconWidth() == -1) {
            ImageIcon iconImage = null;
            File file = new File(this.cardImageFullPath);
            if (file.exists()) {
                byte[] imgData = null;
                try {
                    imgData = this.workbenchRow.readAndScaleCardImage(file);
                }
                catch (IOException ex) {
                    imgData = null;
                }
                if (imgData != null) {
                    iconImage = new ImageIcon(imgData);
                }
            }
            this.reducedSizeImageSR = iconImage == null || iconImage.getIconHeight() == -1 ? null : new SoftReference<ImageIcon>(iconImage);
        }
        if (this.reducedSizeImageSR != null) {
            return this.reducedSizeImageSR.get();
        }
        return this.getFullSizeImage();
    }

    @Transient
    public ImageIcon getFullSizeImage() {
        ImageIcon fullSizeImage = null;
        if (this.fullSizeImageSR != null) {
            fullSizeImage = this.fullSizeImageSR.get();
        }
        if (fullSizeImage == null || fullSizeImage.getIconWidth() == -1) {
            ImageIcon iconImage = null;
            File file = new File(this.cardImageFullPath);
            if (file.exists() && ((iconImage = new ImageIcon(this.cardImageFullPath)) == null || iconImage.getIconHeight() == -1)) {
                try {
                    iconImage = new ImageIcon(this.cardImageData);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (iconImage == null || iconImage.getIconHeight() == -1) {
                this.fullSizeImageSR = null;
                return null;
            }
            this.fullSizeImageSR = new SoftReference<ImageIcon>(iconImage);
        }
        return this.fullSizeImageSR.get();
    }

    @Transient
    public ImageIcon getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(ImageIcon thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Override
    public int compareTo(WorkbenchRowImage o) {
        if (this.imageOrder != null && o != null && o.imageOrder != null) {
            return this.imageOrder.compareTo(o.imageOrder);
        }
        return 0;
    }
}

