/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.biogeomancer.GeoCoordDataIFace;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRowExportedRelationship;
import edu.ku.brc.specify.datamodel.WorkbenchRowImage;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.GeoRefConverter;
import edu.ku.brc.util.LatLonConverter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.imageio.IIOException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="workbenchrow")
@Table(appliesTo="workbenchrow", indexes={@Index(name="RowNumberIDX", columnNames={"RowNumber"})})
public class WorkbenchRow
implements Serializable,
Comparable<WorkbenchRow>,
GeoCoordDataIFace {
    private static final Logger log = Logger.getLogger(WorkbenchRow.class);
    public static final byte UPLD_NONE = 0;
    public static final byte UPLD_SUCCESS = 1;
    public static final byte UPLD_SKIPPED = 2;
    public static final byte UPLD_FAILED = 3;
    private static long lastTruncErrorMilli = 0L;
    protected Integer workbenchRowId;
    protected Short rowNumber;
    protected byte[] cardImageData;
    protected String cardImageFullPath;
    protected String bioGeomancerResults;
    protected Set<WorkbenchDataItem> workbenchDataItems;
    protected Set<WorkbenchRowImage> workbenchRowImages;
    protected Workbench workbench;
    protected Byte uploadStatus;
    protected Byte sgrStatus;
    protected String lat1Text;
    protected String lat2Text;
    protected String long1Text;
    protected String long2Text;
    protected Integer recordId;
    protected Set<WorkbenchRowExportedRelationship> workbenchRowExportedRelationships;
    protected int maxWidth = 500;
    protected int maxHeight = 500;
    protected int maxImageSize = 16000000;
    protected SoftReference<ImageIcon> fullSizeImageSR = null;
    protected Hashtable<Short, WorkbenchDataItem> items = new Hashtable();
    protected LoadStatus loadStatus = LoadStatus.None;
    protected Exception loadException = null;
    protected ImageIcon imgIcon = null;

    public WorkbenchRow() {
    }

    public WorkbenchRow(Workbench workbench, short rowNum) {
        this.initialize();
        this.workbench = workbench;
        this.rowNumber = rowNum;
    }

    public void initialize() {
        this.workbenchRowId = null;
        this.workbench = null;
        this.rowNumber = null;
        this.workbenchDataItems = new HashSet<WorkbenchDataItem>();
        this.workbenchRowImages = new HashSet<WorkbenchRowImage>();
        this.uploadStatus = 0;
        this.lat1Text = null;
        this.lat2Text = null;
        this.long1Text = null;
        this.long2Text = null;
        this.recordId = null;
        this.workbenchRowExportedRelationships = new HashSet<WorkbenchRowExportedRelationship>();
    }

    public void forceLoad() {
        for (WorkbenchDataItem item : this.getWorkbenchDataItems()) {
            item.getCellData();
        }
        if (this.getWorkbenchRowImages() != null) {
            this.getWorkbenchRowImages().size();
        }
    }

    @Id
    @GeneratedValue
    @Column(name="WorkbenchRowID")
    public Integer getWorkbenchRowId() {
        return this.workbenchRowId;
    }

    @Transient
    public Integer getId() {
        return this.workbenchRowId;
    }

    @Override
    @Transient
    public Integer getGeoCoordId() {
        return this.rowNumber.intValue();
    }

    public void setWorkbenchRowId(Integer workbenchRowId) {
        this.workbenchRowId = workbenchRowId;
    }

    @Override
    @Transient
    public String getErrorPolygon() {
        return null;
    }

    @Override
    @Transient
    public BigDecimal getErrorEstimate() {
        return null;
    }

    @Override
    public void setErrorEstimate(BigDecimal errorEstimate) {
    }

    @Override
    public void setErrorPolygon(String errorPolygon) {
    }

    @Column(name="RowNumber")
    public Short getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(Short rowNumber) {
        this.rowNumber = rowNumber;
    }

    @Lob
    @Column(name="CardImageData", length=16000000)
    public byte[] getCardImageData() {
        return this.cardImageData;
    }

    public void setCardImageData(byte[] cardImageData) {
        this.imgIcon = null;
    }

    public synchronized void setImage(int index, File imgOrig) throws IOException {
        if (this.workbenchRowImages == null) {
            this.workbenchRowImages = new HashSet<WorkbenchRowImage>();
        }
        if (index > this.workbenchRowImages.size() - 1) {
            this.addImage(imgOrig);
            return;
        }
        for (WorkbenchRowImage img : this.workbenchRowImages) {
            byte[] newImageData;
            if (img.getImageOrder() != index || (newImageData = this.readAndScaleCardImage(imgOrig)) == null) continue;
            img.setCardImageFullPath(imgOrig.getAbsolutePath());
            return;
        }
    }

    public synchronized int addImage(File orig) throws IOException {
        return this.addImage(orig, null);
    }

    public synchronized int addImage(File orig, String attachToTblName) throws IOException {
        byte[] imgData;
        if (this.workbenchRowImages == null) {
            this.workbenchRowImages = new HashSet<WorkbenchRowImage>();
        }
        if ((imgData = this.readAndScaleCardImage(orig)) != null) {
            int order = this.workbenchRowImages.size();
            WorkbenchRowImage newRowImage = new WorkbenchRowImage();
            newRowImage.initialize();
            newRowImage.setImageOrder(order);
            newRowImage.setCardImageFullPath(orig.getAbsolutePath());
            newRowImage.setWorkbenchRow(this);
            newRowImage.setAttachToTableName(attachToTblName);
            this.workbenchRowImages.add(newRowImage);
            return order;
        }
        return -1;
    }

    public synchronized int addImagePath(String orig, String attachToTblName) {
        if (this.workbenchRowImages == null) {
            this.workbenchRowImages = new HashSet<WorkbenchRowImage>();
        }
        int order = this.workbenchRowImages.size();
        WorkbenchRowImage newRowImage = new WorkbenchRowImage();
        newRowImage.initialize();
        newRowImage.setImageOrder(order);
        newRowImage.setCardImageFullPath(orig);
        newRowImage.setCardImageData(null);
        newRowImage.setWorkbenchRow(this);
        newRowImage.setAttachToTableName(attachToTblName);
        this.workbenchRowImages.add(newRowImage);
        return order;
    }

    public synchronized void deleteImage(int index) {
        if (this.workbenchRowImages == null) {
            this.workbenchRowImages = new HashSet<WorkbenchRowImage>();
            return;
        }
        WorkbenchRowImage toDelete = null;
        for (WorkbenchRowImage rowImg : this.workbenchRowImages) {
            if (rowImg.getImageOrder() == index) {
                toDelete = rowImg;
                continue;
            }
            if (rowImg.getImageOrder() <= index) continue;
            int newOrder = rowImg.getImageOrder() - 1;
            rowImg.setImageOrder(newOrder);
        }
        if (toDelete != null) {
            this.workbenchRowImages.remove(toDelete);
        }
    }

    @Transient
    public synchronized WorkbenchRowImage getRowImage(int index) {
        if (this.workbenchRowImages == null) {
            this.workbenchRowImages = new HashSet<WorkbenchRowImage>();
            return null;
        }
        for (WorkbenchRowImage img : this.workbenchRowImages) {
            if (img.getImageOrder() == null || img.getImageOrder() != index) continue;
            return img;
        }
        return null;
    }

    @Transient
    public synchronized ImageIcon getCardImage() {
        if (this.cardImageData == null || this.cardImageData.length == 0) {
            return null;
        }
        if (this.imgIcon == null) {
            this.imgIcon = new ImageIcon(this.cardImageFullPath);
        }
        return this.imgIcon;
    }

    public synchronized void setCardImage(String imgFilePath) {
        this.setCardImage(new File(imgFilePath));
    }

    public synchronized byte[] readAndScaleCardImage(File imageFile) throws IOException {
        if (imageFile == null) {
            throw new NullPointerException("Provided File must be non-null");
        }
        if (!imageFile.exists()) {
            this.loadStatus = LoadStatus.Error;
            this.loadException = new IOException();
            throw (IOException)this.loadException;
        }
        byte[] imgBytes = null;
        try {
            byte[] bytes = GraphicsUtils.readImage(imageFile);
            ImageIcon img = new ImageIcon(bytes);
            int origWidth = img.getIconWidth();
            int origHeight = img.getIconHeight();
            boolean scale = false;
            if (origWidth > this.maxWidth || origHeight > this.maxHeight) {
                scale = true;
            }
            imgBytes = scale ? GraphicsUtils.scaleImage(bytes, this.maxHeight, this.maxWidth, true, false) : bytes;
        }
        catch (IIOException ex) {
            UIRegistry.showLocalizedError("WB_IMG_BAD_FMT");
            this.loadStatus = LoadStatus.Error;
            this.loadException = ex;
            return null;
        }
        return imgBytes;
    }

    public synchronized void setCardImage(File imageFile) {
        this.imgIcon = null;
        this.loadStatus = LoadStatus.None;
        this.loadException = null;
        if (imageFile == null) {
            this.setCardImageData(null);
            this.setCardImageFullPath(null);
            this.fullSizeImageSR = null;
            return;
        }
        byte[] imgData = null;
        try {
            imgData = this.readAndScaleCardImage(imageFile);
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchRow.class, e);
            this.loadStatus = LoadStatus.Error;
            this.loadException = e;
        }
        if (imgData != null) {
            this.setCardImageData(imgData);
            this.setCardImageFullPath(imageFile.getAbsolutePath());
        }
    }

    @Transient
    public Exception getLoadException() {
        return this.loadException;
    }

    @Transient
    public LoadStatus getLoadStatus() {
        return this.loadStatus;
    }

    @Column(name="CardImageFullPath", length=255)
    public String getCardImageFullPath() {
        return this.cardImageFullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCardImageFullPath(String cardImageFullPath) {
        this.cardImageFullPath = cardImageFullPath;
        WorkbenchRow workbenchRow = this;
        synchronized (workbenchRow) {
            if (this.fullSizeImageSR != null) {
                this.fullSizeImageSR = null;
            }
        }
    }

    @Lob
    @Column(name="BioGeomancerResults", length=8192)
    public String getBioGeomancerResults() {
        return this.bioGeomancerResults;
    }

    public void setBioGeomancerResults(String bioGeomancerResults) {
        this.bioGeomancerResults = bioGeomancerResults;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="WorkbenchID", nullable=false)
    public Workbench getWorkbench() {
        return this.workbench;
    }

    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    @OneToMany(mappedBy="workbenchRow")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<WorkbenchDataItem> getWorkbenchDataItems() {
        return this.workbenchDataItems;
    }

    public void setWorkbenchDataItems(Set<WorkbenchDataItem> workbenchDataItems) {
        this.workbenchDataItems = workbenchDataItems;
    }

    @OneToMany(mappedBy="workbenchRow")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<WorkbenchRowImage> getWorkbenchRowImages() {
        return this.workbenchRowImages;
    }

    public void setWorkbenchRowImages(Set<WorkbenchRowImage> workbenchRowImages) {
        this.workbenchRowImages = workbenchRowImages;
    }

    @OneToMany(mappedBy="workbenchRow")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<WorkbenchRowExportedRelationship> getWorkbenchRowExportedRelationships() {
        return this.workbenchRowExportedRelationships;
    }

    public void setWorkbenchRowExportedRelationships(Set<WorkbenchRowExportedRelationship> workbenchRowExportedRelationships) {
        this.workbenchRowExportedRelationships = workbenchRowExportedRelationships;
    }

    @Transient
    public Hashtable<Short, WorkbenchDataItem> getItems() {
        if (this.items.size() != this.workbenchDataItems.size()) {
            this.items.clear();
            for (WorkbenchDataItem wbdi : this.workbenchDataItems) {
                this.items.put(wbdi.getColumnNumber(), wbdi);
            }
        }
        return this.items;
    }

    public String getData(int col) {
        WorkbenchDataItem wbdi = this.getItems().get((short)col);
        if (wbdi != null) {
            return wbdi.getCellData();
        }
        return "";
    }

    public WorkbenchDataItem setData(String dataStr, short col, boolean updateGeoRefInfo) {
        return this.setData(dataStr, col, updateGeoRefInfo, false);
    }

    public WorkbenchDataItem setData(String dataStr, short col, boolean updateGeoRefInfo, boolean isRequired) {
        WorkbenchDataItem wbdi;
        String data;
        if (StringUtils.isNotEmpty((String)dataStr) && dataStr.length() > WorkbenchDataItem.getMaxWBCellLength()) {
            long now;
            data = dataStr.substring(0, WorkbenchDataItem.getMaxWBCellLength());
            if (CommandDispatcher.getInstance() != null && (now = System.currentTimeMillis()) - lastTruncErrorMilli > 4000L) {
                CommandDispatcher.dispatch(new CommandAction("ERRMSG", "DISPLAY", "WB_ERR_DATA_TRUNC"));
                lastTruncErrorMilli = now;
            }
        } else {
            data = dataStr;
        }
        if ((wbdi = this.getItems().get(col)) != null) {
            if (StringUtils.isEmpty((String)data) && wbdi.isRequired()) {
                this.items.remove(col);
                this.workbenchDataItems.remove(wbdi);
            } else if (data.equals(wbdi.getCellData())) {
                return null;
            }
            wbdi.setCellData(data);
        } else if (StringUtils.isNotEmpty((String)data) || isRequired) {
            Short inx = col;
            wbdi = new WorkbenchDataItem(this, this.workbench.getMappingFromColumn(col), data, this.rowNumber);
            if (isRequired) {
                wbdi.setRequired(true);
            }
            this.items.put(inx, wbdi);
            this.workbenchDataItems.add(wbdi);
        }
        this.uploadStatus = 0;
        if (wbdi != null) {
            if (updateGeoRefInfo) {
                this.updateGeoRefTextFldsIfNecessary(wbdi.getWorkbenchTemplateMappingItem());
            }
            if (wbdi.getValidationStatus() == 2) {
                wbdi.setValidationStatus((short)3);
            } else if (wbdi.getValidationStatus() == 1) {
                wbdi.setValidationStatus((short)0);
            }
        }
        return wbdi;
    }

    public void updateGeoRefTextFldsIfNecessary(WorkbenchTemplateMappingItem map) {
        if (map.getTableName().equals("locality") && (map.getFieldName().equalsIgnoreCase("latitude1") || map.getFieldName().equalsIgnoreCase("latitude2") || map.getFieldName().equalsIgnoreCase("longitude1") || map.getFieldName().equalsIgnoreCase("longitude2"))) {
            for (WorkbenchDataItem geoFld : this.getGeoCoordFlds()) {
                WorkbenchTemplateMappingItem geoMap = geoFld.getWorkbenchTemplateMappingItem();
                if (geoMap.getFieldName().equalsIgnoreCase("latitude1")) {
                    this.setLat1Text(this.getLatString(geoFld.getCellData()));
                    continue;
                }
                if (geoMap.getFieldName().equalsIgnoreCase("latitude2")) {
                    this.setLat2Text(this.getLatString(geoFld.getCellData()));
                    continue;
                }
                if (geoMap.getFieldName().equalsIgnoreCase("longitude1")) {
                    this.setLong1Text(this.getLongString(geoFld.getCellData()));
                    continue;
                }
                if (!geoMap.getFieldName().equalsIgnoreCase("longitude2")) continue;
                this.setLong2Text(this.getLongString(geoFld.getCellData()));
            }
        }
    }

    @Transient
    protected List<WorkbenchDataItem> getGeoCoordFlds() {
        LinkedList<WorkbenchDataItem> result = new LinkedList<WorkbenchDataItem>();
        for (WorkbenchDataItem wbdi : this.workbenchDataItems) {
            WorkbenchTemplateMappingItem map = wbdi.getWorkbenchTemplateMappingItem();
            if (!map.getTableName().equals("locality") || !map.getFieldName().equalsIgnoreCase("latitude1") && !map.getFieldName().equalsIgnoreCase("latitude2") && !map.getFieldName().equalsIgnoreCase("longitude1") && !map.getFieldName().equalsIgnoreCase("longitude2")) continue;
            result.add(wbdi);
        }
        return result;
    }

    @Transient
    protected String getLatString(String latEntry) {
        int decimalSize;
        LatLonConverter.FORMAT fmt;
        GeoRefConverter geoConverter;
        String ddString;
        block4: {
            ddString = null;
            geoConverter = new GeoRefConverter();
            fmt = geoConverter.getLatLonFormat(StringUtils.stripToNull((String)latEntry));
            decimalSize = geoConverter.getDecimalSize(StringUtils.stripToNull((String)latEntry));
            if (!fmt.equals((Object)LatLonConverter.FORMAT.None)) break block4;
            return null;
        }
        try {
            ddString = geoConverter.convert(StringUtils.stripToNull((String)latEntry), GeoRefConverter.GeoRefFormat.D_PLUS_MINUS.name());
            BigDecimal bigD = UIHelper.parseDoubleToBigDecimal(ddString);
            return LatLonConverter.ensureFormattedString(bigD, null, fmt, LatLonConverter.LATLON.Latitude, decimalSize);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Transient
    protected String getLongString(String longEntry) {
        int decimalSize;
        LatLonConverter.FORMAT fmt;
        GeoRefConverter geoConverter;
        String ddString;
        block4: {
            ddString = null;
            geoConverter = new GeoRefConverter();
            fmt = geoConverter.getLatLonFormat(StringUtils.stripToNull((String)longEntry));
            decimalSize = geoConverter.getDecimalSize(StringUtils.stripToNull((String)longEntry));
            if (!fmt.equals((Object)LatLonConverter.FORMAT.None)) break block4;
            return null;
        }
        try {
            ddString = geoConverter.convert(StringUtils.stripToNull((String)longEntry), GeoRefConverter.GeoRefFormat.D_PLUS_MINUS.name());
            BigDecimal bigD = UIHelper.parseDoubleToBigDecimal(ddString);
            return LatLonConverter.ensureFormattedString(bigD, null, fmt, LatLonConverter.LATLON.Longitude, decimalSize);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public WorkbenchDataItem delete(WorkbenchDataItem item) {
        short colInx = item.getColumnNumber();
        this.items.remove(colInx);
        this.workbenchDataItems.remove(item);
        item.setWorkbenchRow(null);
        return item;
    }

    @Transient
    public Class<?> getDataClass() {
        return WorkbenchRow.class;
    }

    @Transient
    public int getTableId() {
        return WorkbenchRow.getClassTableId();
    }

    public static int getClassTableId() {
        return 90;
    }

    @Override
    public int compareTo(WorkbenchRow obj) {
        return this.rowNumber != null && obj != null && obj.rowNumber != null ? this.rowNumber.compareTo(obj.rowNumber) : 0;
    }

    @Transient
    public ImageIcon getFullSizeImage() {
        if (this.cardImageData != null && StringUtils.isNotEmpty((String)this.cardImageFullPath)) {
            ImageIcon fullSizeImage = null;
            if (this.fullSizeImageSR != null) {
                fullSizeImage = this.fullSizeImageSR.get();
            }
            if (fullSizeImage == null) {
                try {
                    ImageIcon iconImage = new ImageIcon(this.cardImageFullPath);
                    this.fullSizeImageSR = new SoftReference<ImageIcon>(iconImage);
                }
                catch (OutOfMemoryError memEx) {
                    this.loadStatus = LoadStatus.OutOfMemory;
                    this.loadException = new Exception("Out of Memory");
                    log.error((Object)memEx);
                    return null;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchRow.class, ex);
                    log.error((Object)ex);
                    this.loadStatus = LoadStatus.Error;
                    this.loadException = ex;
                    return null;
                }
            }
            return this.fullSizeImageSR.get();
        }
        return null;
    }

    @Transient
    public int getLocalityStringIndex() {
        return this.workbench.getColumnIndex(Locality.class, "localityName");
    }

    @Transient
    public int getCountryIndex() {
        return this.workbench.getColumnIndex(Geography.class, "Country");
    }

    @Transient
    public int getStateIndex() {
        return this.workbench.getColumnIndex(Geography.class, "State");
    }

    @Transient
    public int getCountyIndex() {
        return this.workbench.getColumnIndex(Geography.class, "County");
    }

    @Transient
    public int getLatitudeIndex() {
        return this.workbench.getColumnIndex(Locality.class, "latitude1");
    }

    @Transient
    public int getLongitudeIndex() {
        return this.workbench.getColumnIndex(Locality.class, "longitude1");
    }

    @Override
    @Transient
    public String getCountry() {
        return this.getData(this.getCountryIndex());
    }

    @Override
    @Transient
    public String getCounty() {
        return this.getData(this.getCountyIndex());
    }

    @Override
    @Transient
    public String getLatitude() {
        return this.getData(this.getLatitudeIndex());
    }

    @Override
    @Transient
    public String getLocalityString() {
        return this.getData(this.getLocalityStringIndex());
    }

    @Override
    @Transient
    public String getLongitude() {
        return this.getData(this.getLongitudeIndex());
    }

    @Override
    @Transient
    public String getState() {
        return this.getData(this.getStateIndex());
    }

    @Override
    @Transient
    public String getTitle() {
        return this.getData(this.getLocalityStringIndex());
    }

    @Override
    @Transient
    public String getXML() {
        return this.getBioGeomancerResults();
    }

    @Override
    @Transient
    public void set(String latitude, String longitude) {
        this.setData(latitude, (short)this.getLatitudeIndex(), true);
        this.setData(longitude, (short)this.getLongitudeIndex(), true);
    }

    @Override
    public void setXML(String xml) {
        this.setBioGeomancerResults(xml);
    }

    @Column(name="UploadStatus", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getUploadStatus() {
        return this.uploadStatus;
    }

    public void setUploadStatus(Byte uploadStatus) {
        this.uploadStatus = uploadStatus;
    }

    @Column(name="SGRStatus", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getSgrStatus() {
        return this.sgrStatus;
    }

    public void setSgrStatus(Byte sgrStatus) {
        this.sgrStatus = sgrStatus;
    }

    @Column(name="RecordID", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getRecordId() {
        return this.recordId;
    }

    public void setRecordId(Integer recordId) {
        this.recordId = recordId;
    }

    @Column(name="Lat1Text", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLat1Text() {
        return this.lat1Text;
    }

    public void setLat1Text(String lat1Text) {
        this.lat1Text = lat1Text;
    }

    @Column(name="Lat2Text", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLat2Text() {
        return this.lat2Text;
    }

    public void setLat2Text(String lat2Text) {
        this.lat2Text = lat2Text;
    }

    @Column(name="Long1Text", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLong1Text() {
        return this.long1Text;
    }

    public void setLong1Text(String long1Text) {
        this.long1Text = long1Text;
    }

    @Column(name="Long2Text", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLong2Text() {
        return this.long2Text;
    }

    public void setLong2Text(String long2Text) {
        this.long2Text = long2Text;
    }

    public static enum LoadStatus {
        None,
        Successful,
        Error,
        OutOfMemory,
        TooLarge;

    }
}

