/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="workbenchdataitem")
@org.hibernate.annotations.Table(appliesTo="workbenchdataitem", indexes={@Index(name="DataItemRowNumberIDX", columnNames={"rowNumber"})})
public class WorkbenchDataItem
implements Serializable,
Comparable<WorkbenchDataItem> {
    public static final short VAL_NONE = 0;
    public static final short VAL_OK = 1;
    public static final short VAL_ERROR = 2;
    public static final short VAL_ERROR_EDIT = 3;
    public static final short VAL_NEW_DATA = 4;
    public static final short VAL_MULTIPLE_MATCH = 5;
    public static final short VAL_NOT_MATCHED = 6;
    private static Integer maxWBCellLength = null;
    protected Integer workbenchDataItemId;
    protected String cellData;
    protected Short rowNumber;
    protected Short validationStatus;
    protected WorkbenchRow workbenchRow;
    protected WorkbenchTemplateMappingItem workbenchTemplateMappingItem;
    protected String statusText = null;
    protected boolean required = false;
    protected int editorValidationStatus = 1;

    public WorkbenchDataItem() {
    }

    public WorkbenchDataItem(WorkbenchRow workbenchRow, WorkbenchTemplateMappingItem wbtmi, String cellData, Short rowNumber) {
        this.initialize();
        this.cellData = cellData;
        this.rowNumber = rowNumber;
        this.workbenchRow = workbenchRow;
        this.workbenchTemplateMappingItem = wbtmi;
        workbenchRow.getWorkbenchDataItems().add(this);
    }

    public WorkbenchDataItem(Integer workbenchDataItemId) {
        this.workbenchDataItemId = workbenchDataItemId;
    }

    public void initialize() {
        this.workbenchDataItemId = null;
        this.cellData = null;
        this.rowNumber = null;
        this.validationStatus = 0;
        this.workbenchRow = null;
        this.workbenchTemplateMappingItem = null;
    }

    @Id
    @GeneratedValue
    @Column(name="WorkbenchDataItemID")
    public Integer getWorkbenchDataItemId() {
        return this.workbenchDataItemId;
    }

    @Transient
    public Integer getId() {
        return this.workbenchDataItemId;
    }

    @Transient
    public Class<?> getDataClass() {
        return WorkbenchDataItem.class;
    }

    public void setWorkbenchDataItemId(Integer workbenchDataItemId) {
        this.workbenchDataItemId = workbenchDataItemId;
    }

    @Column(name="CellData", length=512)
    public String getCellData() {
        return this.cellData;
    }

    public void setCellData(String cellData) {
        this.cellData = cellData;
    }

    @Column(name="RowNumber")
    public Short getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(Short rowNumber) {
        this.rowNumber = rowNumber;
    }

    @Transient
    public Short getColumnNumber() {
        return this.getWorkbenchTemplateMappingItem().getViewOrder();
    }

    @Column(name="ValidationStatus")
    public Short getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(Short validationStatus) {
        this.validationStatus = validationStatus;
    }

    @Transient
    public int getEditorValidationStatus() {
        return this.editorValidationStatus;
    }

    public void setEditorValidationStatus(int editorValidationStatus) {
        this.editorValidationStatus = editorValidationStatus;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="WorkbenchRowID", nullable=false)
    public WorkbenchRow getWorkbenchRow() {
        return this.workbenchRow;
    }

    public void setWorkbenchRow(WorkbenchRow workbenchRow) {
        this.workbenchRow = workbenchRow;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="WorkbenchTemplateMappingItemID", nullable=false)
    public WorkbenchTemplateMappingItem getWorkbenchTemplateMappingItem() {
        return this.workbenchTemplateMappingItem;
    }

    public void setWorkbenchTemplateMappingItem(WorkbenchTemplateMappingItem workbenchTemplateMappingItem) {
        this.workbenchTemplateMappingItem = workbenchTemplateMappingItem;
    }

    @Override
    public int compareTo(WorkbenchDataItem obj) {
        if (this.getWorkbenchTemplateMappingItem() != null && this.getWorkbenchTemplateMappingItem().getViewOrder() != null && obj.getWorkbenchTemplateMappingItem() != null && obj.getWorkbenchTemplateMappingItem().getViewOrder() != null) {
            return this.getWorkbenchTemplateMappingItem().getViewOrder().compareTo(obj.getWorkbenchTemplateMappingItem().getViewOrder());
        }
        return 0;
    }

    public static Integer getMaxWBCellLength() {
        return maxWBCellLength;
    }

    public static void setMaxWBCellLength(Integer maxWBCellLen) {
        maxWBCellLength = maxWBCellLen;
    }

    @Transient
    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    @Transient
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

