/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="workbench")
@Table(appliesTo="workbench", indexes={@Index(name="WorkbenchNameIDX", columnNames={"name"})})
public class Workbench
extends DataModelObjBase
implements Serializable,
Comparable<Workbench> {
    protected Integer workbenchId;
    protected String name;
    protected Integer dbTableId;
    protected String remarks;
    protected Integer formId;
    protected String exportInstitutionName;
    protected Integer ownerPermissionLevel;
    protected Integer groupPermissionLevel;
    protected Integer allPermissionLevel;
    protected WorkbenchTemplate workbenchTemplate;
    protected Set<WorkbenchRow> workbenchRows;
    protected SpecifyUser specifyUser;
    protected SpPrincipal group;
    protected String srcFilePath;
    protected String lockedByUserName;
    protected String exportedFromTableName;
    protected Vector<WorkbenchRow> rows = new Vector();
    protected Hashtable<Short, WorkbenchTemplateMappingItem> wbtmiItems = new Hashtable();

    public Workbench() {
    }

    public Workbench(Integer workbenchId) {
        this.workbenchId = workbenchId;
    }

    @Override
    public void initialize() {
        super.init();
        this.workbenchId = null;
        this.name = null;
        this.dbTableId = null;
        this.remarks = null;
        this.formId = null;
        this.exportInstitutionName = null;
        this.srcFilePath = null;
        this.ownerPermissionLevel = null;
        this.groupPermissionLevel = null;
        this.allPermissionLevel = null;
        this.workbenchTemplate = null;
        this.workbenchRows = new HashSet<WorkbenchRow>();
        this.specifyUser = null;
        this.group = null;
        this.lockedByUserName = null;
        this.exportedFromTableName = null;
        this.rows.clear();
        this.wbtmiItems.clear();
    }

    @Override
    public void forceLoad() {
        this.getWorkbenchTemplate().forceLoad();
        for (WorkbenchRow row : this.getWorkbenchRows()) {
            row.forceLoad();
        }
    }

    @Id
    @GeneratedValue
    @Column(name="WorkbenchID")
    public Integer getWorkbenchId() {
        return this.workbenchId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.workbenchId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Workbench.class;
    }

    public void setWorkbenchId(Integer workbenchId) {
        this.workbenchId = workbenchId;
    }

    @Column(name="LockedByUserName", length=64)
    public String getLockedByUserName() {
        return this.lockedByUserName;
    }

    public void setLockedByUserName(String userName) {
        this.lockedByUserName = userName;
    }

    @Column(name="Name", length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="TableID")
    public Integer getDbTableId() {
        return this.dbTableId;
    }

    public void setDbTableId(Integer tableId) {
        this.dbTableId = tableId;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="FormId")
    public Integer getFormId() {
        return this.formId;
    }

    public void setFormId(Integer formId) {
        this.formId = formId;
    }

    @Column(name="ExportInstitutionName", length=128)
    public String getExportInstitutionName() {
        return this.exportInstitutionName;
    }

    public void setExportInstitutionName(String exportInstitutionName) {
        this.exportInstitutionName = exportInstitutionName;
    }

    @Column(name="ExportedFromTableName", length=128)
    public String getExportedFromTableName() {
        return this.exportedFromTableName;
    }

    public void setExportedFromTableName(String exportedFromTableName) {
        this.exportedFromTableName = exportedFromTableName;
    }

    @Column(name="SrcFilePath", length=255)
    public String getSrcFilePath() {
        return this.srcFilePath;
    }

    public void setSrcFilePath(String srcFilePath) {
        this.srcFilePath = srcFilePath;
    }

    @Column(name="OwnerPermissionLevel")
    public Integer getOwnerPermissionLevel() {
        return this.ownerPermissionLevel;
    }

    public void setOwnerPermissionLevel(Integer ownerPermissionLevel) {
        this.ownerPermissionLevel = ownerPermissionLevel;
    }

    @Column(name="GroupPermissionLevel")
    public Integer getGroupPermissionLevel() {
        return this.groupPermissionLevel;
    }

    public void setGroupPermissionLevel(Integer groupPermissionLevel) {
        this.groupPermissionLevel = groupPermissionLevel;
    }

    @Column(name="AllPermissionLevel")
    public Integer getAllPermissionLevel() {
        return this.allPermissionLevel;
    }

    public void setAllPermissionLevel(Integer allPermissionLevel) {
        this.allPermissionLevel = allPermissionLevel;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="WorkbenchTemplateID", nullable=false)
    public WorkbenchTemplate getWorkbenchTemplate() {
        return this.workbenchTemplate;
    }

    public void setWorkbenchTemplate(WorkbenchTemplate workbenchTemplates) {
        this.workbenchTemplate = workbenchTemplates;
    }

    @OneToMany(mappedBy="workbench")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<WorkbenchRow> getWorkbenchRows() {
        if (this.rows == null) {
            this.rows = new Vector();
        }
        return this.workbenchRows;
    }

    public void setWorkbenchRows(Set<WorkbenchRow> workbenchRows) {
        if (this.rows == null) {
            this.rows = new Vector();
        }
        this.workbenchRows = workbenchRows;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="SpecifyUserID", nullable=false)
    @Cascade(value={CascadeType.MERGE, CascadeType.LOCK})
    public SpecifyUser getSpecifyUser() {
        return this.specifyUser;
    }

    public void setSpecifyUser(SpecifyUser owner) {
        this.specifyUser = owner;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="SpPrincipalID")
    @Cascade(value={CascadeType.MERGE, CascadeType.LOCK})
    public SpPrincipal getGroup() {
        return this.group;
    }

    public void setGroup(SpPrincipal group) {
        this.group = group;
    }

    @Override
    @Transient
    public int getTableId() {
        return Workbench.getClassTableId();
    }

    public static int getClassTableId() {
        return 79;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : super.getIdentityTitle();
    }

    @Transient
    public Vector<WorkbenchRow> getWorkbenchRowsAsList() {
        if (this.rows.size() == 0 && this.workbenchRows.size() > 0) {
            this.rows.addAll(this.workbenchRows);
            Collections.sort(this.rows);
        }
        return this.rows;
    }

    @Transient
    public Hashtable<Short, WorkbenchTemplateMappingItem> getTemplateMappings() {
        if (this.wbtmiItems.size() == 0 || this.wbtmiItems.size() != this.workbenchTemplate.getWorkbenchTemplateMappingItems().size()) {
            this.wbtmiItems.clear();
            this.createWBTMIMappings();
        }
        return this.wbtmiItems;
    }

    public WorkbenchTemplateMappingItem getMappingFromColumn(short column) {
        return this.getTemplateMappings().get(column);
    }

    protected void createWBTMIMappings() {
        if (this.wbtmiItems.size() == 0) {
            for (WorkbenchTemplateMappingItem wbtmi : this.workbenchTemplate.getWorkbenchTemplateMappingItems()) {
                this.wbtmiItems.put((short)wbtmi.getViewOrder(), wbtmi);
            }
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Transient
    public String getDebugInfo() {
        return "Name: " + this.name + " | id: " + this.workbenchId + " | hash: 0x" + Integer.toHexString(this.hashCode()) + " | version: " + this.timestampModified;
    }

    @Override
    public int compareTo(Workbench obj) {
        return this.name != null && obj != null && obj.name != null ? this.name.compareTo(obj.name) : 0;
    }

    public WorkbenchRow addRow() {
        WorkbenchRow wbRow = new WorkbenchRow(this, (short)this.rows.size());
        this.rows.add(wbRow);
        this.workbenchRows.add(wbRow);
        return wbRow;
    }

    public WorkbenchRow insertRow(short rowIndex) {
        if (rowIndex < 0) {
            throw new RuntimeException("Row Index is less than zero [" + rowIndex + "]");
        }
        if (rowIndex >= this.rows.size()) {
            return this.addRow();
        }
        WorkbenchRow workbenchRow = new WorkbenchRow(this, (short)rowIndex);
        int i = rowIndex;
        while (i < this.rows.size()) {
            this.rows.get(i).setRowNumber((short)(i + 1));
            ++i;
        }
        this.rows.insertElementAt(workbenchRow, rowIndex);
        this.workbenchRows.add(workbenchRow);
        workbenchRow.setWorkbench(this);
        return workbenchRow;
    }

    public WorkbenchRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public WorkbenchRow deleteRow(int rowIndex) {
        WorkbenchRow wbRow = this.rows.get(rowIndex);
        this.rows.remove(rowIndex);
        int i = rowIndex;
        while (i < this.rows.size()) {
            this.rows.get(i).setRowNumber((short)i);
            ++i;
        }
        if (wbRow.getWorkbenchRowImages() != null) {
            wbRow.getWorkbenchRowImages().clear();
        }
        this.workbenchRows.remove(wbRow);
        return wbRow;
    }

    @Transient
    public boolean containsGeoRefData() {
        WorkbenchTemplate template = this.getWorkbenchTemplate();
        Set<WorkbenchTemplateMappingItem> mappingItems = template.getWorkbenchTemplateMappingItems();
        boolean hasLat1 = false;
        boolean hasLon1 = false;
        int localityTableId = DBTableIdMgr.getInstance().getIdByClassName(Locality.class.getName());
        for (WorkbenchTemplateMappingItem item : mappingItems) {
            int dataTableId = item.getSrcTableId();
            if (dataTableId != localityTableId) continue;
            String fieldName = item.getFieldName();
            if (fieldName.equals("latitude1")) {
                hasLat1 = true;
            }
            if (!fieldName.equals("longitude1")) continue;
            hasLon1 = true;
        }
        return hasLat1 && hasLon1;
    }

    @Transient
    public boolean containsLocalityStringData() {
        WorkbenchTemplate template = this.getWorkbenchTemplate();
        Set<WorkbenchTemplateMappingItem> mappingItems = template.getWorkbenchTemplateMappingItems();
        int localityTableId = DBTableIdMgr.getInstance().getIdByClassName(Locality.class.getName());
        for (WorkbenchTemplateMappingItem item : mappingItems) {
            String fieldName;
            int dataTableId = item.getSrcTableId();
            if (dataTableId != localityTableId || !(fieldName = item.getFieldName()).equals("localityName")) continue;
            return true;
        }
        return false;
    }

    @Transient
    public int getColumnIndex(int dataTableId, String fieldNameOrCaption) {
        WorkbenchTemplate template = this.getWorkbenchTemplate();
        Set<WorkbenchTemplateMappingItem> mappingItems = template.getWorkbenchTemplateMappingItems();
        for (WorkbenchTemplateMappingItem item : mappingItems) {
            int itemDataTableId = item.getSrcTableId();
            if (itemDataTableId != dataTableId) continue;
            String fieldName = item.getFieldName();
            String caption = item.getCaption();
            if (!fieldName.equalsIgnoreCase(fieldNameOrCaption) && !caption.equalsIgnoreCase(fieldNameOrCaption)) continue;
            return item.getViewOrder().shortValue();
        }
        return -1;
    }

    public int getColumnIndex(Class<?> dataClass, String fieldNameOrCaption) {
        int tableId = DBTableIdMgr.getInstance().getIdByClassName(dataClass.getName());
        return this.getColumnIndex(tableId, fieldNameOrCaption);
    }
}

