/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.ui.DateWrapper;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="treatmentevent")
@Table(appliesTo="treatmentevent", indexes={@Index(name="TEDateReceivedIDX", columnNames={"DateReceived"}), @Index(name="TEDateTreatmentStartedIDX", columnNames={"DateTreatmentStarted"}), @Index(name="TEFieldNumberIDX", columnNames={"FieldNumber"}), @Index(name="TETreatmentNumberIDX", columnNames={"TreatmentNumber"})})
public class TreatmentEvent
extends DataModelObjBase {
    protected static DateWrapper scrDateFormat = null;
    protected Integer treatmentEventId;
    protected Calendar dateReceived;
    protected Calendar dateCompleted;
    protected Calendar dateTreatmentStarted;
    protected Calendar dateTreatmentEnded;
    protected Calendar dateCleaned;
    protected Calendar dateBoxed;
    protected Calendar dateToIsolation;
    protected String type;
    protected String treatmentNumber;
    protected String location;
    protected String fieldNumber;
    protected String remarks;
    protected Accession accession;
    protected CollectionObject collectionObject;
    protected Division division;

    @Override
    public void initialize() {
        super.init();
        this.treatmentEventId = null;
        this.dateReceived = null;
        this.dateCompleted = null;
        this.dateTreatmentStarted = null;
        this.dateTreatmentEnded = null;
        this.dateCleaned = null;
        this.dateBoxed = null;
        this.dateToIsolation = null;
        this.type = null;
        this.treatmentNumber = null;
        this.location = null;
        this.fieldNumber = null;
        this.remarks = null;
        this.accession = null;
        this.collectionObject = null;
        this.division = null;
    }

    public static void setScrDateFormat(DateWrapper scrDateFormat) {
        TreatmentEvent.scrDateFormat = scrDateFormat;
    }

    public void setTreatmentEventId(Integer treatmentEventId) {
        this.treatmentEventId = treatmentEventId;
    }

    public void setDateReceived(Calendar dateReceived) {
        this.dateReceived = dateReceived;
    }

    public void setDateCompleted(Calendar dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public void setDateTreatmentStarted(Calendar dateTreatmentStarted) {
        this.dateTreatmentStarted = dateTreatmentStarted;
    }

    public void setDateTreatmentEnded(Calendar dateTreatmentEnded) {
        this.dateTreatmentEnded = dateTreatmentEnded;
    }

    public void setDateCleaned(Calendar dateCleaned) {
        this.dateCleaned = dateCleaned;
    }

    public void setDateBoxed(Calendar dateBoxed) {
        this.dateBoxed = dateBoxed;
    }

    public void setDateToIsolation(Calendar dateToIsolation) {
        this.dateToIsolation = dateToIsolation;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTreatmentNumber(String treatmentNumber) {
        this.treatmentNumber = treatmentNumber;
    }

    public void setFieldNumber(String fieldNumber) {
        this.fieldNumber = fieldNumber;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setAccession(Accession accession) {
        this.accession = accession;
    }

    public void setCollectionObject(CollectionObject collectionObject) {
        this.collectionObject = collectionObject;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public static DateWrapper getScrDateFormat() {
        return scrDateFormat;
    }

    @Id
    @GeneratedValue
    @Column(name="TreatmentEventID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getTreatmentEventId() {
        return this.treatmentEventId;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateReceived", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateReceived() {
        return this.dateReceived;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateCompleted", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateCompleted() {
        return this.dateCompleted;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateTreatmentStarted", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateTreatmentStarted() {
        return this.dateTreatmentStarted;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateTreatmentEnded", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateTreatmentEnded() {
        return this.dateTreatmentEnded;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateCleaned", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateCleaned() {
        return this.dateCleaned;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateBoxed", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateBoxed() {
        return this.dateBoxed;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateToIsolation", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateToIsolation() {
        return this.dateToIsolation;
    }

    @Column(name="Type", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getType() {
        return this.type;
    }

    @Column(name="Storage", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getLocation() {
        return this.location;
    }

    @Column(name="TreatmentNumber", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getTreatmentNumber() {
        return this.treatmentNumber;
    }

    @Column(name="FieldNumber", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getFieldNumber() {
        return this.fieldNumber;
    }

    @Lob
    @Column(name="Remarks", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getRemarks() {
        return this.remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AccessionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Accession getAccession() {
        return this.accession;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionObjectID", unique=false, nullable=true, insertable=true, updatable=true)
    public CollectionObject getCollectionObject() {
        return this.collectionObject;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        Integer tblId;
        Integer n = tblId = this.accession != null ? Integer.valueOf(Accession.getClassTableId()) : null;
        Integer n2 = tblId != null ? tblId : (tblId = this.collectionObject != null ? Integer.valueOf(CollectionObject.getClassTableId()) : null);
        tblId = tblId != null ? tblId : (this.division != null ? Integer.valueOf(Division.getClassTableId()) : null);
        return tblId;
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.accession != null ? this.accession.getId() : (this.collectionObject != null ? this.collectionObject.getId() : (this.division != null ? this.division.getId() : null));
    }

    @Override
    @Transient
    public Integer getId() {
        return this.treatmentEventId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return TreatmentEvent.class;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        if (scrDateFormat == null) {
            scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
        }
        if (this.dateCompleted != null) {
            return scrDateFormat.format(this.dateCompleted);
        }
        if (this.dateReceived != null) {
            return scrDateFormat.format(this.dateReceived);
        }
        return super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return TreatmentEvent.getClassTableId();
    }

    public static int getClassTableId() {
        return 122;
    }
}

