/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.BaseTreeDef;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="taxontreedef")
public class TaxonTreeDef
extends BaseTreeDef<Taxon, TaxonTreeDef, TaxonTreeDefItem>
implements Serializable {
    public static final int TAXONOMY_ROOT = 0;
    public static final int KINGDOM = 10;
    public static final int SUBKINGDOM = 20;
    public static final int DIVISION = 30;
    public static final int PHYLUM = 30;
    public static final int SUBDIVISION = 40;
    public static final int SUBPHYLUM = 40;
    public static final int SUPERCLASS = 50;
    public static final int CLASS = 60;
    public static final int SUBCLASS = 70;
    public static final int INFRACLASS = 80;
    public static final int SUPERORDER = 90;
    public static final int ORDER = 100;
    public static final int SUBORDER = 110;
    public static final int INFRAORDER = 120;
    public static final int PARVORDER = 125;
    public static final int SUPERFAMILY = 130;
    public static final int FAMILY = 140;
    public static final int SUBFAMILY = 150;
    public static final int TRIBE = 160;
    public static final int SUBTRIBE = 170;
    public static final int GENUS = 180;
    public static final int SUBGENUS = 190;
    public static final int SECTION = 200;
    public static final int SUBSECTION = 210;
    public static final int SPECIES = 220;
    public static final int SUBSPECIES = 230;
    public static final int VARIETY = 240;
    public static final int SUBVARIETY = 250;
    public static final int FORMA = 260;
    public static final int SUBFORMA = 270;
    protected Integer taxonTreeDefId;
    protected String name;
    protected String remarks;
    protected Integer fullNameDirection;
    protected Discipline discipline;
    protected Set<Taxon> treeEntries;
    protected Set<TaxonTreeDefItem> treeDefItems;
    protected List<TreeDefItemStandardEntry> stdLevels = null;

    public TaxonTreeDef() {
    }

    @Override
    @Transient
    public List<TreeDefItemStandardEntry> getStandardLevels() {
        if (this.stdLevels == null) {
            this.stdLevels = TaxonTreeDef.getStandardLevelsStatic();
        }
        return new LinkedList<TreeDefItemStandardEntry>(this.stdLevels);
    }

    @Transient
    public static List<TreeDefItemStandardEntry> getStandardLevelsStatic() {
        LinkedList<TreeDefItemStandardEntry> result = new LinkedList<TreeDefItemStandardEntry>();
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(0), 0));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(10), 10));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(20), 20));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(30), 30));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(31), 30));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(40), 40));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(41), 40));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(50), 50));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(60), 60));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(70), 70));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(80), 80));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(90), 90));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(100), 100));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(110), 110));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(120), 120));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(125), 125));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(130), 130));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(140), 140));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(150), 150));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(160), 160));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(170), 170));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(180), 180));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(190), 190));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(200), 200));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(210), 210));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(220), 220));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(230), 230));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(240), 240));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(250), 250));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(260), 260));
        result.add(new TreeDefItemStandardEntry(TaxonTreeDef.getLevelName(270), 270));
        return result;
    }

    @Override
    @Transient
    public boolean isRequiredLevel(int levelRank) {
        return TaxonTreeDef.isStdRequiredLevel(levelRank);
    }

    public static boolean isStdRequiredLevel(int levelRank) {
        return levelRank == 10 || levelRank == 30 || levelRank == 30 || levelRank == 60 || levelRank == 100 || levelRank == 140 || levelRank == 180 || levelRank == 220;
    }

    @Transient
    protected static String getLevelName(int levelRank) {
        switch (levelRank) {
            case 0: {
                return "Root";
            }
            case 10: {
                return "Kingdom";
            }
            case 20: {
                return "Subkingdom";
            }
            case 30: {
                return "Division";
            }
            case 31: {
                return "Phylum";
            }
            case 40: {
                return "Subdivision";
            }
            case 41: {
                return "Subphylum";
            }
            case 50: {
                return "Superclass";
            }
            case 60: {
                return "Class";
            }
            case 70: {
                return "Subclass";
            }
            case 80: {
                return "Infraclass";
            }
            case 90: {
                return "Superorder";
            }
            case 100: {
                return "Order";
            }
            case 110: {
                return "Suborder";
            }
            case 120: {
                return "Infraorder";
            }
            case 125: {
                return "Parvorder";
            }
            case 130: {
                return "Superfamily";
            }
            case 140: {
                return "Family";
            }
            case 150: {
                return "Subfamily";
            }
            case 160: {
                return "Tribe";
            }
            case 170: {
                return "Subtribe";
            }
            case 180: {
                return "Genus";
            }
            case 190: {
                return "Subgenus";
            }
            case 200: {
                return "Section";
            }
            case 210: {
                return "Subsection";
            }
            case 220: {
                return "Species";
            }
            case 230: {
                return "Subspecies";
            }
            case 240: {
                return "Variety";
            }
            case 250: {
                return "Subvariety";
            }
            case 260: {
                return "Forma";
            }
            case 270: {
                return "Subforma";
            }
        }
        return null;
    }

    @Override
    @Transient
    public int getRankIncrement() {
        return 10;
    }

    public TaxonTreeDef(Integer taxonTreeDefId) {
        this.taxonTreeDefId = taxonTreeDefId;
    }

    @Override
    public void initialize() {
        super.init();
        this.taxonTreeDefId = null;
        this.name = null;
        this.remarks = null;
        this.fullNameDirection = null;
        this.discipline = null;
        this.treeEntries = new HashSet<Taxon>();
        this.treeDefItems = new HashSet<TaxonTreeDefItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="TaxonTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getTaxonTreeDefId() {
        return this.taxonTreeDefId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.taxonTreeDefId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return TaxonTreeDef.class;
    }

    public void setTaxonTreeDefId(Integer taxonTreeDefId) {
        this.taxonTreeDefId = taxonTreeDefId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="Remarks", length=255, unique=false, nullable=true, insertable=true, updatable=true)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="FullNameDirection", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getFullNameDirection() {
        return this.fullNameDirection;
    }

    @Override
    public void setFullNameDirection(Integer fullNameDirection) {
        this.fullNameDirection = fullNameDirection;
    }

    @OneToOne(mappedBy="taxonTreeDef", fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="definition")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<Taxon> getTreeEntries() {
        return this.treeEntries;
    }

    @Override
    public void setTreeEntries(Set<Taxon> treeEntries) {
        this.treeEntries = treeEntries;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.EAGER, mappedBy="treeDef")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<TaxonTreeDefItem> getTreeDefItems() {
        return this.treeDefItems;
    }

    @Override
    public void setTreeDefItems(Set<TaxonTreeDefItem> treeDefItems) {
        this.treeDefItems = treeDefItems;
    }

    @Override
    @Transient
    public Integer getTreeDefId() {
        return this.getTaxonTreeDefId();
    }

    @Override
    public void setTreeDefId(Integer id) {
        this.setTaxonTreeDefId(id);
    }

    public void addTreeEntry(Taxon taxon) {
        this.treeEntries.add(taxon);
        taxon.setDefinition(this);
    }

    public void removeTreeEntry(Taxon taxon) {
        this.treeEntries.remove(taxon);
        taxon.setDefinition((TaxonTreeDef)null);
    }

    public void addTreeDefItem(TaxonTreeDefItem item) {
        this.treeDefItems.add(item);
        item.setTreeDef(this);
    }

    public void removeTreeDefItem(TaxonTreeDefItem item) {
        this.treeDefItems.remove(item);
        item.setTreeDef((TaxonTreeDef)null);
    }

    @Override
    @Transient
    public Class<Taxon> getNodeClass() {
        return Taxon.class;
    }

    @Override
    public TaxonTreeDefItem getDefItemByRank(Integer rank) {
        for (TaxonTreeDefItem item : this.treeDefItems) {
            if (!item.getRankId().equals(rank)) continue;
            return item;
        }
        return null;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Discipline.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        if (this.discipline != null) {
            this.discipline.getId();
        }
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return TaxonTreeDef.getClassTableId();
    }

    public static int getClassTableId() {
        return 76;
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }

    @Override
    @Transient
    public int getSynonymizedLevel() {
        return 220;
    }

    @Override
    @Transient
    public boolean isSynonymySupported() {
        return true;
    }
}

