/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import edu.ku.brc.specify.datamodel.Taxon;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="taxoncitation")
public class TaxonCitation
extends DataModelObjBase
implements Serializable {
    protected Integer taxonCitationId;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected ReferenceWork referenceWork;
    protected Taxon taxon;

    public TaxonCitation() {
    }

    public TaxonCitation(Integer taxonCitationId) {
        this.taxonCitationId = taxonCitationId;
    }

    @Override
    public void initialize() {
        super.init();
        this.taxonCitationId = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.referenceWork = null;
        this.taxon = null;
    }

    @Id
    @GeneratedValue
    @Column(name="TaxonCitationID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getTaxonCitationId() {
        return this.taxonCitationId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.taxonCitationId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return TaxonCitation.class;
    }

    public void setTaxonCitationId(Integer taxonCitationId) {
        this.taxonCitationId = taxonCitationId;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ReferenceWorkID", unique=false, nullable=false, insertable=true, updatable=true)
    public ReferenceWork getReferenceWork() {
        return this.referenceWork;
    }

    public void setReferenceWork(ReferenceWork referenceWork) {
        this.referenceWork = referenceWork;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="TaxonID", unique=false, nullable=false, insertable=true, updatable=true)
    public Taxon getTaxon() {
        return this.taxon;
    }

    public void setTaxon(Taxon taxon) {
        this.taxon = taxon;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Taxon.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.taxon != null ? this.taxon.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return TaxonCitation.getClassTableId();
    }

    public static int getClassTableId() {
        return 75;
    }
}

