/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="taxonattachment")
public class TaxonAttachment
extends DataModelObjBase
implements ObjectAttachmentIFace<Taxon>,
Orderable,
Serializable,
Comparable<TaxonAttachment> {
    protected Integer taxonAttachmentId;
    protected Taxon taxon;
    protected Attachment attachment;
    protected Integer ordinal;
    protected String remarks;

    public TaxonAttachment() {
    }

    public TaxonAttachment(Integer id) {
        this.taxonAttachmentId = id;
    }

    @Override
    public void initialize() {
        super.init();
        this.taxonAttachmentId = null;
        this.taxon = null;
        this.attachment = new Attachment();
        this.attachment.initialize();
        this.ordinal = null;
    }

    @Id
    @GeneratedValue
    @Column(name="TaxonAttachmentID")
    public Integer getTaxonAttachmentId() {
        return this.taxonAttachmentId;
    }

    public void setTaxonAttachmentId(Integer taxonAttachmentId) {
        this.taxonAttachmentId = taxonAttachmentId;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="TaxonID", nullable=false)
    public Taxon getTaxon() {
        return this.taxon;
    }

    public void setTaxon(Taxon taxon) {
        this.taxon = taxon;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="AttachmentID", nullable=false)
    @OrderBy(value="ordinal ASC")
    public Attachment getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    @Override
    @Column(name="Ordinal")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.ordinal != null ? this.ordinal : 0;
    }

    @Override
    public void setOrderIndex(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return TaxonAttachment.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.taxonAttachmentId;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Taxon.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.taxon != null ? this.taxon.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return TaxonAttachment.getClassTableId();
    }

    public static int getClassTableId() {
        return 119;
    }

    @Override
    @Transient
    public Taxon getObject() {
        return this.getTaxon();
    }

    @Override
    public void setObject(Taxon object) {
        this.setTaxon(object);
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return Attachment.getIdentityTitle(this);
    }

    @Override
    public String toString() {
        return Attachment.getIdentityTitle(this);
    }

    @Override
    public int compareTo(TaxonAttachment o) {
        return Integer.valueOf(this.getOrderIndex()).compareTo(o.getOrderIndex());
    }
}

