/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectingEventAttribute;
import edu.ku.brc.specify.datamodel.CommonNameTx;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.TaxonAttachment;
import edu.ku.brc.specify.datamodel.TaxonCitation;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeOrderSiblingComparator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="taxon")
@Table(appliesTo="taxon", indexes={@Index(name="TaxonGuidIDX", columnNames={"GUID"}), @Index(name="TaxonomicSerialNumberIDX", columnNames={"TaxonomicSerialNumber"}), @Index(name="TaxonCommonNameIDX", columnNames={"CommonName"}), @Index(name="TaxonNameIDX", columnNames={"Name"}), @Index(name="TaxonFullNameIDX", columnNames={"FullName"}), @Index(name="EnvironmentalProtectionStatusIDX", columnNames={"EnvironmentalProtectionStatus"})})
public class Taxon
extends DataModelObjBase
implements AttachmentOwnerIFace<TaxonAttachment>,
Serializable,
Treeable<Taxon, TaxonTreeDef, TaxonTreeDefItem> {
    protected static final Logger log = Logger.getLogger(Taxon.class);
    protected Integer taxonId;
    protected String name;
    protected String fullName;
    protected String commonName;
    protected String cultivarName;
    protected String taxonomicSerialNumber;
    protected String guid;
    protected String unitInd1;
    protected String unitName1;
    protected String unitInd2;
    protected String unitName2;
    protected String unitInd3;
    protected String unitName3;
    protected String unitInd4;
    protected String unitName4;
    protected String esaStatus;
    protected String citesStatus;
    protected String usfwsCode;
    protected String isisNumber;
    protected String ncbiTaxonNumber;
    protected String colStatus;
    protected String author;
    protected String source;
    protected String remarks;
    protected String environmentalProtectionStatus;
    protected String labelFormat;
    protected Boolean isHybrid;
    protected Taxon hybridParent1;
    protected Taxon hybridParent2;
    protected Set<Taxon> hybridChildren1;
    protected Set<Taxon> hybridChildren2;
    protected Boolean isAccepted;
    protected Taxon acceptedTaxon;
    protected Set<Taxon> acceptedChildren;
    protected Taxon parent;
    protected Set<Taxon> children;
    protected TaxonTreeDef definition;
    protected TaxonTreeDefItem definitionItem;
    protected String text1;
    protected String text2;
    protected Integer number1;
    protected Integer number2;
    protected Set<Determination> determinations;
    protected Set<TaxonCitation> taxonCitations;
    protected Set<CommonNameTx> commonNames;
    protected Integer nodeNumber;
    protected Integer highestChildNodeNumber;
    protected Integer rankId;
    protected String groupNumber;
    protected Byte visibility;
    protected SpecifyUser visibilitySetBy;
    protected List<Taxon> ancestors;
    private Set<TaxonAttachment> taxonAttachments;
    private Set<CollectingEventAttribute> collectingEventAttributes;

    public Taxon() {
    }

    public Taxon(Integer taxonId) {
        this.taxonId = taxonId;
    }

    public Taxon(String name) {
        this.initialize();
        this.name = name;
    }

    public Taxon(String name, Taxon parent, int rank) {
        this.name = name;
        this.parent = parent;
        this.rankId = rank;
    }

    @Override
    public void initialize() {
        super.init();
        this.taxonId = null;
        this.taxonomicSerialNumber = null;
        this.guid = null;
        this.name = null;
        this.remarks = null;
        this.unitInd1 = null;
        this.unitName1 = null;
        this.unitInd2 = null;
        this.unitName2 = null;
        this.unitInd3 = null;
        this.unitName3 = null;
        this.unitInd4 = null;
        this.unitName4 = null;
        this.fullName = null;
        this.commonName = null;
        this.cultivarName = null;
        this.author = null;
        this.source = null;
        this.environmentalProtectionStatus = null;
        this.esaStatus = null;
        this.citesStatus = null;
        this.colStatus = null;
        this.usfwsCode = null;
        this.isisNumber = null;
        this.ncbiTaxonNumber = null;
        this.labelFormat = null;
        this.nodeNumber = null;
        this.highestChildNodeNumber = null;
        this.rankId = null;
        this.groupNumber = null;
        this.visibility = null;
        this.visibilitySetBy = null;
        this.hybridParent1 = null;
        this.hybridParent2 = null;
        this.hybridChildren1 = new HashSet<Taxon>();
        this.hybridChildren2 = new HashSet<Taxon>();
        this.determinations = new HashSet<Determination>();
        this.taxonCitations = new HashSet<TaxonCitation>();
        this.commonNames = new HashSet<CommonNameTx>();
        this.definition = null;
        this.definitionItem = null;
        this.parent = null;
        this.children = new HashSet<Taxon>();
        this.ancestors = null;
        this.taxonAttachments = new HashSet<TaxonAttachment>();
        this.collectingEventAttributes = new HashSet<CollectingEventAttribute>();
        this.isAccepted = true;
        this.acceptedTaxon = null;
        this.number1 = null;
        this.number2 = null;
        this.text1 = null;
        this.text2 = null;
        this.acceptedChildren = new HashSet<Taxon>();
    }

    @Id
    @GeneratedValue
    @Column(name="TaxonID")
    public Integer getTaxonId() {
        return this.taxonId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.taxonId;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        String title = this.fullName != null && this.fullName.length() > 0 ? this.fullName : this.name;
        return title != null && title.length() > 0 ? title : super.getIdentityTitle();
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Taxon.class;
    }

    public void setTaxonId(Integer taxonId) {
        this.taxonId = taxonId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="FullName", length=255)
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Column(name="CommonName", length=128)
    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    @Column(name="COLStatus", length=32)
    public String getColStatus() {
        return this.colStatus;
    }

    public void setColStatus(String colStatus) {
        this.colStatus = colStatus;
    }

    @Column(name="CultivarName", length=32)
    public String getCultivarName() {
        return this.cultivarName;
    }

    public void setCultivarName(String cultivarName) {
        this.cultivarName = cultivarName;
    }

    @Column(name="TaxonomicSerialNumber", length=50)
    public String getTaxonomicSerialNumber() {
        return this.taxonomicSerialNumber;
    }

    public void setTaxonomicSerialNumber(String taxonomicSerialNumber) {
        this.taxonomicSerialNumber = taxonomicSerialNumber;
    }

    @Column(name="GUID", length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="UnitInd1", length=50)
    public String getUnitInd1() {
        return this.unitInd1;
    }

    public void setUnitInd1(String unitInd1) {
        this.unitInd1 = unitInd1;
    }

    @Column(name="UnitName1", length=50)
    public String getUnitName1() {
        return this.unitName1;
    }

    public void setUnitName1(String unitName1) {
        this.unitName1 = unitName1;
    }

    @Column(name="UnitInd2", length=50)
    public String getUnitInd2() {
        return this.unitInd2;
    }

    public void setUnitInd2(String unitInd2) {
        this.unitInd2 = unitInd2;
    }

    @Column(name="UnitName2", length=50)
    public String getUnitName2() {
        return this.unitName2;
    }

    public void setUnitName2(String unitName2) {
        this.unitName2 = unitName2;
    }

    @Column(name="UnitInd3", length=50)
    public String getUnitInd3() {
        return this.unitInd3;
    }

    public void setUnitInd3(String unitInd3) {
        this.unitInd3 = unitInd3;
    }

    @Column(name="UnitName3", length=50)
    public String getUnitName3() {
        return this.unitName3;
    }

    public void setUnitName3(String unitName3) {
        this.unitName3 = unitName3;
    }

    @Column(name="UnitInd4", length=50)
    public String getUnitInd4() {
        return this.unitInd4;
    }

    public void setUnitInd4(String unitInd4) {
        this.unitInd4 = unitInd4;
    }

    @Column(name="UnitName4", length=50)
    public String getUnitName4() {
        return this.unitName4;
    }

    public void setUnitName4(String unitName4) {
        this.unitName4 = unitName4;
    }

    @Column(name="Author", length=128)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Column(name="Source", length=64)
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Column(name="EnvironmentalProtectionStatus", length=64)
    public String getEnvironmentalProtectionStatus() {
        return this.environmentalProtectionStatus;
    }

    public void setEnvironmentalProtectionStatus(String environmentalProtectionStatus) {
        this.environmentalProtectionStatus = environmentalProtectionStatus;
    }

    @Column(name="LabelFormat", length=64)
    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
    }

    @Column(name="CitesStatus", length=32)
    public String getCitesStatus() {
        return this.citesStatus;
    }

    public void setCitesStatus(String citesStatus) {
        this.citesStatus = citesStatus;
    }

    @Column(name="EsaStatus", length=64)
    public String getEsaStatus() {
        return this.esaStatus;
    }

    public void setEsaStatus(String esaStatus) {
        this.esaStatus = esaStatus;
    }

    @Column(name="IsisNumber", length=16)
    public String getIsisNumber() {
        return this.isisNumber;
    }

    public void setIsisNumber(String isisNumber) {
        this.isisNumber = isisNumber;
    }

    @Column(name="NcbiTaxonNumber", length=8)
    public String getNcbiTaxonNumber() {
        return this.ncbiTaxonNumber;
    }

    public void setNcbiTaxonNumber(String ncbiTaxonNumber) {
        this.ncbiTaxonNumber = ncbiTaxonNumber;
    }

    @Column(name="Number1")
    public Integer getNumber1() {
        return this.number1;
    }

    public void setNumber1(Integer number1) {
        this.number1 = number1;
    }

    @Column(name="Number2")
    public Integer getNumber2() {
        return this.number2;
    }

    public void setNumber2(Integer number2) {
        this.number2 = number2;
    }

    @Column(name="Text1", length=32)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=32)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="UsfwsCode", length=16)
    public String getUsfwsCode() {
        return this.usfwsCode;
    }

    public void setUsfwsCode(String usfwsCode) {
        this.usfwsCode = usfwsCode;
    }

    @Override
    @Column(name="NodeNumber")
    public Integer getNodeNumber() {
        return this.nodeNumber;
    }

    @Override
    public void setNodeNumber(Integer nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    @Override
    @Column(name="HighestChildNodeNumber")
    public Integer getHighestChildNodeNumber() {
        return this.highestChildNodeNumber;
    }

    @Override
    public void setHighestChildNodeNumber(Integer highestChildNodeNumber) {
        this.highestChildNodeNumber = highestChildNodeNumber;
    }

    @Override
    @Column(name="IsAccepted")
    public Boolean getIsAccepted() {
        return this.isAccepted == null ? true : this.isAccepted;
    }

    @Override
    public void setIsAccepted(Boolean accepted) {
        this.isAccepted = accepted;
    }

    @Override
    @Column(name="RankID", nullable=false)
    public Integer getRankId() {
        return this.rankId;
    }

    @Override
    public void setRankId(Integer rankId) {
        this.rankId = rankId;
    }

    @Column(name="GroupNumber", length=20)
    public String getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(String groupNumber) {
        this.groupNumber = groupNumber;
    }

    @Column(name="Visibility")
    public Byte getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Byte visibility) {
        this.visibility = visibility;
    }

    @Override
    @Transient
    public boolean isRestrictable() {
        return true;
    }

    @Column(name="IsHybrid")
    public Boolean getIsHybrid() {
        return this.isHybrid;
    }

    public void setIsHybrid(Boolean isHybrid) {
        this.isHybrid = isHybrid;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="VisibilitySetByID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpecifyUser getVisibilitySetBy() {
        return this.visibilitySetBy;
    }

    public void setVisibilitySetBy(SpecifyUser visibilitySetBy) {
        this.visibilitySetBy = visibilitySetBy;
    }

    @Override
    @OneToMany(fetch=FetchType.LAZY, mappedBy="acceptedTaxon")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<Taxon> getAcceptedChildren() {
        return this.acceptedChildren;
    }

    @Override
    public void setAcceptedChildren(Set<Taxon> acceptedChildren) {
        this.acceptedChildren = acceptedChildren;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AcceptedID")
    public Taxon getAcceptedTaxon() {
        return this.acceptedTaxon;
    }

    public void setAcceptedTaxon(Taxon acceptedTaxon) {
        this.acceptedTaxon = acceptedTaxon;
    }

    @Override
    @Transient
    public Taxon getAcceptedParent() {
        return this.getAcceptedTaxon();
    }

    @Override
    public void setAcceptedParent(Taxon acceptedParent) {
        this.setAcceptedTaxon(acceptedParent);
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="HybridParent1ID")
    public Taxon getHybridParent1() {
        return this.hybridParent1;
    }

    public void setHybridParent1(Taxon hybridParent1) {
        this.hybridParent1 = hybridParent1;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="HybridParent2ID")
    public Taxon getHybridParent2() {
        return this.hybridParent2;
    }

    public void setHybridParent2(Taxon hybridParent2) {
        this.hybridParent2 = hybridParent2;
    }

    @OneToMany(mappedBy="hybridParent1")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<Taxon> getHybridChildren1() {
        return this.hybridChildren1;
    }

    public void setHybridChildren1(Set<Taxon> hybridChildren1) {
        this.hybridChildren1 = hybridChildren1;
    }

    @OneToMany(mappedBy="hybridParent2")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<Taxon> getHybridChildren2() {
        return this.hybridChildren2;
    }

    public void setHybridChildren2(Set<Taxon> hybridChildren2) {
        this.hybridChildren2 = hybridChildren2;
    }

    @OneToMany(mappedBy="taxon")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<Determination> getDeterminations() {
        return this.determinations;
    }

    public void setDeterminations(Set<Determination> determinations) {
        this.determinations = determinations;
    }

    @OneToMany(mappedBy="taxon")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<CommonNameTx> getCommonNames() {
        return this.commonNames;
    }

    public void setCommonNames(Set<CommonNameTx> commonNames) {
        this.commonNames = commonNames;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="taxon")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<TaxonCitation> getTaxonCitations() {
        return this.taxonCitations;
    }

    public void setTaxonCitations(Set<TaxonCitation> taxonCitations) {
        this.taxonCitations = taxonCitations;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="TaxonTreeDefID", nullable=false)
    public TaxonTreeDef getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(TaxonTreeDef definition) {
        this.definition = definition;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="TaxonTreeDefItemID", nullable=false)
    public TaxonTreeDefItem getDefinitionItem() {
        return this.definitionItem;
    }

    @Override
    public void setDefinitionItem(TaxonTreeDefItem definitionItem) {
        this.definitionItem = definitionItem;
        if (definitionItem != null && definitionItem.getRankId() != null) {
            this.rankId = this.definitionItem.getRankId();
        }
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ParentID")
    public Taxon getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Taxon parent) {
        this.parent = parent;
    }

    @Override
    @OneToMany(mappedBy="parent")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<Taxon> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Set<Taxon> children) {
        this.children = children;
    }

    @Override
    @Transient
    public Integer getTreeId() {
        return this.taxonId;
    }

    @Override
    public void setTreeId(Integer id) {
        this.taxonId = id;
    }

    @OneToMany(mappedBy="taxon")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<TaxonAttachment> getTaxonAttachments() {
        return this.taxonAttachments;
    }

    public void setTaxonAttachments(Set<TaxonAttachment> taxonAttachments) {
        this.taxonAttachments = taxonAttachments;
    }

    @OneToMany(mappedBy="hostTaxon")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<CollectingEventAttribute> getCollectingEventAttributes() {
        return this.collectingEventAttributes;
    }

    public void setCollectingEventAttributes(Set<CollectingEventAttribute> collectingEventAttributes) {
        this.collectingEventAttributes = collectingEventAttributes;
    }

    @Override
    public void addChild(Taxon child) {
        Taxon oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public void removeChild(Taxon child) {
        this.children.remove(child);
        child.setParent((Taxon)null);
    }

    public void addAcceptedChild(Taxon child) {
        this.acceptedChildren.add(child);
        child.setAcceptedTaxon(this);
    }

    public void removeAcceptedChild(Taxon child) {
        this.acceptedChildren.remove(child);
        child.setAcceptedTaxon(null);
    }

    public void addTaxonCitations(TaxonCitation taxonCitation) {
        this.taxonCitations.add(taxonCitation);
        taxonCitation.setTaxon(this);
    }

    public void addDetermination(Determination determination) {
        this.determinations.add(determination);
        determination.setTaxon(this);
    }

    public void removeDetermination(Determination determination) {
        this.determinations.remove(determination);
        determination.setTaxon(null);
    }

    public void removeTaxonCitations(TaxonCitation taxonCitation) {
        this.taxonCitations.remove(taxonCitation);
        taxonCitation.setTaxon(null);
    }

    @Override
    public String toString() {
        return this.fullName != null ? this.fullName : (this.name != null ? this.name : super.toString());
    }

    @Override
    @Transient
    public int getFullNameDirection() {
        return this.definition.getFullNameDirection();
    }

    @Override
    @Transient
    public String getFullNameSeparator() {
        return this.definitionItem.getFullNameSeparator();
    }

    @Transient
    public Integer getCurrentDeterminationCount() {
        return this.getDeterminationCount(true);
    }

    @Transient
    public Integer getDeterminationCount(boolean current) {
        String sql = "SELECT count(co.CollectionObjectID) FROM taxon as tx INNER JOIN determination as dt ON tx.TaxonID = ";
        sql = this.isAccepted != false ? String.valueOf(sql) + "dt.PreferredTaxonID " : String.valueOf(sql) + "dt.TaxonID ";
        sql = String.valueOf(sql) + " INNER JOIN collectionobject as co ON dt.CollectionObjectID = co.CollectionObjectID WHERE tx.TaxonID = " + this.getId() + " AND co.CollectionMemberID = COLMEMID";
        if (current) {
            sql = String.valueOf(sql) + " AND dt.IsCurrent = true";
        }
        return BasicSQLUtils.getNumRecords(QueryAdjusterForDomain.getInstance().adjustSQL(sql));
    }

    public String fixFullName() {
        Vector<Taxon> parts = new Vector<Taxon>();
        parts.add(this);
        Taxon node = this.getParent();
        while (node != null) {
            Boolean include = node.getDefinitionItem().getIsInFullName();
            if (include != null && include.booleanValue()) {
                parts.add(node);
            }
            node = node.getParent();
        }
        int direction = this.getFullNameDirection();
        StringBuilder fullNameBuilder = new StringBuilder(parts.size() * 10);
        switch (direction) {
            case 1: {
                int j = parts.size() - 1;
                while (j > -1) {
                    Taxon part = (Taxon)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((Taxon)parts.get(j)).getFullNameSeparator());
                    }
                    --j;
                }
                break;
            }
            case -1: {
                int j = 0;
                while (j < parts.size()) {
                    Taxon part = (Taxon)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((Taxon)parts.get(j)).getFullNameSeparator());
                    }
                    ++j;
                }
                break;
            }
            default: {
                log.error((Object)"Invalid tree walk direction (for creating fullname field) found in tree definition");
                return null;
            }
        }
        return fullNameBuilder.toString().trim();
    }

    @Override
    @Transient
    public int getDescendantCount() {
        int totalDescendants = 0;
        for (Taxon child : this.getChildren()) {
            totalDescendants += 1 + child.getDescendantCount();
        }
        return totalDescendants;
    }

    @Override
    public boolean childrenAllowed() {
        return this.definitionItem != null && this.definitionItem.getChild() != null;
    }

    @Override
    @Transient
    public List<Taxon> getAllDescendants() {
        Vector<Taxon> descendants = new Vector<Taxon>();
        for (Taxon child : this.getChildren()) {
            descendants.add(child);
            descendants.addAll(child.getAllDescendants());
        }
        return descendants;
    }

    @Override
    @Transient
    public List<Taxon> getAllAncestors() {
        Vector<Taxon> ancestorsList = new Vector<Taxon>();
        Taxon parentNode = this.parent;
        while (parentNode != null) {
            ancestorsList.add(0, parentNode);
            parentNode = parentNode.getParent();
        }
        return ancestorsList;
    }

    @Override
    public boolean isDescendantOf(Taxon node) {
        if (node == null) {
            throw new NullPointerException();
        }
        Taxon i = this.getParent();
        while (i != null) {
            if (i == node) {
                return true;
            }
            if (i.getId().longValue() == node.getId().longValue()) {
                return true;
            }
            i = i.getParent();
        }
        return false;
    }

    @Override
    @Transient
    public Comparator<? super Taxon> getComparator() {
        return new TreeOrderSiblingComparator();
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Taxon.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return Taxon.getClassTableId();
    }

    public static int getClassTableId() {
        return 4;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Taxon) {
            Taxon item = (Taxon)obj;
            if (item.taxonId != null) {
                return item.taxonId.equals(this.taxonId);
            }
            return super.equals(obj);
        }
        return false;
    }

    @Override
    @Transient
    public Set<TaxonAttachment> getAttachmentReferences() {
        return this.taxonAttachments;
    }

    @Transient
    public Taxon getKingdom() {
        return this.getLevel(10);
    }

    @Transient
    public Taxon getGenus() {
        return this.getLevel(180);
    }

    @Transient
    public Taxon getSpecies() {
        return this.getLevel(220);
    }

    @Transient
    public Taxon getSubspecies() {
        return this.getLevel(230);
    }

    @Transient
    public String getKingdomName() {
        return this.getLevelName(10);
    }

    @Transient
    public String getGenusName() {
        return this.getLevelName(180);
    }

    @Transient
    public String getSpeciesName() {
        return this.getLevelName(220);
    }

    @Transient
    public String getSubspeciesName() {
        return this.getLevelName(230);
    }

    public Taxon getLevel(int levelRank) {
        Taxon t = this;
        while (t != null) {
            int rank;
            int n = rank = t.getRankId() != null ? t.getRankId() : Integer.MAX_VALUE;
            if (rank == levelRank) {
                return t;
            }
            if (rank < levelRank) {
                return null;
            }
            t = t.getParent();
        }
        return null;
    }

    public String getLevelName(int levelRank) {
        Taxon t = this.getLevel(levelRank);
        if (t != null) {
            return t.getName();
        }
        return null;
    }

    @Override
    public String getWebLinkData(String dataName) {
        if (StringUtils.isNotEmpty((String)dataName)) {
            if (dataName.equals("species")) {
                return this.getSpeciesName();
            }
            if (dataName.equals("genus")) {
                return this.getGenusName();
            }
            return super.getWebLinkData(dataName);
        }
        return null;
    }
}

