/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="storagetreedefitem")
public class StorageTreeDefItem
extends DataModelObjBase
implements Serializable,
TreeDefItemIface<Storage, StorageTreeDef, StorageTreeDefItem> {
    protected Integer storageTreeDefItemId;
    protected String name;
    protected String title;
    protected String remarks;
    protected Integer rankId;
    protected Boolean isEnforced;
    protected Boolean isInFullName;
    protected String textBefore;
    protected String textAfter;
    protected String fullNameSeparator;
    protected StorageTreeDef treeDef;
    protected StorageTreeDefItem parent;
    protected Set<Storage> treeEntries;
    protected Set<StorageTreeDefItem> children;

    public StorageTreeDefItem() {
    }

    public StorageTreeDefItem(Integer storageTreeDefItemId) {
        this.storageTreeDefItemId = storageTreeDefItemId;
    }

    @Override
    public void initialize() {
        super.init();
        this.storageTreeDefItemId = null;
        this.name = null;
        this.title = null;
        this.remarks = null;
        this.rankId = null;
        this.isEnforced = null;
        this.isInFullName = null;
        this.textBefore = null;
        this.textAfter = null;
        this.fullNameSeparator = ", ";
        this.treeDef = null;
        this.treeEntries = new HashSet<Storage>();
        this.parent = null;
        this.children = new HashSet<StorageTreeDefItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="StorageTreeDefItemID", unique=false, nullable=false, insertable=true, updatable=true, length=10)
    public Integer getStorageTreeDefItemId() {
        return this.storageTreeDefItemId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.storageTreeDefItemId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return StorageTreeDefItem.class;
    }

    public void setStorageTreeDefItemId(Integer storageTreeDefItemId) {
        this.storageTreeDefItemId = storageTreeDefItemId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Column(name="Title", nullable=true, length=64)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Transient
    public String getDisplayText() {
        return this.title != null ? this.title : this.name;
    }

    @Override
    public void setDisplayText(String text) {
        this.setTitle(text);
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="RankID", nullable=false)
    public Integer getRankId() {
        return this.rankId;
    }

    @Override
    public void setRankId(Integer rankId) {
        this.rankId = rankId;
    }

    @Override
    @Column(name="IsEnforced", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsEnforced() {
        return this.isEnforced;
    }

    @Override
    public void setIsEnforced(Boolean isEnforced) {
        this.isEnforced = isEnforced;
    }

    @Override
    @Column(name="IsInFullName", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsInFullName() {
        return this.isInFullName;
    }

    @Override
    public void setIsInFullName(Boolean isInFullName) {
        this.isInFullName = isInFullName;
    }

    @Override
    @Column(name="TextAfter", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getTextAfter() {
        return this.textAfter;
    }

    @Override
    public void setTextAfter(String textAfter) {
        this.textAfter = textAfter;
    }

    @Override
    @Column(name="TextBefore", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getTextBefore() {
        return this.textBefore;
    }

    @Override
    public void setTextBefore(String textBefore) {
        this.textBefore = textBefore;
    }

    @Override
    @Column(name="FullNameSeparator", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getFullNameSeparator() {
        return this.fullNameSeparator;
    }

    @Override
    public void setFullNameSeparator(String fullNameSeparator) {
        this.fullNameSeparator = fullNameSeparator;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="StorageTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public StorageTreeDef getTreeDef() {
        return this.treeDef;
    }

    @Override
    public void setTreeDef(StorageTreeDef treeDef) {
        this.treeDef = treeDef;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="ParentItemID", unique=false, nullable=true, insertable=true, updatable=true)
    public StorageTreeDefItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(StorageTreeDefItem parent) {
        this.parent = parent;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="definitionItem")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE})
    public Set<Storage> getTreeEntries() {
        return this.treeEntries;
    }

    @Override
    public void setTreeEntries(Set<Storage> treeEntries) {
        this.treeEntries = treeEntries;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="parent")
    public Set<StorageTreeDefItem> getChildren() {
        return this.children;
    }

    public void setChildren(Set<StorageTreeDefItem> children) {
        this.children = children;
    }

    @Override
    @Transient
    public Integer getTreeDefItemId() {
        return this.getStorageTreeDefItemId();
    }

    @Override
    public void setTreeDefItemId(Integer id) {
        this.setStorageTreeDefItemId(id);
    }

    @Override
    public void setChild(StorageTreeDefItem child) {
        if (!this.children.isEmpty()) {
            StorageTreeDefItem currentChild = this.children.iterator().next();
            currentChild.setParent((StorageTreeDefItem)null);
        }
        this.children.clear();
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    @Transient
    public StorageTreeDefItem getChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.iterator().next();
    }

    public void addTreeEntry(Storage entry) {
        this.treeEntries.add(entry);
        entry.setDefinitionItem(this);
    }

    public void removeTreeEntry(Storage entry) {
        this.treeEntries.remove(entry);
        entry.setDefinitionItem((StorageTreeDefItem)null);
    }

    public void removeChild(StorageTreeDefItem child) {
        this.children.remove(child);
        child.setParent((StorageTreeDefItem)null);
    }

    @Override
    public boolean canBeDeleted() {
        return this.treeEntries.isEmpty();
    }

    @Override
    @Transient
    public int getTableId() {
        return StorageTreeDefItem.getClassTableId();
    }

    @Override
    public boolean hasTreeEntries() {
        if (this.getId() == null) {
            return false;
        }
        String sql = "select distinct StorageTreeDefItemID from storage where StorageTreeDefItemID = " + this.getId();
        return BasicSQLUtils.getNumRecords(sql) > 0;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return StorageTreeDef.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    public static int getClassTableId() {
        return 60;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageTreeDefItem) {
            StorageTreeDefItem item = (StorageTreeDefItem)obj;
            if (item.storageTreeDefItemId != null) {
                return item.storageTreeDefItemId.equals(this.storageTreeDefItemId);
            }
            return super.equals(obj);
        }
        return false;
    }
}

