/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.BaseTreeDef;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="storagetreedef")
public class StorageTreeDef
extends BaseTreeDef<Storage, StorageTreeDef, StorageTreeDefItem>
implements Serializable {
    protected Integer storageTreeDefId;
    protected String name;
    protected String remarks;
    protected Integer fullNameDirection;
    protected Set<Institution> institutions;
    protected Set<Storage> treeEntries;
    protected Set<StorageTreeDefItem> treeDefItems;

    public StorageTreeDef() {
    }

    public StorageTreeDef(Integer storageTreeDefId) {
        this.storageTreeDefId = storageTreeDefId;
    }

    @Override
    public void initialize() {
        super.init();
        this.storageTreeDefId = null;
        this.name = null;
        this.remarks = null;
        this.fullNameDirection = null;
        this.institutions = new HashSet<Institution>();
        this.treeEntries = new HashSet<Storage>();
        this.treeDefItems = new HashSet<StorageTreeDefItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="StorageTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getStorageTreeDefId() {
        return this.storageTreeDefId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.storageTreeDefId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return StorageTreeDef.class;
    }

    public void setStorageTreeDefId(Integer storageTreeDefId) {
        this.storageTreeDefId = storageTreeDefId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="FullNameDirection", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getFullNameDirection() {
        return this.fullNameDirection;
    }

    @Override
    public void setFullNameDirection(Integer fullNameDirection) {
        this.fullNameDirection = fullNameDirection;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="storageTreeDef")
    public Set<Institution> getInstitutions() {
        return this.institutions;
    }

    public void setInstitutions(Set<Institution> institutions) {
        this.institutions = institutions;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="definition")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.LOCK})
    public Set<Storage> getTreeEntries() {
        return this.treeEntries;
    }

    @Override
    public void setTreeEntries(Set<Storage> treeEntries) {
        this.treeEntries = treeEntries;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.EAGER, mappedBy="treeDef")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.LOCK})
    public Set<StorageTreeDefItem> getTreeDefItems() {
        return this.treeDefItems;
    }

    @Override
    public void setTreeDefItems(Set<StorageTreeDefItem> treeDefItems) {
        this.treeDefItems = treeDefItems;
    }

    @Override
    @Transient
    public Integer getTreeDefId() {
        return this.getStorageTreeDefId();
    }

    @Override
    public void setTreeDefId(Integer id) {
        this.setStorageTreeDefId(id);
    }

    public void addTreeEntry(Storage loc) {
        this.treeEntries.add(loc);
        loc.setDefinition(this);
    }

    public void removeTreeEntry(Storage loc) {
        this.treeEntries.remove(loc);
        loc.setDefinition((StorageTreeDef)null);
    }

    public void addTreeDefItem(StorageTreeDefItem item) {
        this.treeDefItems.add(item);
        item.setTreeDef(this);
    }

    public void removeTreeDefItem(StorageTreeDefItem item) {
        this.treeDefItems.remove(item);
        item.setTreeDef((StorageTreeDef)null);
    }

    @Override
    @Transient
    public Class<Storage> getNodeClass() {
        return Storage.class;
    }

    @Override
    public StorageTreeDefItem getDefItemByRank(Integer rank) {
        for (StorageTreeDefItem item : this.treeDefItems) {
            if (!item.getRankId().equals(rank)) continue;
            return item;
        }
        return null;
    }

    public boolean canChildBeReparentedToNode(Storage child, Storage newParent) {
        if (newParent.getRankId() >= child.getRankId()) {
            return false;
        }
        Integer nextEnforcedRank = this.getRankOfNextHighestEnforcedLevel(child);
        if (nextEnforcedRank == null) {
            return true;
        }
        return nextEnforcedRank <= newParent.getRankId();
    }

    public Integer getRankOfNextHighestEnforcedLevel(Storage node) {
        StorageTreeDefItem defItem = node.getDefinitionItem();
        while (defItem.getParent() != null) {
            if ((defItem = defItem.getParent()).getIsEnforced() == null || !defItem.getIsEnforced().booleanValue()) continue;
            return defItem.getRankId();
        }
        return null;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Institution.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT InstitutionID FROM institution WHERE StorageTreeDefID = " + this.storageTreeDefId);
        if (ids.size() == 1) {
            return (Integer)ids.get(0);
        }
        return null;
    }

    @Override
    @Transient
    public int getSynonymizedLevel() {
        return 1;
    }

    @Override
    @Transient
    public int getTableId() {
        return StorageTreeDef.getClassTableId();
    }

    public static int getClassTableId() {
        return 59;
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }

    @Override
    @Transient
    public int getRankIncrement() {
        return 50;
    }

    @Override
    @Transient
    public List<TreeDefItemStandardEntry> getStandardLevels() {
        LinkedList<TreeDefItemStandardEntry> result = new LinkedList<TreeDefItemStandardEntry>();
        result.add(new TreeDefItemStandardEntry("Building", 100));
        result.add(new TreeDefItemStandardEntry("Collection", 150));
        result.add(new TreeDefItemStandardEntry("Room", 200));
        result.add(new TreeDefItemStandardEntry("Aisle", 250));
        result.add(new TreeDefItemStandardEntry("Cabinet", 300));
        result.add(new TreeDefItemStandardEntry("Shelf", 350));
        result.add(new TreeDefItemStandardEntry("Box", 400));
        result.add(new TreeDefItemStandardEntry("Rack", 450));
        result.add(new TreeDefItemStandardEntry("Vial", 500));
        return result;
    }
}

