/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeOrderSiblingComparator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="storage")
@Table(appliesTo="storage", indexes={@Index(name="StorNameIDX", columnNames={"Name"}), @Index(name="StorFullNameIDX", columnNames={"FullName"})})
public class Storage
extends DataModelObjBase
implements Serializable,
Treeable<Storage, StorageTreeDef, StorageTreeDefItem> {
    protected static final Logger log = Logger.getLogger(Storage.class);
    protected Integer storageId;
    protected String name;
    protected String fullName;
    protected String remarks;
    protected Integer rankId;
    protected Integer nodeNumber;
    protected Integer highestChildNodeNumber;
    protected String abbrev;
    protected String text1;
    protected String text2;
    protected Integer number1;
    protected Integer number2;
    protected Date timestampVersion;
    protected StorageTreeDef definition;
    protected StorageTreeDefItem definitionItem;
    protected Storage parent;
    protected Set<Preparation> preparations;
    protected Set<Container> containers;
    protected Set<Storage> children;
    protected Boolean isAccepted;
    protected Storage acceptedStorage;
    protected Set<Storage> acceptedChildren;

    public Storage() {
    }

    public Storage(Integer storageId) {
        this.storageId = storageId;
    }

    @Override
    public void initialize() {
        super.init();
        this.storageId = null;
        this.name = null;
        this.fullName = null;
        this.remarks = null;
        this.rankId = null;
        this.nodeNumber = null;
        this.highestChildNodeNumber = null;
        this.abbrev = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.timestampVersion = null;
        this.definition = null;
        this.definitionItem = null;
        this.parent = null;
        this.preparations = new HashSet<Preparation>();
        this.containers = new HashSet<Container>();
        this.children = new HashSet<Storage>();
        this.isAccepted = true;
        this.acceptedStorage = null;
        this.acceptedChildren = new HashSet<Storage>();
    }

    @Id
    @GeneratedValue
    @Column(name="StorageID")
    public Integer getStorageId() {
        return this.storageId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.storageId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Storage.class;
    }

    public void setStorageId(Integer storageId) {
        this.storageId = storageId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="FullName", length=255)
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="RankID", nullable=false)
    public Integer getRankId() {
        return this.rankId;
    }

    @Override
    public void setRankId(Integer rankId) {
        this.rankId = rankId;
    }

    @Override
    @Column(name="NodeNumber")
    public Integer getNodeNumber() {
        return this.nodeNumber;
    }

    @Override
    public void setNodeNumber(Integer nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    @Override
    @Column(name="HighestChildNodeNumber")
    public Integer getHighestChildNodeNumber() {
        return this.highestChildNodeNumber;
    }

    @Override
    public void setHighestChildNodeNumber(Integer highestChildNodeNumber) {
        this.highestChildNodeNumber = highestChildNodeNumber;
    }

    @Column(name="Abbrev", length=16)
    public String getAbbrev() {
        return this.abbrev;
    }

    public void setAbbrev(String abbrev) {
        this.abbrev = abbrev;
    }

    @Column(name="Text1", length=32)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=32)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1")
    public Integer getNumber1() {
        return this.number1;
    }

    public void setNumber1(Integer number1) {
        this.number1 = number1;
    }

    @Column(name="Number2")
    public Integer getNumber2() {
        return this.number2;
    }

    public void setNumber2(Integer number2) {
        this.number2 = number2;
    }

    @Column(name="TimestampVersion")
    public Date getTimestampVersion() {
        return this.timestampVersion;
    }

    public void setTimestampVersion(Date timestampVersion) {
        this.timestampVersion = timestampVersion;
    }

    @Override
    @Column(name="IsAccepted")
    public Boolean getIsAccepted() {
        return this.isAccepted;
    }

    @Override
    public void setIsAccepted(Boolean accepted) {
        this.isAccepted = accepted;
    }

    @Override
    @OneToMany(fetch=FetchType.EAGER, mappedBy="acceptedStorage")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<Storage> getAcceptedChildren() {
        return this.acceptedChildren;
    }

    @Override
    public void setAcceptedChildren(Set<Storage> acceptedChildren) {
        this.acceptedChildren = acceptedChildren;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AcceptedID")
    public Storage getAcceptedStorage() {
        return this.acceptedStorage;
    }

    public void setAcceptedStorage(Storage acceptedStorage) {
        this.acceptedStorage = acceptedStorage;
    }

    @Override
    @Transient
    public Storage getAcceptedParent() {
        return this.getAcceptedStorage();
    }

    @Override
    public void setAcceptedParent(Storage acceptedParent) {
        this.setAcceptedStorage(acceptedParent);
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="StorageTreeDefID", nullable=false)
    public StorageTreeDef getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(StorageTreeDef definition) {
        this.definition = definition;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="StorageTreeDefItemID", nullable=false)
    public StorageTreeDefItem getDefinitionItem() {
        return this.definitionItem;
    }

    @Override
    public void setDefinitionItem(StorageTreeDefItem definitionItem) {
        this.definitionItem = definitionItem;
        if (definitionItem != null && definitionItem.getRankId() != null) {
            this.rankId = this.definitionItem.getRankId();
        }
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ParentID")
    public Storage getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Storage parent) {
        this.parent = parent;
    }

    @OneToMany(mappedBy="storage")
    @Cascade(value={CascadeType.MERGE, CascadeType.LOCK})
    public Set<Preparation> getPreparations() {
        return this.preparations;
    }

    public void setPreparations(Set<Preparation> preparations) {
        this.preparations = preparations;
    }

    @OneToMany(mappedBy="storage")
    @Cascade(value={CascadeType.MERGE, CascadeType.LOCK})
    public Set<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(Set<Container> containers) {
        this.containers = containers;
    }

    @Override
    @OneToMany(mappedBy="parent")
    @Cascade(value={CascadeType.ALL})
    public Set<Storage> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Set<Storage> children) {
        this.children = children;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Storage.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    @Override
    @Transient
    public Integer getTreeId() {
        return this.getStorageId();
    }

    @Override
    public void setTreeId(Integer id) {
        this.setStorageId(id);
    }

    @Override
    public void addChild(Storage child) {
        Storage oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public void removeChild(Storage child) {
        this.children.remove(child);
        child.setParent((Storage)null);
    }

    @Override
    public String toString() {
        return this.fullName != null ? this.fullName : super.toString();
    }

    @Override
    @Transient
    public int getFullNameDirection() {
        return this.definition.getFullNameDirection();
    }

    @Override
    @Transient
    public String getFullNameSeparator() {
        return this.definitionItem.getFullNameSeparator();
    }

    public String fixFullName() {
        Vector<Storage> parts = new Vector<Storage>();
        parts.add(this);
        Storage node = this.getParent();
        while (node != null) {
            Boolean include = node.getDefinitionItem().getIsInFullName();
            if (include != null && include.booleanValue()) {
                parts.add(node);
            }
            node = node.getParent();
        }
        int direction = this.getFullNameDirection();
        StringBuilder fullNameBuilder = new StringBuilder(parts.size() * 10);
        switch (direction) {
            case 1: {
                int j = parts.size() - 1;
                while (j > -1) {
                    Storage part = (Storage)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((Storage)parts.get(j)).getFullNameSeparator());
                    }
                    --j;
                }
                break;
            }
            case -1: {
                int j = 0;
                while (j < parts.size()) {
                    Storage part = (Storage)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((Storage)parts.get(j)).getFullNameSeparator());
                    }
                    ++j;
                }
                break;
            }
            default: {
                log.error((Object)"Invalid tree walk direction (for creating fullname field) found in tree definition");
                return null;
            }
        }
        return fullNameBuilder.toString().trim();
    }

    @Override
    @Transient
    public int getDescendantCount() {
        int totalDescendants = 0;
        for (Storage child : this.getChildren()) {
            totalDescendants += 1 + child.getDescendantCount();
        }
        return totalDescendants;
    }

    @Override
    public boolean childrenAllowed() {
        return this.definitionItem != null && this.definitionItem.getChild() != null;
    }

    @Override
    @Transient
    public List<Storage> getAllDescendants() {
        Vector<Storage> descendants = new Vector<Storage>();
        for (Storage child : this.getChildren()) {
            descendants.add(child);
            descendants.addAll(child.getAllDescendants());
        }
        return descendants;
    }

    @Override
    @Transient
    public List<Storage> getAllAncestors() {
        Vector<Storage> ancestors = new Vector<Storage>();
        Storage parentNode = this.parent;
        while (parentNode != null) {
            ancestors.add(0, parentNode);
            parentNode = parentNode.getParent();
        }
        return ancestors;
    }

    @Override
    public boolean isDescendantOf(Storage node) {
        if (node == null) {
            throw new NullPointerException();
        }
        Storage i = this.getParent();
        while (i != null) {
            if (i.getId() == this.getId()) {
                return true;
            }
            i = i.getParent();
        }
        return false;
    }

    @Override
    @Transient
    public Comparator<? super Storage> getComparator() {
        return new TreeOrderSiblingComparator();
    }

    @Override
    @Transient
    public int getTableId() {
        return Storage.getClassTableId();
    }

    public static int getClassTableId() {
        return 58;
    }
}

