/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.auth.specify.principal.GroupPrincipal;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpTaskSemaphore;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="specifyuser")
public class SpecifyUser
extends DataModelObjBase
implements Serializable,
Comparable<SpecifyUser> {
    protected Integer specifyUserId;
    protected String name;
    protected String email;
    protected String password;
    protected String userType;
    protected Boolean isLoggedIn;
    protected String loginCollectionName;
    protected String loginDisciplineName;
    protected Boolean isLoggedInReport;
    protected Timestamp loginOutTime;
    protected Long accumMinLoggedIn;
    protected Set<Workbench> workbenches;
    protected Set<WorkbenchTemplate> workbenchTemplates;
    protected Set<SpAppResource> spAppResources;
    protected Set<SpPrincipal> spPrincipals;
    protected Set<SpAppResourceDir> spAppResourceDirs;
    protected Set<SpQuery> spQuerys;
    protected Set<Agent> agents;
    protected Set<SpTaskSemaphore> taskSemaphores;

    public SpecifyUser() {
    }

    public SpecifyUser(Integer specifyUserId) {
        this.specifyUserId = specifyUserId;
    }

    @Override
    public void initialize() {
        super.init();
        this.specifyUserId = null;
        this.name = null;
        this.email = null;
        this.isLoggedIn = false;
        this.loginCollectionName = null;
        this.loginDisciplineName = null;
        this.isLoggedInReport = false;
        this.loginOutTime = null;
        this.workbenches = new HashSet<Workbench>();
        this.workbenchTemplates = new HashSet<WorkbenchTemplate>();
        this.spAppResources = new HashSet<SpAppResource>();
        this.spPrincipals = new HashSet<SpPrincipal>();
        this.spAppResourceDirs = new HashSet<SpAppResourceDir>();
        this.spQuerys = new HashSet<SpQuery>();
        this.agents = new HashSet<Agent>();
        this.taskSemaphores = new HashSet<SpTaskSemaphore>();
    }

    @Id
    @GeneratedValue
    @Column(name="SpecifyUserID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpecifyUserId() {
        return this.specifyUserId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.specifyUserId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpecifyUser.class;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public void setSpecifyUserId(Integer specifyUserId) {
        this.specifyUserId = specifyUserId;
    }

    @Column(name="Name", unique=true, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="EMail", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="Password", unique=false, nullable=false, insertable=true, updatable=true, length=255)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name="UserType", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    @Column(name="AccumMinLoggedIn", unique=false, nullable=true, insertable=true, updatable=true)
    public Long getAccumMinLoggedIn() {
        return this.accumMinLoggedIn;
    }

    public void setAccumMinLoggedIn(Long accumMinLoggedIn) {
        this.accumMinLoggedIn = accumMinLoggedIn;
    }

    @Column(name="LoginOutTime", unique=false, nullable=true, insertable=true, updatable=true)
    public Timestamp getLoginOutTime() {
        return this.loginOutTime;
    }

    public void setLoginOutTime(Timestamp loginOutTime) {
        if (loginOutTime != null && loginOutTime.getTime() > 0L) {
            this.loginOutTime = loginOutTime;
        }
    }

    @Column(name="IsLoggedIn", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsLoggedIn() {
        return this.isLoggedIn != null ? this.isLoggedIn : false;
    }

    public void setIsLoggedIn(Boolean isLoggedIn) {
        this.isLoggedIn = isLoggedIn;
    }

    @Column(name="LoginCollectionName", nullable=true, length=64)
    public String getLoginCollectionName() {
        return this.loginCollectionName;
    }

    public void setLoginCollectionName(String loginCollectionName) {
        this.loginCollectionName = loginCollectionName;
    }

    @Column(name="LoginDisciplineName", nullable=true, length=64)
    public String getLoginDisciplineName() {
        return this.loginDisciplineName;
    }

    public void setLoginDisciplineName(String loginDisciplineName) {
        this.loginDisciplineName = loginDisciplineName;
    }

    @Column(name="IsLoggedInReport", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsLoggedInReport() {
        return this.isLoggedInReport;
    }

    public void setIsLoggedInReport(Boolean isLoggedInReport) {
        this.isLoggedInReport = isLoggedInReport;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY)
    @JoinTable(name="specifyuser_spprincipal", joinColumns={@JoinColumn(name="SpecifyUserID", unique=false, nullable=false, insertable=true, updatable=false)}, inverseJoinColumns={@JoinColumn(name="SpPrincipalID", unique=false, nullable=false, insertable=true, updatable=false)})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Set<SpPrincipal> getSpPrincipals() {
        return this.spPrincipals;
    }

    public void setSpPrincipals(Set<SpPrincipal> spPrincipals) {
        this.spPrincipals = spPrincipals;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="specifyUser")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<SpAppResourceDir> getSpAppResourceDirs() {
        return this.spAppResourceDirs;
    }

    public void setSpAppResourceDirs(Set<SpAppResourceDir> spAppResourceDirs) {
        this.spAppResourceDirs = spAppResourceDirs;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="specifyUser")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<SpAppResource> getSpAppResources() {
        return this.spAppResources;
    }

    public void setSpAppResources(Set<SpAppResource> spAppResources) {
        this.spAppResources = spAppResources;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="specifyUser")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<Workbench> getWorkbenches() {
        return this.workbenches;
    }

    public void setWorkbenches(Set<Workbench> workbench) {
        this.workbenches = workbench;
    }

    public void setWorkbenchTemplates(Set<WorkbenchTemplate> workbenchTemplates) {
        this.workbenchTemplates = workbenchTemplates;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="specifyUser")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<WorkbenchTemplate> getWorkbenchTemplates() {
        return this.workbenchTemplates;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="specifyUser")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<Agent> getAgents() {
        return this.agents;
    }

    @OneToMany(mappedBy="owner")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<SpTaskSemaphore> getTaskSemaphores() {
        return this.taskSemaphores;
    }

    public void setTaskSemaphores(Set<SpTaskSemaphore> taskSemaphores) {
        this.taskSemaphores = taskSemaphores;
    }

    public void setAgents(Set<Agent> agents) {
        this.agents = agents;
    }

    public void addUserToSpPrincipalGroup(SpPrincipal userGroupArg) {
        this.spPrincipals.add(userGroupArg);
        userGroupArg.getSpecifyUsers().add(this);
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="specifyUser")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<SpQuery> getSpQuerys() {
        return this.spQuerys;
    }

    public void removeUserGroups(SpPrincipal userGroupArg) {
        this.spPrincipals.remove(userGroupArg);
        userGroupArg.getSpecifyUsers().remove(this);
    }

    public void setSpQuerys(Set<SpQuery> spQuerys) {
        this.spQuerys = spQuerys;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpecifyUser.getClassTableId();
    }

    public static int getClassTableId() {
        return 72;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        if (this.name != null) {
            return this.name;
        }
        return super.getIdentityTitle();
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.getIdentityTitle();
    }

    @Transient
    public int getUserGroupCount() {
        int count = 0;
        for (SpPrincipal principal : this.getSpPrincipals()) {
            if (!GroupPrincipal.class.getCanonicalName().equals(principal.getGroupSubClass()) && !AdminPrincipal.class.getCanonicalName().equals(principal.getGroupSubClass())) continue;
            ++count;
        }
        return count;
    }

    @Transient
    public boolean canRemoveFromGroup() {
        return this.getUserGroupCount() > 1;
    }

    @Transient
    public boolean isInAdminGroup() {
        for (SpPrincipal principal : this.getSpPrincipals()) {
            if (!AdminPrincipal.class.getCanonicalName().equals(principal.getGroupSubClass())) continue;
            return true;
        }
        return false;
    }

    @Transient
    public SpPrincipal getUserPrincipal(String groupClassStr, Integer collectionID) {
        if (collectionID != null) {
            for (SpPrincipal principal : this.getSpPrincipals()) {
                Integer colId;
                if (!groupClassStr.equals(principal.getGroupSubClass()) || (colId = SpPrincipal.getUserGroupScopeFromPrincipal(principal.getId())) == null || !collectionID.equals(colId)) continue;
                return principal;
            }
        }
        return null;
    }

    @Transient
    public static boolean isCurrentUserType(SpecifyUserTypes.UserType userType) {
        SpecifyUser currentUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        if (currentUser != null) {
            return currentUser.getUserType().equals(userType.toString());
        }
        return false;
    }

    @Override
    public int compareTo(SpecifyUser obj) {
        if (this.name != null && obj != null && StringUtils.isNotEmpty((String)obj.name)) {
            return this.name.compareTo(obj.name);
        }
        if (this.email != null && obj != null && StringUtils.isNotEmpty((String)obj.email)) {
            return this.email.compareTo(obj.email);
        }
        return this.timestampCreated != null && obj != null && obj.timestampCreated != null ? this.timestampCreated.compareTo(obj.timestampCreated) : 0;
    }
}

