/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpAppResourceData;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spviewsetobj")
@Table(appliesTo="spviewsetobj", indexes={@Index(name="SpViewObjNameIDX", columnNames={"Name"})})
public class SpViewSetObj
extends DataModelObjBase
implements Serializable,
AppResourceIFace,
Comparable<SpViewSetObj> {
    protected Integer spViewSetObjId;
    protected Short level;
    protected String name;
    protected String description;
    protected String metaData;
    protected Set<SpAppResourceData> spAppResourceDatas;
    protected SpAppResourceDir spAppResourceDir;
    protected String fileName = null;
    protected Properties metaDataHash = null;

    public SpViewSetObj() {
    }

    public SpViewSetObj(Integer spViewSetObjId) {
        this.spViewSetObjId = spViewSetObjId;
    }

    @Override
    public void initialize() {
        super.init();
        this.spViewSetObjId = null;
        this.level = null;
        this.name = null;
        this.fileName = null;
        this.description = null;
        this.metaData = null;
        this.spAppResourceDir = null;
        this.spAppResourceDatas = new HashSet<SpAppResourceData>();
    }

    @Id
    @GeneratedValue
    @Column(name="SpViewSetObjID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpViewSetObjId() {
        return this.spViewSetObjId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spViewSetObjId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpViewSetObj.class;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public void setSpViewSetObjId(Integer spViewSetObjId) {
        this.spViewSetObjId = spViewSetObjId;
    }

    @Override
    @Column(name="Level", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Short level) {
        this.level = level;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true)
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Transient
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public void setMimeType(String mimeType) {
        throw new RuntimeException("Can't set MimeType");
    }

    @Override
    @Column(name="FileName", unique=false, nullable=true, insertable=true, updatable=true)
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    @Column(name="MetaData", unique=false, nullable=true, insertable=true, updatable=true)
    public String getMetaData() {
        return this.metaData;
    }

    @Override
    public String getMetaData(String attr) {
        this.initMetaData();
        return this.metaDataHash != null ? this.metaDataHash.getProperty(attr) : null;
    }

    @Override
    public void setMetaData(String metaData) {
        if (StringUtils.isNotEmpty((String)this.metaData) && this.metaDataHash != null) {
            this.metaDataHash.clear();
        }
        this.metaData = metaData;
    }

    @Override
    @Transient
    public Properties getMetaDataMap() {
        this.initMetaData();
        return this.metaDataHash;
    }

    protected void initMetaData() {
        if (this.metaDataHash == null) {
            this.metaDataHash = new Properties();
        }
        if (StringUtils.isNotEmpty((String)this.metaData)) {
            String[] stringArray = this.metaData.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] tokens;
                String pair = stringArray[n2];
                if (StringUtils.isNotEmpty((String)pair) && (tokens = pair.split("=")) != null && tokens.length == 2) {
                    this.metaDataHash.put(tokens[0], tokens[1]);
                }
                ++n2;
            }
        }
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpAppResourceDirID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpAppResourceDir getSpAppResourceDir() {
        return this.spAppResourceDir;
    }

    public void setSpAppResourceDir(SpAppResourceDir spAppResourceDir) {
        this.spAppResourceDir = spAppResourceDir;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spViewSetObj")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpAppResourceData> getSpAppResourceDatas() {
        return this.spAppResourceDatas;
    }

    public void setSpAppResourceDatas(Set<SpAppResourceData> spAppResourceDatas) {
        this.spAppResourceDatas = spAppResourceDatas;
    }

    @Override
    public void setDataAsString(String dataStr) {
        this.setDataAsString(dataStr, false);
    }

    public void setDataAsString(String dataStr, boolean doCreateSession) {
        DataProviderSessionIFace session = null;
        try {
            try {
                if (StringUtils.isNotEmpty((String)dataStr)) {
                    SpAppResourceData appResData;
                    if (this.getId() != null && doCreateSession) {
                        session = DataProviderFactory.getInstance().createSession();
                        session.attach(this);
                    }
                    if (this.spAppResourceDatas.size() == 0) {
                        appResData = new SpAppResourceData();
                        appResData.initialize();
                        appResData.setSpViewSetObj(this);
                        this.spAppResourceDatas.add(appResData);
                    } else {
                        appResData = this.spAppResourceDatas.iterator().next();
                    }
                    appResData.setData(dataStr.getBytes());
                } else if (this.spAppResourceDatas.size() > 0) {
                    this.spAppResourceDatas.iterator().next().setData(null);
                }
                this.setSpAppResourceDatas(this.spAppResourceDatas);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    @Transient
    public String getDataAsString() {
        return this.getDataAsString(false);
    }

    @Transient
    public String getDataAsString(boolean doCreateSession) {
        DataProviderSessionIFace session = null;
        try {
            if (this.getId() != null && doCreateSession) {
                session = DataProviderFactory.getInstance().createSession();
                session.attach(this);
            }
            this.getSpAppResourceDatas();
            SpAppResourceData ard = null;
            if (this.spAppResourceDatas.size() > 0 && (ard = this.spAppResourceDatas.iterator().next()) != null) {
                String string = new String(ard.getData());
                return string;
            }
            String str = null;
            if (StringUtils.isNotEmpty((String)this.fileName)) {
                File file = new File(this.fileName);
                str = XMLHelper.getContents(file);
                this.timestampCreated = new Timestamp(file.lastModified());
            }
            if (StringUtils.isNotEmpty(str)) {
                String string = StringEscapeUtils.unescapeXml(str);
                return string;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpViewSetObj.getClassTableId();
    }

    public static int getClassTableId() {
        return 86;
    }

    @Override
    public int compareTo(SpViewSetObj o) {
        return this.name.compareToIgnoreCase(o.name);
    }
}

