/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="spversion")
public class SpVersion
extends DataModelObjBase
implements Serializable {
    protected Integer spVersionId;
    protected String appName;
    protected String appVersion;
    protected String schemaVersion;
    protected Boolean isDBClosed;
    protected String dbClosedBy;

    public SpVersion() {
    }

    public SpVersion(Integer VersionId) {
        this.spVersionId = VersionId;
    }

    @Override
    public void initialize() {
        super.init();
        this.spVersionId = null;
        this.appName = null;
        this.appVersion = null;
        this.schemaVersion = null;
        this.isDBClosed = null;
        this.dbClosedBy = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpVersionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpVersionId() {
        return this.spVersionId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spVersionId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpVersion.class;
    }

    public void setSpVersionId(Integer VersionId) {
        this.spVersionId = VersionId;
    }

    @Column(name="AppName", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Column(name="AppVersion", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    @Column(name="SchemaVersion", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    @Column(name="IsDBClosed", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsDBClosed() {
        if (this.isDBClosed != null && this.isDBClosed.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setIsDBClosed(Boolean isDBClosed) {
        this.isDBClosed = isDBClosed;
    }

    @Column(name="DbClosedBy", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getDbClosedBy() {
        return this.dbClosedBy;
    }

    public void setDbClosedBy(String dbClosedBy) {
        this.dbClosedBy = dbClosedBy;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        StringBuilder sb = new StringBuilder();
        Address.append(sb, this.appName);
        if (sb.length() > 0) {
            return sb.toString();
        }
        return super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return SpVersion.getClassTableId();
    }

    public static int getClassTableId() {
        return 529;
    }

    private static boolean createInitialRecordInternal(Connection conn, String appVerNum, String dbVersion) {
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String sql = "INSERT INTO spversion (AppName, AppVersion, SchemaVersion, TimestampCreated, TimestampModified, Version) VALUES('Specify', '" + appVerNum + "', '" + dbVersion + "', '" + dateTimeFormatter.format(now) + "', '" + dateTimeFormatter.format(now) + "', 1)";
        return BasicSQLUtils.update(conn, sql) == 1;
    }

    public static boolean createInitialRecord(Connection conn, String appVerNum, String dbVersion) {
        int numRecords = BasicSQLUtils.getNumRecords(conn, "spversion");
        if (numRecords == 0) {
            return SpVersion.createInitialRecordInternal(conn, appVerNum, dbVersion);
        }
        int recVerNum = 1;
        int spverId = 1;
        Vector<Object[]> row = BasicSQLUtils.query(conn, "SELECT SpVersionID, Version FROM spversion ORDER BY SpVersionID ASC");
        if (row == null || row.size() <= 0) {
            return SpVersion.createInitialRecordInternal(conn, appVerNum, dbVersion);
        }
        Object[] r = row.get(0);
        spverId = (Integer)r[0];
        recVerNum = (Integer)r[1] + 1;
        BasicSQLUtils.update(conn, "DELETE FROM spversion WHERE SpVersionID > " + spverId);
        return SpVersion.updateRecord(conn, appVerNum, dbVersion, recVerNum, spverId);
    }

    public static boolean updateRecord(Connection conn, String appVerNum, String dbVersion, int recVerNum, int spverId) {
        String sql = "UPDATE spversion SET AppVersion='" + appVerNum + "', SchemaVersion='" + dbVersion + "', Version=" + recVerNum + " WHERE SpVersionID = " + spverId;
        return BasicSQLUtils.update(conn, sql) == 1;
    }

    public static boolean fixSchemaNumber(DBConnection dbConn) {
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        Connection conn = dbConn.createConnection();
        mgr.setConnection(conn);
        if (mgr.doesDBHaveTable("spversion")) {
            String sql = "UPDATE spversion SET SchemaVersion='1.5' WHERE SchemaVersion ='6.3.00'";
            return BasicSQLUtils.update(conn, sql) == 1;
        }
        return true;
    }
}

