/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpUIView;
import edu.ku.brc.specify.datamodel.SpUIViewDef;
import edu.ku.brc.specify.datamodel.SpViewSetObj;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spuiviewset")
@Table(appliesTo="spuiviewset", indexes={@Index(name="SpUIViewSetNameIDX", columnNames={"Name"})})
public class SpUIViewSet
extends DataModelObjBase
implements ViewSetIFace {
    public static final Byte USER_TYPE = 0;
    public static final Byte SYSTEM_TYPE = 1;
    protected Integer spUIViewSetId;
    protected Byte viewType;
    protected String name;
    protected String title;
    protected String fileName;
    protected String i18NResourceName;
    protected File dirPath;
    protected SpViewSetObj spViewSetObj;
    protected Set<SpUIView> spViews;
    protected Set<SpUIViewDef> spViewDefs;
    protected Hashtable<String, ViewDefIFace> viewDefHash = null;
    protected Hashtable<String, ViewIFace> viewHash = null;

    @Override
    public void initialize() {
        super.init();
        this.spUIViewSetId = null;
        this.viewType = null;
        this.name = null;
        this.title = null;
        this.fileName = null;
        this.dirPath = null;
        this.i18NResourceName = null;
        this.spViewSetObj = null;
        this.spViews = new HashSet<SpUIView>();
        this.spViewDefs = new HashSet<SpUIViewDef>();
    }

    @Id
    @GeneratedValue
    @Column(name="SpUIViewSetID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpUIViewSetId() {
        return this.spUIViewSetId;
    }

    public void setSpUIViewSetId(Integer spUIViewSetId) {
        this.spUIViewSetId = spUIViewSetId;
    }

    @Transient
    public File getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(File dirPath) {
        this.dirPath = dirPath;
    }

    @Override
    @Column(name="File", unique=false, nullable=false, insertable=true, updatable=true, length=255)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="Title", unique=false, nullable=false, insertable=true, updatable=true, length=128)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Column(name="I18NResourceName", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getI18NResourceName() {
        return this.i18NResourceName;
    }

    public void setI18NResourceName(String resourceName) {
        this.i18NResourceName = resourceName;
    }

    @Column(name="ViewType", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getViewType() {
        return this.viewType;
    }

    public void setViewType(Byte type) {
        this.viewType = type;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spViewSet")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpUIViewDef> getSpViewDefs() {
        return this.spViewDefs;
    }

    public void setSpViewDefs(Set<SpUIViewDef> viewDefs) {
        this.spViewDefs = viewDefs;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spViewSet")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpUIView> getSpViews() {
        return this.spViews;
    }

    public void setSpViews(Set<SpUIView> views) {
        this.spViews = views;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpViewSetObjID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpViewSetObj getSpViewSetObj() {
        return this.spViewSetObj;
    }

    public void setSpViewSetObj(SpViewSetObj spViewSetObj) {
        this.spViewSetObj = spViewSetObj;
    }

    @Override
    public boolean isDiskBased() {
        return false;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spUIViewSetId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpUIViewSet.class;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpUIViewSet.getClassTableId();
    }

    public static int getClassTableId() {
        return 511;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public int compareTo(ViewSetIFace obj) {
        return this.name != null && obj != null && obj.getName() != null ? this.name.compareTo(obj.getName()) : 0;
    }

    @Override
    @Transient
    public ViewSetIFace.Type getType() {
        return this.viewType == USER_TYPE ? ViewSetIFace.Type.User : ViewSetIFace.Type.System;
    }

    @Override
    @Transient
    public ViewIFace getView(String nameStr) {
        for (SpUIView view : this.spViews) {
            if (!view.getName().equals(nameStr)) continue;
            return view;
        }
        return null;
    }

    @Override
    @Transient
    public Hashtable<String, ViewDefIFace> getViewDefs() {
        if (this.viewDefHash == null) {
            this.viewDefHash = new Hashtable();
            for (SpUIViewDef vd : this.spViewDefs) {
                this.viewDefHash.put(vd.getName(), vd);
            }
        }
        return this.viewDefHash;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Override
    @Transient
    public Hashtable<String, ViewIFace> getViews() {
        if (this.viewHash == null) {
            this.viewHash = new Hashtable();
            for (SpUIView v : this.spViews) {
                this.viewHash.put(v.getName(), v);
            }
        }
        return this.viewHash;
    }

    @Override
    @Transient
    public boolean isSystem() {
        return this.viewType == SYSTEM_TYPE;
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("<viewset name=\"" + this.name + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        sb.append("    <views>\n");
        Vector<SpUIView> sortedViews = new Vector<SpUIView>();
        sortedViews.addAll(this.spViews);
        Collections.sort(sortedViews);
        for (SpUIView view : sortedViews) {
            view.toXML(sb);
        }
        sb.append("    </views>\n");
        sb.append("    <viewdefs>\n");
        Vector<SpUIViewDef> sortedViewDefs = new Vector<SpUIViewDef>();
        sortedViewDefs.addAll(this.spViewDefs);
        Collections.sort(sortedViewDefs);
        for (SpUIViewDef viewDef : sortedViewDefs) {
            viewDef.toXML(sb);
        }
        sb.append("    </viewdefs>\n");
        sb.append("</viewset>\n");
    }
}

