/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormColumnIFace;
import edu.ku.brc.af.ui.forms.persist.FormRowIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.TableViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewLoader;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpUIAltView;
import edu.ku.brc.specify.datamodel.SpUIColumn;
import edu.ku.brc.specify.datamodel.SpUIRow;
import edu.ku.brc.specify.datamodel.SpUIViewSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spuiviewdef")
@Table(appliesTo="spuiviewdef", indexes={@Index(name="SpUIViewDefNameIDX", columnNames={"Name"})})
public class SpUIViewDef
extends DataModelObjBase
implements ViewDefIFace,
TableViewDefIFace,
FormViewDefIFace {
    private static final Logger log = Logger.getLogger(SpUIViewDef.class);
    protected Integer spUIViewDefId;
    protected String typeName;
    protected String name;
    protected String dataClassName;
    protected String gettableName;
    protected String settableName;
    protected String description;
    protected String enableRulesXML;
    protected String colDef;
    protected String rowDef;
    protected Boolean isAbsoluteLayout;
    protected String definitionName;
    protected String resourceLabels;
    protected Set<SpUIRow> spRows;
    protected Set<SpUIColumn> spCols;
    protected Set<SpUIAltView> spAltViews;
    protected SpUIViewSet spViewSet;
    protected Short xCoordDB;
    protected Short yCoordDB;
    protected Short heightDB;
    protected Short widthDB;
    protected DataObjectGettable gettable = null;
    protected DataObjectSettable settable = null;
    protected Vector<FormColumnIFace> columns = null;
    protected Hashtable<String, String> enableRules;
    protected Vector<FormRowIFace> rows = null;
    protected Boolean isRowDefAuto = null;
    protected String rowDefSep;
    protected String rowDefCell;

    @Id
    @GeneratedValue
    @Column(name="SpUIViewID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpUIViewDefId() {
        return this.spUIViewDefId;
    }

    @Override
    @Transient
    public void initialize() {
        super.init();
        this.spUIViewDefId = null;
        this.typeName = null;
        this.name = null;
        this.dataClassName = null;
        this.gettableName = null;
        this.settableName = null;
        this.description = null;
        this.enableRulesXML = null;
        this.colDef = null;
        this.rowDef = null;
        this.isAbsoluteLayout = false;
        this.definitionName = null;
        this.resourceLabels = null;
        this.xCoordDB = null;
        this.yCoordDB = null;
        this.widthDB = null;
        this.heightDB = null;
        this.spRows = new HashSet<SpUIRow>();
        this.spCols = new HashSet<SpUIColumn>();
        this.spAltViews = new HashSet<SpUIAltView>();
        this.spViewSet = null;
        this.isRowDefAuto = null;
        this.rowDefCell = null;
        this.rowDefSep = null;
    }

    @Column(name="ColDef", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getColDef() {
        return this.colDef;
    }

    public void setColDef(String colDef) {
        this.colDef = colDef;
    }

    @Column(name="DataClassName", unique=false, nullable=false, insertable=true, updatable=true, length=128)
    public String getDataClassName() {
        return this.dataClassName;
    }

    public void setDataClassName(String dataClassName) {
        this.dataClassName = dataClassName;
    }

    @Lob
    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Lob
    @Column(name="EnableRulesXML", unique=false, nullable=true, insertable=true, updatable=true, length=4098)
    public String getEnableRulesXML() {
        return this.enableRulesXML;
    }

    public void setEnableRulesXML(String enableRulesXML) {
        this.enableRulesXML = enableRulesXML;
        this.enableRules = null;
    }

    @Column(name="GettableName", unique=false, nullable=false, insertable=true, updatable=true, length=128)
    public String getGettableName() {
        return this.gettableName;
    }

    public void setGettableName(String gettableName) {
        this.gettableName = gettableName;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="RowDef", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getRowDef() {
        return this.rowDef;
    }

    @Override
    public void setRowDef(String rowDef) {
        this.rowDef = rowDef;
    }

    @Column(name="SettableName", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getSettableName() {
        return this.settableName;
    }

    public void setSettableName(String settableName) {
        this.settableName = settableName;
    }

    public void setSpUIViewDefId(Integer spUIViewDefId) {
        this.spUIViewDefId = spUIViewDefId;
    }

    @Override
    @Column(name="ResourceLabels", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getResourceLabels() {
        return this.resourceLabels;
    }

    public void setResourceLabels(String resourceLabels) {
        this.resourceLabels = resourceLabels;
    }

    @Column(name="Type", unique=false, nullable=false, insertable=true, updatable=true, length=16)
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String type) {
        this.typeName = type;
    }

    @Column(name="IsAbsoluteLayout", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsAbsoluteLayout() {
        return this.isAbsoluteLayout == null ? false : this.isAbsoluteLayout;
    }

    public void setIsAbsoluteLayout(Boolean isAbsoluteLayout) {
        this.isAbsoluteLayout = isAbsoluteLayout;
    }

    @Override
    @Column(name="DefinitionName", unique=false, nullable=true, insertable=true, updatable=true)
    public String getDefinitionName() {
        return this.definitionName;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spViewDef")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpUIRow> getSpRows() {
        return this.spRows;
    }

    public void setSpRows(Set<SpUIRow> spRows) {
        this.spRows = spRows;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spViewDef")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpUIColumn> getSpCols() {
        return this.spCols;
    }

    public void setSpCols(Set<SpUIColumn> spCols) {
        this.spCols = spCols;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spViewDef")
    public Set<SpUIAltView> getSpAltViews() {
        return this.spAltViews;
    }

    public void setSpAltViews(Set<SpUIAltView> spAltViews) {
        this.spAltViews = spAltViews;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpUIViewSetID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpUIViewSet getSpViewSet() {
        return this.spViewSet;
    }

    public void setSpViewSet(SpUIViewSet spViewSet) {
        this.spViewSet = spViewSet;
    }

    @Column(name="XCoord", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getXCoordDB() {
        return this.xCoordDB;
    }

    public void setXCoordDB(Short coordDB) {
        this.xCoordDB = coordDB;
    }

    @Column(name="YCoord", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getYCoordDB() {
        return this.yCoordDB;
    }

    public void setYCoordDB(Short coordDB) {
        this.yCoordDB = coordDB;
    }

    @Column(name="Height", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getHeightDB() {
        return this.heightDB;
    }

    public void setHeightDB(Short height) {
        this.heightDB = height;
    }

    @Column(name="Width", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getWidthDB() {
        return this.widthDB;
    }

    public void setWidthDB(Short width) {
        this.widthDB = width;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpUIViewDef.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spUIViewDefId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpUIViewDef.getClassTableId();
    }

    public static int getClassTableId() {
        return 508;
    }

    @Override
    public boolean isUseResourceLabels() {
        return StringUtils.isNotEmpty((String)this.resourceLabels) && this.resourceLabels.equals("true");
    }

    @Override
    public void cleanUp() {
    }

    @Override
    @Transient
    public String getClassName() {
        return this.dataClassName;
    }

    @Override
    @Transient
    public DataObjectGettable getDataGettable() {
        if (this.gettable == null && StringUtils.isNotEmpty((String)this.gettableName)) {
            try {
                Class<?> cls = Class.forName(this.gettableName);
                this.gettable = (DataObjectGettable)cls.newInstance();
                return this.gettable;
            }
            catch (ClassNotFoundException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpUIViewDef.class, ex);
                log.error((Object)ex);
            }
            catch (InstantiationException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpUIViewDef.class, ex);
                log.error((Object)ex);
            }
            catch (IllegalAccessException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpUIViewDef.class, ex);
                log.error((Object)ex);
            }
        }
        return null;
    }

    @Override
    @Transient
    public String getDataGettableName() {
        return this.gettableName;
    }

    @Override
    @Transient
    public DataObjectSettable getDataSettable() {
        if (this.settable == null && StringUtils.isNotEmpty((String)this.settableName)) {
            try {
                Class<?> cls = Class.forName(this.settableName);
                this.settable = (DataObjectSettable)cls.newInstance();
                return this.settable;
            }
            catch (ClassNotFoundException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpUIViewDef.class, ex);
                log.error((Object)ex);
            }
            catch (InstantiationException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpUIViewDef.class, ex);
                log.error((Object)ex);
            }
            catch (IllegalAccessException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpUIViewDef.class, ex);
                log.error((Object)ex);
            }
        }
        return null;
    }

    @Override
    @Transient
    public String getDesc() {
        return this.description;
    }

    @Override
    @Transient
    public ViewDefIFace.ViewType getType() {
        return ViewDefIFace.ViewType.valueOf(this.typeName);
    }

    @Override
    public void setType(ViewDefIFace.ViewType type) {
        this.typeName = type.name();
    }

    @Override
    @Transient
    public Class<?> getDerivedInterface() {
        return null;
    }

    @Override
    public FormColumnIFace addColumn(FormColumnIFace column) {
        if (this.columns == null) {
            this.columns = new Vector();
        }
        return null;
    }

    @Override
    @Transient
    public List<FormColumnIFace> getColumns() {
        return this.columns;
    }

    public FormRowIFace addSpRow(SpUIRow row) {
        this.spRows.add(row);
        row.setSpViewDef(this);
        return row;
    }

    @Override
    public FormRowIFace addRow(FormRowIFace row) {
        if (row instanceof SpUIRow) {
            this.addSpRow((SpUIRow)row);
        }
        if (this.rows == null) {
            this.rows = new Vector();
        }
        this.rows.add(row);
        return row;
    }

    @Override
    @Transient
    public String getColumnDef() {
        return this.colDef;
    }

    @Override
    @Transient
    public Hashtable<String, String> getEnableRules() {
        if (this.enableRules == null && StringUtils.isNotEmpty((String)this.enableRulesXML)) {
            try {
                Element element = XMLHelper.readStrToDOM4J(this.enableRulesXML);
                if (element != null) {
                    this.enableRules = ViewLoader.getEnableRules(element);
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpUIViewDef.class, ex);
                log.error((Object)ex);
            }
        }
        return this.enableRules;
    }

    @Override
    @Transient
    public FormCellIFace getFormCellById(String idStr) {
        for (FormRowIFace formRowIFace : this.spRows) {
            for (FormCellIFace c : formRowIFace.getCells()) {
                if (!c.getIdent().equals(idStr)) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    @Transient
    public FormCellIFace getFormCellByName(String nameStr) {
        for (FormRowIFace formRowIFace : this.spRows) {
            for (FormCellIFace c : formRowIFace.getCells()) {
                if (!c.getName().equals(nameStr)) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    @Transient
    public Vector<FormRowIFace> getRows() {
        return new Vector<FormRowIFace>(this.spRows);
    }

    @Override
    @Transient
    public void setColumnDef(String columnDef) {
        this.colDef = columnDef;
    }

    @Override
    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    @Override
    public void setEnableRules(Hashtable<String, String> enableRules) {
        this.enableRules = enableRules;
    }

    @Override
    @Transient
    public Boolean isAbsoluteLayout() {
        return this.getIsAbsoluteLayout();
    }

    @Override
    @Transient
    public int getXCoord() {
        return this.xCoordDB.shortValue();
    }

    @Override
    @Transient
    public int getYCoord() {
        return this.yCoordDB.shortValue();
    }

    @Override
    public void setXCoord(int xCoord) {
        this.xCoordDB = (short)xCoord;
    }

    @Override
    public void setYCoord(int yCoord) {
        this.yCoordDB = (short)yCoord;
    }

    @Override
    @Transient
    public int getHeight() {
        return this.heightDB.shortValue();
    }

    @Override
    @Transient
    public int getWidth() {
        return this.widthDB.shortValue();
    }

    @Override
    public void setHeight(int height) {
        this.heightDB = (short)height;
    }

    @Override
    public void setWidth(int width) {
        this.widthDB = (short)width;
    }

    @Override
    public String getDataSettableName() {
        return this.settableName;
    }

    @Override
    public void setDataGettableName(String dataGettableName) {
        this.gettableName = dataGettableName;
    }

    @Override
    public void setDataSettableName(String dataSettableName) {
        this.settableName = dataSettableName;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Override
    public int compareTo(ViewDefIFace obj) {
        return this.name != null && obj != null && obj.getName() != null ? this.name.compareTo(obj.getName()) : 0;
    }

    protected String createEnableRulesXML(Hashtable<String, String> enableRulesArg) {
        if (enableRulesArg.keySet().size() > 0) {
            StringBuilder sb = new StringBuilder("<enableRules>");
            for (String key : enableRulesArg.keySet()) {
                sb.append("<rule id=\"");
                sb.append(key);
                sb.append("\"><![CDATA[");
                sb.append(enableRulesArg.get(key));
                sb.append("]]></rule>");
            }
            sb.append("</enableRules>");
            return sb.toString();
        }
        return null;
    }

    public void copyInto(ViewDefIFace vd) {
        this.typeName = vd.getType().toString();
        this.name = vd.getName();
        this.dataClassName = vd.getClassName();
        this.gettableName = vd.getDataGettableName();
        this.settableName = vd.getDataSettableName();
        this.description = vd.getDesc();
        if (vd instanceof FormViewDefIFace) {
            FormViewDefIFace fvd = (FormViewDefIFace)vd;
            this.enableRulesXML = this.createEnableRulesXML(fvd.getEnableRules());
            this.definitionName = fvd.getDefinitionName();
            this.colDef = fvd.getColumnDef();
            this.rowDef = fvd.getRowDef();
        }
        this.isAbsoluteLayout = vd.isAbsoluteLayout();
        this.xCoordDB = (short)vd.getXCoord();
        this.yCoordDB = (short)vd.getYCoord();
        this.heightDB = (short)vd.getHeight();
        this.widthDB = (short)vd.getWidth();
        this.gettable = vd.getDataGettable();
        this.settable = vd.getDataSettable();
    }

    @Transient
    public Boolean getIsRowDefAuto() {
        return this.isRowDefAuto;
    }

    public void setIsRowDefAuto(Boolean isRowDefAuto) {
        this.isRowDefAuto = isRowDefAuto;
    }

    @Transient
    public String getRowDefSep() {
        return this.rowDefSep;
    }

    public void setRowDefSep(String rowDefSep) {
        this.rowDefSep = rowDefSep;
    }

    @Transient
    public String getRowDefCell() {
        return this.rowDefCell;
    }

    public void setRowDefCell(String rowDefCol) {
        this.rowDefCell = rowDefCol;
    }

    public void createAutoRowDef(String cell, String sep) {
        this.isRowDefAuto = true;
        this.rowDefCell = cell;
        this.rowDefSep = sep;
    }

    @Override
    public void toXML(StringBuilder sb) {
        int indent = 8;
        XMLHelper.indent(sb, indent);
        sb.append("<viewdef");
        XMLHelper.xmlAttr(sb, "type", this.typeName.toString());
        XMLHelper.xmlAttr(sb, "name", this.name);
        XMLHelper.xmlAttr(sb, "class", this.dataClassName);
        XMLHelper.xmlAttr(sb, "gettable", this.gettableName);
        XMLHelper.xmlAttr(sb, "settable", this.settableName);
        XMLHelper.xmlAttr(sb, "width", this.widthDB);
        XMLHelper.xmlAttr(sb, "height", this.heightDB);
        sb.append(">\n");
        XMLHelper.indent(sb, indent += 4);
        XMLHelper.xmlNode(sb, "desc", this.description, true);
        XMLHelper.indent(sb, indent);
        XMLHelper.xmlNode(sb, "columnDef", this.colDef, false);
        if (this.isRowDefAuto == null || !this.isRowDefAuto.booleanValue()) {
            XMLHelper.indent(sb, indent);
            XMLHelper.xmlNode(sb, "rowDef", this.rowDef, false);
        } else {
            XMLHelper.indent(sb, indent);
            sb.append("<rowDef");
            XMLHelper.xmlAttr(sb, "auto", true);
            XMLHelper.xmlAttr(sb, "sep", this.rowDefSep);
            XMLHelper.xmlAttr(sb, "cell", this.rowDefCell);
            sb.append("/>\n");
        }
        XMLHelper.indent(sb, indent);
        sb.append("<rows>\n");
        for (FormRowIFace row : this.rows) {
            row.toXML(sb);
        }
        XMLHelper.indent(sb, indent);
        sb.append("</rows>\n");
        XMLHelper.indent(sb, indent -= 4);
        sb.append("</viewdef>\n\n");
    }
}

