/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpUIAltView;
import edu.ku.brc.specify.datamodel.SpUIViewSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spuiview")
@Table(appliesTo="spuiview", indexes={@Index(name="SpUIViewNameIDX", columnNames={"Name"})})
public class SpUIView
extends DataModelObjBase
implements ViewIFace {
    private static final Logger log = Logger.getLogger(SpUIView.class);
    protected Integer spUIViewId;
    protected String name;
    protected String javaClassName;
    protected String businessRulesClassName;
    protected Boolean useResourceLabels;
    protected String description;
    protected String selectorName;
    protected String objTitle;
    protected String defaultModeName;
    protected Boolean useDefaultBusRule;
    protected Boolean isInternal;
    protected String title;
    protected SpUIViewSet spViewSet;
    protected Set<SpUIAltView> spAltViews;
    protected AltViewIFace.CreationMode defaultMode = null;
    protected Boolean isSpecial = null;
    protected String viewSetName = null;

    public SpUIView() {
    }

    public SpUIView(String viewSetName, String name, String objTitle, String className, String businessRulesClassName, Boolean useDefaultBusRule, String desc) {
        this.viewSetName = viewSetName;
        this.name = name;
        this.objTitle = objTitle;
        this.javaClassName = className;
        this.businessRulesClassName = businessRulesClassName;
        this.description = desc;
        this.useDefaultBusRule = useDefaultBusRule;
        this.spUIViewId = null;
        this.selectorName = null;
        this.defaultModeName = null;
        this.spAltViews = new HashSet<SpUIAltView>();
        this.spViewSet = null;
    }

    @Override
    public void initialize() {
        super.init();
        this.spUIViewId = null;
        this.name = null;
        this.javaClassName = null;
        this.businessRulesClassName = null;
        this.useResourceLabels = null;
        this.description = null;
        this.selectorName = null;
        this.objTitle = null;
        this.defaultModeName = null;
        this.useDefaultBusRule = true;
        this.isInternal = true;
        this.title = null;
        this.spAltViews = new HashSet<SpUIAltView>();
        this.spViewSet = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpUIViewID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpUIViewId() {
        return this.spUIViewId;
    }

    @Override
    @Column(name="BusRulesClassName", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getBusinessRulesClassName() {
        return this.businessRulesClassName;
    }

    public void setSpUIViewId(Integer spUIViewId) {
        this.spUIViewId = spUIViewId;
    }

    @Override
    public void setBusinessRulesClassName(String businessRulesClassName) {
        this.businessRulesClassName = businessRulesClassName;
    }

    @Lob
    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=4098)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="HasResourceLabels", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getHasResourceLabels() {
        return this.useResourceLabels;
    }

    public void setHasResourceLabels(Boolean hasResourceLabels) {
        this.useResourceLabels = hasResourceLabels;
    }

    @Column(name="JavaClassName", unique=false, nullable=false, insertable=true, updatable=true, length=128)
    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    @Column(name="ObjTitle", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getObjTitle() {
        return this.objTitle;
    }

    public void setObjTitle(String objTitle) {
        this.objTitle = objTitle;
    }

    @Override
    @Column(name="Title", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Column(name="SelectorName", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getSelectorName() {
        return this.selectorName;
    }

    @Override
    public void setSelectorName(String selectorName) {
        this.selectorName = selectorName;
    }

    @Column(name="DefaultModeName", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getDefaultModeName() {
        return this.defaultModeName;
    }

    public void setDefaultModeName(String defaultModeName) {
        this.defaultModeName = defaultModeName;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="UseDefaultBusRule", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getUseDefaultBusRule() {
        return this.useDefaultBusRule;
    }

    public void setUseDefaultBusRule(Boolean useDefaultBusRule) {
        this.useDefaultBusRule = useDefaultBusRule;
    }

    @Column(name="IsInternal", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsInternal() {
        return this.isInternal;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal != null ? this.isInternal : false;
    }

    public void setIsInternal(Boolean isInternal) {
        this.isInternal = isInternal;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spView")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpUIAltView> getSpAltViews() {
        return this.spAltViews;
    }

    public void setSpAltViews(Set<SpUIAltView> altViews) {
        this.spAltViews = altViews;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpUIViewSetID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpUIViewSet getSpViewSet() {
        return this.spViewSet;
    }

    public void setSpViewSet(SpUIViewSet spViewSet) {
        this.spViewSet = spViewSet;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpUIView.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spUIViewId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpUIView.getClassTableId();
    }

    public static int getClassTableId() {
        return 506;
    }

    @Override
    public boolean useDefaultBusinessRules() {
        return this.useDefaultBusRule != null && this.useDefaultBusRule != false;
    }

    @Override
    public AltViewIFace addAltView(AltViewIFace altView) {
        if (altView instanceof SpUIAltView) {
            SpUIAltView spav = (SpUIAltView)altView;
            this.spAltViews.add(spav);
            spav.setSpView(this);
        } else {
            log.error((Object)"Attempting to add an AltViewIFace that isn't a SpUIAltView");
        }
        return null;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    @Transient
    public AltViewIFace getAltView(String nameStr) {
        if (nameStr == null) {
            return this.getDefaultAltView();
        }
        for (SpUIAltView av : this.spAltViews) {
            if (!av.getName().equals(nameStr)) continue;
            return av;
        }
        return null;
    }

    @Override
    @Transient
    public List<AltViewIFace> getAltViews() {
        return new Vector<AltViewIFace>(this.spAltViews);
    }

    @Override
    @Transient
    public BusinessRulesIFace createBusinessRule() {
        BusinessRulesIFace businessRule = null;
        if (StringUtils.isNotEmpty((String)this.businessRulesClassName)) {
            if (StringUtils.isNotEmpty((String)this.businessRulesClassName)) {
                try {
                    businessRule = (BusinessRulesIFace)Class.forName(this.businessRulesClassName).newInstance();
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpUIView.class, e);
                    InternalError error = new InternalError("Can't instantiate BusinessRulesIFace [" + this.businessRulesClassName + "]");
                    error.initCause(e);
                    throw error;
                }
            } else if (this.useDefaultBusRule.booleanValue()) {
                businessRule = DBTableIdMgr.getInstance().getBusinessRule(this.javaClassName);
            }
        }
        return businessRule;
    }

    @Override
    @Transient
    public String getClassName() {
        return this.javaClassName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transient
    public AltViewIFace getDefaultAltView(AltViewIFace.CreationMode creationMode, String altViewType) {
        if (creationMode != null && StringUtils.isNotEmpty((String)altViewType)) {
            void var3_4;
            Object var3_3 = null;
            boolean isForm = altViewType.equals("form");
            for (AltViewIFace altViewIFace : this.spAltViews) {
                ViewDefIFace.ViewType type = altViewIFace.getViewDef().getType();
                if ((isForm && type == ViewDefIFace.ViewType.form || !isForm && type != ViewDefIFace.ViewType.form) && altViewIFace.getMode() == creationMode) {
                    return altViewIFace;
                }
                if (!altViewIFace.isDefault()) continue;
                AltViewIFace altViewIFace2 = altViewIFace;
            }
            if (var3_4 != null) {
                return var3_4;
            }
        } else {
            for (AltViewIFace altViewIFace : this.spAltViews) {
                if (!altViewIFace.isDefault()) continue;
                return altViewIFace;
            }
        }
        throw new RuntimeException("No default Alt View in View[" + this.name + "]");
    }

    @Override
    @Transient
    public AltViewIFace getDefaultAltView() {
        return this.getDefaultAltView(null, null);
    }

    @Override
    @Transient
    public AltViewIFace getDefaultAltViewWithMode(AltViewIFace.CreationMode creationMode, String defAltViewType) {
        AltViewIFace defAltView = this.getDefaultAltView(creationMode, defAltViewType);
        if (defAltView.getMode() == creationMode || this.spAltViews.size() == 1) {
            return defAltView;
        }
        for (AltViewIFace altViewIFace : this.spAltViews) {
            if (altViewIFace.isDefault() || !altViewIFace.getViewDefName().equals(defAltView.getViewDefName())) continue;
            return altViewIFace;
        }
        return defAltView;
    }

    @Override
    @Transient
    public AltViewIFace.CreationMode getDefaultMode() {
        if (this.defaultMode == null) {
            this.defaultMode = SpUIView.getCreationModeFromStr(this.defaultModeName);
        }
        return this.defaultMode;
    }

    public static AltViewIFace.CreationMode getCreationModeFromStr(String creationModeStr) {
        AltViewIFace.CreationMode mode = StringUtils.isNotEmpty((String)creationModeStr) ? (creationModeStr.equals("view") ? AltViewIFace.CreationMode.VIEW : (creationModeStr.equals("edit") ? AltViewIFace.CreationMode.EDIT : (creationModeStr.equals("search") ? AltViewIFace.CreationMode.SEARCH : AltViewIFace.CreationMode.NONE))) : AltViewIFace.CreationMode.VIEW;
        return mode;
    }

    public static String getCreationModeStrFrom(AltViewIFace.CreationMode creationMode) {
        switch (creationMode) {
            case NONE: {
                return "none";
            }
            case EDIT: {
                return "edit";
            }
            case VIEW: {
                return "view";
            }
            case SEARCH: {
                return "search";
            }
        }
        return null;
    }

    @Override
    @Transient
    public String getDesc() {
        return this.description;
    }

    @Override
    @Transient
    public String getViewSetName() {
        return this.spViewSet.getName();
    }

    @Override
    @Transient
    public boolean isSpecialViewAndEdit() {
        if (this.isSpecial == null) {
            if (this.spAltViews.size() == 2) {
                ArrayList<SpUIAltView> list = new ArrayList<SpUIAltView>(this.spAltViews);
                AltViewIFace av0 = list.get(0);
                AltViewIFace av1 = list.get(1);
                this.isSpecial = av0.getViewDefName().equals(av1.getViewDefName());
            } else {
                this.isSpecial = false;
            }
        }
        return this.isSpecial;
    }

    @Transient
    public boolean isUseResourceLabels() {
        return this.useResourceLabels;
    }

    @Override
    public void setDefaultMode(AltViewIFace.CreationMode defaultMode) {
        this.defaultMode = defaultMode;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Override
    public int compareTo(ViewIFace obj) {
        return this.name != null && obj != null && obj.getName() != null ? this.name.compareTo(obj.getName()) : 0;
    }

    public void copyInto(ViewIFace view) {
        this.name = view.getName();
        this.javaClassName = view.getClassName();
        this.businessRulesClassName = view.getBusinessRulesClassName();
        this.description = view.getDesc();
        this.selectorName = view.getSelectorName();
        this.objTitle = view.getObjTitle();
        this.defaultModeName = view.getDefaultMode().toString().toLowerCase();
        this.useDefaultBusRule = view.useDefaultBusinessRules();
        this.defaultMode = view.getDefaultMode();
        this.isSpecial = view.isSpecialViewAndEdit();
        this.viewSetName = view.getViewSetName();
    }

    @Override
    public void toXML(StringBuilder sb) {
        int indent = 8;
        XMLHelper.indent(sb, indent);
        sb.append("<view");
        XMLHelper.xmlAttr(sb, "name", this.name);
        XMLHelper.xmlAttr(sb, "class", this.javaClassName);
        if (!this.isInternal.booleanValue()) {
            XMLHelper.xmlAttr(sb, "isinternal", this.isInternal);
        }
        XMLHelper.xmlAttr(sb, "resourcelabels", this.useResourceLabels);
        sb.append(">\n");
        XMLHelper.xmlNode(sb, "desc", this.description, true);
        XMLHelper.indent(sb, indent += 4);
        sb.append("<altviews");
        if (this.defaultMode != null) {
            XMLHelper.xmlAttr(sb, "defaultmode", this.defaultMode.toString().toLowerCase());
        }
        XMLHelper.xmlAttr(sb, "selector", this.selectorName);
        sb.append(">\n");
        for (AltViewIFace altViewIFace : this.spAltViews) {
            altViewIFace.toXML(sb);
        }
        XMLHelper.indent(sb, indent);
        sb.append("</altviews>\n");
        XMLHelper.indent(sb, indent -= 4);
        sb.append("</view>\n\n");
    }
}

