/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormRowIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.SpUICell;
import edu.ku.brc.specify.datamodel.SpUIViewDef;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spuirow")
@Table(appliesTo="spuirow", indexes={@Index(name="SpUIRowRowNumIDX", columnNames={"RowNum"})})
public class SpUIRow
implements Serializable,
FormRowIFace,
Comparable<SpUIRow> {
    protected Integer spUIRowId;
    protected Short rowNum;
    protected Set<SpUICell> spCells;
    protected SpUIViewDef spViewDef;
    protected Vector<FormCellIFace> cells;

    @Id
    @GeneratedValue
    @Column(name="SpUIRowID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpUIRowId() {
        return this.spUIRowId;
    }

    public void initialize() {
        this.spUIRowId = null;
        this.rowNum = null;
        this.spCells = new HashSet<SpUICell>();
        this.spViewDef = null;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spRow")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpUICell> getSpCells() {
        return this.spCells;
    }

    public void setSpCells(Set<SpUICell> spCells) {
        this.spCells = spCells;
    }

    @Column(name="RowNum", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(Short rowNum) {
        this.rowNum = rowNum;
    }

    @Override
    public void setRowNumber(byte num) {
        this.rowNum = num;
    }

    public void setSpUIRowId(Integer spUIRowId) {
        this.spUIRowId = spUIRowId;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpUIAltViewID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpUIViewDef getSpViewDef() {
        return this.spViewDef;
    }

    public void setSpViewDef(SpUIViewDef viewDef) {
        this.spViewDef = viewDef;
    }

    @Transient
    public Class<?> getDataClass() {
        return SpUIRow.class;
    }

    @Transient
    public int getTableId() {
        return SpUIRow.getClassTableId();
    }

    public static int getClassTableId() {
        return 510;
    }

    public FormCellIFace addSpCell(SpUICell cell) {
        cell.setSpRow(this);
        this.spCells.add(cell);
        return cell;
    }

    @Override
    public FormCellIFace addCell(FormCellIFace cell) {
        if (this.cells == null) {
            this.cells = new Vector();
        }
        this.cells.add(cell);
        if (cell instanceof SpUICell) {
            this.addSpCell((SpUICell)cell);
        }
        return cell;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public Vector<FormCellIFace> getCells() {
        return this.cells;
    }

    @Override
    public void setCells(Vector<FormCellIFace> cells) {
        this.cells = cells;
    }

    @Override
    public int compareTo(SpUIRow row) {
        return this.rowNum != null && row != null && row.rowNum != null ? this.rowNum.compareTo(row.rowNum) : 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpUIRow obj = (SpUIRow)super.clone();
        obj.cells = new Vector();
        obj.spCells = new HashSet<SpUICell>();
        for (SpUICell cell : this.spCells) {
            SpUICell newFC = (SpUICell)cell.clone();
            obj.cells.add(newFC);
            obj.spCells.add(newFC);
            newFC.setSpRow(obj);
        }
        return obj;
    }

    @Override
    public void toXML(StringBuilder sb) {
        if (this.cells != null && this.cells.size() > 0) {
            int ident = 16;
            XMLHelper.indent(sb, ident);
            sb.append("<row>\n");
            for (FormCellIFace cell : this.cells) {
                cell.toXML(sb);
            }
            XMLHelper.indent(sb, ident);
            sb.append("</row>\n");
        }
    }
}

