/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpUIView;
import edu.ku.brc.specify.datamodel.SpUIViewDef;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spuialtview")
@Table(appliesTo="spuialtview", indexes={@Index(name="SpUIAltViewNameIDX", columnNames={"Name"})})
public class SpUIAltView
extends DataModelObjBase
implements AltViewIFace {
    private static final Logger log = Logger.getLogger(SpUIAltView.class);
    protected Integer spUIAltViewId;
    protected String name;
    protected String title;
    protected String modeName;
    protected Boolean isValidated;
    protected Boolean isDefaultAltView;
    protected String selectorValue;
    protected String selectorName;
    protected SpUIViewDef spViewDef;
    protected SpUIView spView;
    protected List<AltViewIFace> subViews = null;

    public SpUIAltView() {
    }

    public SpUIAltView(ViewIFace view, String name, String title, AltViewIFace.CreationMode mode, boolean validated, boolean isDefault, ViewDefIFace viewDef) {
        this.spView = (SpUIView)view;
        this.name = name;
        this.title = title;
        this.modeName = SpUIView.getCreationModeStrFrom(mode);
        this.isValidated = validated;
        this.isDefaultAltView = isDefault;
        this.spViewDef = (SpUIViewDef)viewDef;
        this.selectorValue = null;
        this.selectorName = null;
    }

    @Override
    public void initialize() {
        super.init();
        this.spUIAltViewId = null;
        this.name = null;
        this.title = null;
        this.modeName = null;
        this.isValidated = null;
        this.isDefaultAltView = null;
        this.spViewDef = null;
        this.spView = null;
        this.selectorValue = null;
        this.selectorName = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpUIAltViewID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpUIAltViewId() {
        return this.spUIAltViewId;
    }

    @Column(name="IsDefaultAltView", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsDefaultAltView() {
        return this.isDefaultAltView;
    }

    public void setIsDefaultAltView(Boolean defaultAltView) {
        this.isDefaultAltView = defaultAltView;
    }

    @Override
    @Column(name="Title", unique=false, nullable=false, insertable=true, updatable=true, length=32)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="ModeName", unique=false, nullable=false, insertable=true, updatable=true, length=16)
    public String getModeName() {
        return this.modeName;
    }

    public void setModeName(String modeName) {
        this.modeName = modeName;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setSpUIAltViewId(Integer spUIAltViewId) {
        this.spUIAltViewId = spUIAltViewId;
    }

    @Column(name="IsValidated", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsValidated() {
        return this.isValidated;
    }

    public void setIsValidated(Boolean isValidated) {
        this.isValidated = isValidated;
    }

    @Override
    @Column(name="SelectorValue", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSelectorValue() {
        return null;
    }

    @Override
    @Column(name="SelectorName", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSelectorName() {
        return this.selectorName;
    }

    @Override
    public void setSelectorName(String selectorName) {
        this.selectorName = selectorName;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpUIAltViewForViewDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpUIViewDef getSpViewDef() {
        return this.spViewDef;
    }

    public void setSpViewDef(SpUIViewDef viewDef) {
        this.spViewDef = viewDef;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpUIAltViewForViewID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpUIView getSpView() {
        return this.spView;
    }

    public void setSpView(SpUIView spView) {
        this.spView = spView;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpUIAltView.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spUIAltViewId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpUIAltView.getClassTableId();
    }

    public static int getClassTableId() {
        return 507;
    }

    @Override
    public int compareTo(AltViewIFace obj) {
        return this.name != null && obj != null && obj.getName() != null ? this.name.compareTo(obj.getName()) : 0;
    }

    @Override
    @Transient
    public AltViewIFace.CreationMode getMode() {
        return SpUIView.getCreationModeFromStr(this.modeName);
    }

    @Override
    @Transient
    public List<AltViewIFace> getSubViews() {
        return this.subViews;
    }

    @Override
    public void setSubViews(List<AltViewIFace> subViews) {
        this.subViews = subViews;
    }

    @Override
    @Transient
    public String getViewDefName() {
        return this.spViewDef.getName();
    }

    @Override
    @Transient
    public boolean isDefault() {
        return this.isDefaultAltView == null ? false : this.isDefaultAltView;
    }

    @Override
    @Transient
    public boolean isValidated() {
        return this.isValidated == null ? false : this.isValidated;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.isDefaultAltView = isDefault;
    }

    @Override
    public void setMode(AltViewIFace.CreationMode mode) {
        this.modeName = SpUIView.getCreationModeStrFrom(mode);
    }

    @Override
    public void setSelectorValue(String selectorValue) {
        this.selectorValue = selectorValue;
    }

    @Override
    public void setViewDef(ViewDefIFace viewDef) {
        if (viewDef instanceof SpUIViewDef) {
            this.spViewDef = (SpUIViewDef)viewDef;
        } else {
            log.error((Object)"Attempting to add a ViewDefIFace that is not of class SpUIViewDef");
        }
    }

    @Override
    @Transient
    public ViewDefIFace getViewDef() {
        return this.spViewDef;
    }

    @Override
    @Transient
    public ViewIFace getView() {
        return this.spView;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public void copyInto(AltViewIFace altView) {
        this.name = altView.getName();
        this.title = altView.getTitle();
        this.modeName = altView.getMode().toString().toLowerCase();
        this.isValidated = altView.isValidated();
        this.isDefaultAltView = altView.isDefault();
        this.selectorName = altView.getSelectorName();
        this.selectorValue = altView.getSelectorValue();
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("                <altview");
        XMLHelper.xmlAttr(sb, "name", this.name);
        XMLHelper.xmlAttr(sb, "viewdef", this.spViewDef.getName());
        XMLHelper.xmlAttr(sb, "title", this.title);
        XMLHelper.xmlAttr(sb, "mode", this.modeName);
        XMLHelper.xmlAttr(sb, "default", this.isDefaultAltView);
        XMLHelper.xmlAttr(sb, "validated", this.isValidated);
        XMLHelper.xmlAttr(sb, "selector", this.selectorName);
        XMLHelper.xmlAttr(sb, "selector_value", this.selectorValue);
        sb.append("/>\n");
    }
}

