/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spreport")
@Table(appliesTo="spreport", indexes={@Index(name="SpReportNameIDX", columnNames={"Name"})})
public class SpReport
extends DataModelObjBase {
    private static final Logger log = Logger.getLogger(SpReport.class);
    protected Integer spReportId;
    protected String name;
    protected String remarks;
    protected SpQuery query;
    protected WorkbenchTemplate workbenchTemplate;
    protected SpAppResource appResource;
    protected SpecifyUser specifyUser;
    protected Integer repeatCount;
    protected String repeatField;

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void initialize() {
        super.init();
        this.spReportId = null;
        this.name = null;
        this.remarks = null;
        this.query = null;
        this.workbenchTemplate = null;
        this.appResource = null;
        this.specifyUser = null;
        this.repeatCount = null;
        this.repeatField = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpReportId", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpReportId() {
        return this.spReportId;
    }

    public void setSpReportId(Integer spReportId) {
        this.spReportId = spReportId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSpecifyUser(SpecifyUser owner) {
        this.specifyUser = owner;
    }

    protected void setQuery(SpQuery query) {
        if (this.workbenchTemplate != null) {
            this.workbenchTemplate = null;
            log.warn((Object)"Setting query for a report with a previously assigned workbenchTemplate. This is not supposed to happen.");
        }
        this.query = query;
    }

    public void setReportObject(DataModelObjBase repo) {
        if (repo instanceof SpQuery) {
            this.setQuery((SpQuery)repo);
        } else if (repo instanceof Workbench) {
            Workbench wb = (Workbench)repo;
            try {
                this.setWorkbenchTemplate((WorkbenchTemplate)wb.getWorkbenchTemplate().clone());
            }
            catch (CloneNotSupportedException cnsex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpReport.class, cnsex);
                cnsex.printStackTrace();
                throw new RuntimeException(cnsex);
            }
        } else {
            log.error((Object)("unable to set report object of class " + repo.getClass().getName()));
        }
    }

    public void setAppResource(SpAppResource appResource) {
        this.appResource = appResource;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Lob
    @Column(name="Remarks", unique=false, nullable=true, insertable=true, updatable=true, length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpQueryID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpQuery getQuery() {
        return this.query;
    }

    @OneToOne
    @Cascade(value={CascadeType.DELETE})
    @JoinColumn(name="WorkbenchTemplateID")
    public WorkbenchTemplate getWorkbenchTemplate() {
        return this.workbenchTemplate;
    }

    protected void setWorkbenchTemplate(WorkbenchTemplate workbenchTemplate) {
        this.workbenchTemplate = workbenchTemplate;
    }

    @Transient
    public DataModelObjBase getReportObject() {
        if (this.query != null) {
            return this.query;
        }
        return this.workbenchTemplate;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AppResourceID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpAppResource getAppResource() {
        return this.appResource;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpecifyUserID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpecifyUser getSpecifyUser() {
        return this.specifyUser;
    }

    @Column(name="RepeatCount", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    @Column(name="RepeatField", unique=false, nullable=true, insertable=true, updatable=true)
    public String getRepeatField() {
        return this.repeatField;
    }

    @Transient
    public Object getRepeats() {
        return this.repeatCount != null ? this.repeatCount : this.repeatField;
    }

    public void setRepeats(Object repeats) {
        if (repeats == null) {
            this.setRepeatCount(null);
            this.setRepeatField(null);
        } else if (repeats instanceof Integer) {
            this.setRepeatCount((Integer)repeats);
            this.setRepeatField(null);
        } else if (repeats instanceof String) {
            this.setRepeatCount(null);
            this.setRepeatField((String)repeats);
        } else {
            log.error((Object)("invalid repeats parameter: " + repeats));
            this.setRepeatCount(null);
            this.setRepeatField(null);
        }
    }

    public void setRepeatField(String repeatField) {
        this.repeatField = repeatField;
    }

    @Override
    public void forceLoad() {
        DataModelObjBase repObj = this.getReportObject();
        if (repObj != null) {
            repObj.forceLoad();
        }
        this.getAppResource();
        this.getSpecifyUser();
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpReport.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spReportId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpReport.getClassTableId();
    }

    public static int getClassTableId() {
        return 519;
    }

    public void toXML(StringBuilder sb) {
        sb.append("<report ");
        XMLHelper.addAttr(sb, "name", this.name);
        XMLHelper.addAttr(sb, "remarks", this.remarks);
        XMLHelper.addAttr(sb, "repeatCount", this.repeatCount);
        XMLHelper.addAttr(sb, "repeatField", this.repeatField);
        sb.append(">\r\n");
        if (this.query != null) {
            this.query.forceLoad();
            this.query.toXML(sb);
        } else if (this.workbenchTemplate != null) {
            this.workbenchTemplate.forceLoad();
            this.workbenchTemplate.toXML(sb);
        }
        sb.append("</report>\r\n");
    }

    public void fromXML(Element element, boolean alwaysMakeNew) {
        Element wbtNode;
        String repeatCountStr = XMLHelper.getAttr(element, "repeatCount", null);
        this.name = XMLHelper.getAttr(element, "name", null);
        this.remarks = XMLHelper.getAttr(element, "remarks", null);
        this.repeatCount = StringUtils.isBlank((String)repeatCountStr) ? null : Integer.valueOf(repeatCountStr);
        this.repeatField = XMLHelper.getAttr(element, "repeatField", null);
        if (StringUtils.isBlank((String)this.repeatField)) {
            this.repeatField = null;
        }
        this.query = null;
        this.workbenchTemplate = null;
        Element qryNode = element.element("query");
        if (qryNode != null) {
            SpQuery newQ = new SpQuery();
            newQ.initialize();
            newQ.fromXML(qryNode);
            newQ.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
            SpQuery spQuery = this.query = alwaysMakeNew ? newQ : this.determineQueryForImport(newQ);
            if (this.query.getId() == null) {
                this.query.setName(this.getUniqueNameForImportQuery(this.query.getName()));
            }
        }
        if ((wbtNode = element.element("workbenchtemplate")) != null) {
            WorkbenchTemplate newWbt = new WorkbenchTemplate();
            newWbt.initialize();
            newWbt.fromXML(wbtNode);
            newWbt.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
            this.workbenchTemplate = newWbt;
        }
    }

    protected SpQuery determineQueryForImport(SpQuery importedQ) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            List<SpQuery> matches = session.getDataList(SpQuery.class);
            for (SpQuery qObj : matches) {
                qObj.forceLoad();
                if (!qObj.isEquivalent(importedQ)) continue;
                SpQuery spQuery = qObj;
                return spQuery;
            }
            SpQuery spQuery = importedQ;
            return spQuery;
        }
        finally {
            session.close();
        }
    }

    protected String getUniqueNameForImportQuery(String qName) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            boolean done = false;
            String result = qName;
            Integer tries = 1;
            while (!done) {
                List<?> matches = session.getDataList("from SpQuery where name = '" + result + "'");
                if (matches.size() == 0) {
                    done = true;
                    continue;
                }
                Integer n = tries;
                tries = n + 1;
                result = String.valueOf(qName) + n;
            }
            String string = result;
            return string;
        }
        finally {
            session.close();
        }
    }
}

