/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpExportSchemaItemMapping;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.ui.UIRegistry;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="spqueryfield")
public class SpQueryField
extends DataModelObjBase
implements Comparable<SpQueryField>,
Cloneable {
    protected static final Logger log = Logger.getLogger(SpQueryField.class);
    public static final Byte SORT_NONE = 0;
    public static final Byte SORT_ASC = 1;
    public static final Byte SORT_DESC = 2;
    protected Integer spQueryFieldId;
    protected Short position;
    protected String fieldName;
    protected Boolean isNot;
    protected Boolean isDisplay;
    protected Boolean isPrompt;
    protected Boolean isRelFld;
    protected Boolean alwaysFilter;
    protected Boolean allowNulls;
    protected String stringId;
    protected Byte operStart;
    protected Byte operEnd;
    protected String startValue;
    protected String endValue;
    protected Byte sortType;
    protected String tableList;
    protected Set<SpExportSchemaItemMapping> mappings;
    protected Integer contextTableIdent;
    protected String columnAlias;
    protected String formatName;
    protected SpQuery query;

    public void setSpQueryFieldId(Integer spQueryFieldId) {
        this.spQueryFieldId = spQueryFieldId;
    }

    public void setPosition(Short position) {
        this.position = position;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setStringId(String stringId) {
        this.stringId = stringId;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public void setIsNot(Boolean isNot) {
        this.isNot = isNot;
    }

    public void setIsDisplay(Boolean isDisplay) {
        this.isDisplay = isDisplay;
    }

    public void setIsPrompt(Boolean isPrompt) {
        this.isPrompt = isPrompt;
    }

    public void setAlwaysFilter(Boolean alwaysFilter) {
        this.alwaysFilter = alwaysFilter;
    }

    public void setAllowNulls(Boolean allowNulls) {
        this.allowNulls = allowNulls;
    }

    public void setIsRelFld(Boolean isRelFld) {
        this.isRelFld = isRelFld;
    }

    public void setOperStart(Byte operStart) {
        this.operStart = operStart;
    }

    public void setOperEnd(Byte operEnd) {
        this.operEnd = operEnd;
    }

    public void setStartValue(String startValue) {
        this.startValue = startValue;
    }

    public void setEndValue(String endValue) {
        this.endValue = endValue;
    }

    public void setSortType(Byte sortType) {
        this.sortType = sortType;
    }

    public void setQuery(SpQuery query) {
        this.query = query;
    }

    public void setTableList(String tableList) {
        this.tableList = tableList;
    }

    @Id
    @GeneratedValue
    @Column(name="SpQueryFieldID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpQueryFieldId() {
        return this.spQueryFieldId;
    }

    @Column(name="Position", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getPosition() {
        return this.position;
    }

    @Column(name="FieldName", unique=false, nullable=false, insertable=true, updatable=true, length=32)
    public String getFieldName() {
        return this.fieldName;
    }

    @Column(name="StringId", unique=false, nullable=false, insertable=true, updatable=true, length=500)
    public String getStringId() {
        return this.stringId;
    }

    @Column(name="FormatName", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getFormatName() {
        return this.formatName;
    }

    @Column(name="IsNot", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsNot() {
        return this.isNot;
    }

    @Column(name="IsDisplay", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsDisplay() {
        return this.isDisplay;
    }

    @Column(name="IsPrompt", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsPrompt() {
        return this.isPrompt;
    }

    @Column(name="IsRelFld", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsRelFld() {
        return this.isRelFld;
    }

    @Column(name="AlwaysFilter", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getAlwaysFilter() {
        return this.alwaysFilter;
    }

    @Column(name="AllowNulls", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getAllowNulls() {
        return this.allowNulls;
    }

    @Column(name="OperStart", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getOperStart() {
        return this.operStart;
    }

    @Column(name="OperEnd", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getOperEnd() {
        return this.operEnd;
    }

    @Column(name="StartValue", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getStartValue() {
        return this.startValue;
    }

    @Column(name="EndValue", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getEndValue() {
        return this.endValue;
    }

    @Column(name="SortType", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getSortType() {
        return this.sortType;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpQueryID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpQuery getQuery() {
        return this.query;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="queryField")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<SpExportSchemaItemMapping> getMappings() {
        return this.mappings;
    }

    @Column(name="TableList", unique=false, nullable=false, insertable=true, updatable=true, length=500)
    public String getTableList() {
        return this.tableList;
    }

    public void setMapping(SpExportSchemaItemMapping mapping) {
        this.mappings.clear();
        if (mapping != null) {
            this.mappings.add(mapping);
        }
    }

    @Transient
    public SpExportSchemaItemMapping getMapping() {
        if (this.mappings.size() > 0) {
            if (this.mappings.size() > 1) {
                log.warn((Object)"getMappig() was called for object with more than one mapping.");
            }
            return this.mappings.iterator().next();
        }
        return null;
    }

    @Override
    public void initialize() {
        super.init();
        this.spQueryFieldId = null;
        this.position = null;
        this.fieldName = null;
        this.isNot = null;
        this.isDisplay = null;
        this.isPrompt = null;
        this.alwaysFilter = null;
        this.allowNulls = null;
        this.isRelFld = null;
        this.operStart = null;
        this.operEnd = null;
        this.startValue = null;
        this.endValue = null;
        this.sortType = null;
        this.query = null;
        this.tableList = null;
        this.stringId = null;
        this.formatName = null;
        this.columnAlias = null;
        this.contextTableIdent = null;
        this.mappings = new HashSet<SpExportSchemaItemMapping>();
    }

    @Transient
    public OperatorType getStartOperator() {
        return OperatorType.valueOf(this.operStart);
    }

    @Transient
    public OperatorType getEndOperator() {
        return OperatorType.valueOf(this.operEnd);
    }

    @Transient
    public SortType getSort() {
        return SortType.valueOf(this.sortType);
    }

    public void setStartOper(OperatorType oper) {
        this.operStart = oper.getOrdinal();
    }

    public void setEndOper(OperatorType oper) {
        this.operEnd = oper.getOrdinal();
    }

    public void setSort(SortType sortType) {
        this.sortType = sortType.getOrdinal();
    }

    public void setMappings(Set<SpExportSchemaItemMapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpQueryField.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spQueryFieldId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpQueryField.getClassTableId();
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public static int getClassTableId() {
        return 518;
    }

    @Override
    public int compareTo(SpQueryField o) {
        return this.position != null && o != null && o.position != null ? this.position.compareTo(o.position) : 0;
    }

    @Column(name="ContextTableIdent", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getContextTableIdent() {
        return this.contextTableIdent;
    }

    public void setContextTableIdent(Integer contextTableIdent) {
        this.contextTableIdent = contextTableIdent;
    }

    @Column(name="ColumnAlias", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getColumnAlias() {
        return this.columnAlias;
    }

    @Transient
    public String getColumnAliasTitle() {
        int nameIdx;
        DBFieldInfo fld;
        DBTableInfo tbl;
        if (this.columnAlias == null) {
            this.columnAlias = this.fieldName;
        }
        if ((tbl = DBTableIdMgr.getInstance().getInfoById(this.contextTableIdent)) != null && (fld = tbl.getFieldByName(this.fieldName)) != null && (nameIdx = this.columnAlias.lastIndexOf(fld.getName())) >= 0) {
            int nameEndIdx = nameIdx + fld.getName().length();
            return String.valueOf(this.columnAlias.substring(0, nameIdx)) + fld.getTitle() + this.columnAlias.substring(nameEndIdx);
        }
        log.error((Object)("Returning unprocessed columnAlias because FieldInfo was not found: " + this.columnAlias));
        return this.columnAlias;
    }

    public void setColumnAlias(String columnAlias) {
        this.columnAlias = columnAlias;
    }

    public void setColumnAliasTitle(String columnAliasTitle, boolean doNotReportError) {
        int nameIdx;
        DBFieldInfo fld;
        DBTableInfo tbl = DBTableIdMgr.getInstance().getInfoById(this.contextTableIdent);
        if (tbl != null && (fld = tbl.getFieldByName(this.fieldName)) != null && (nameIdx = columnAliasTitle.lastIndexOf(fld.getTitle())) >= 0) {
            int nameEndIdx = nameIdx + fld.getTitle().length();
            this.setColumnAlias(String.valueOf(columnAliasTitle.substring(0, nameIdx)) + fld.getName() + columnAliasTitle.substring(nameEndIdx));
            return;
        }
        if (!doNotReportError) {
            log.error((Object)("Setting unprocessed alias because FieldInfo was not found: " + columnAliasTitle));
        }
        this.setColumnAlias(columnAliasTitle);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpQueryField field = (SpQueryField)super.clone();
        return field;
    }

    public void toXML(StringBuilder sb) {
        sb.append("<field ");
        XMLHelper.addAttr(sb, "position", this.position);
        XMLHelper.addAttr(sb, "fieldName", this.fieldName);
        XMLHelper.addAttr(sb, "isNot", this.isNot);
        XMLHelper.addAttr(sb, "isDisplay", this.isDisplay);
        XMLHelper.addAttr(sb, "isPrompt", this.isPrompt);
        XMLHelper.addAttr(sb, "isRelFld", this.isRelFld);
        XMLHelper.addAttr(sb, "alwaysFilter", this.alwaysFilter);
        XMLHelper.addAttr(sb, "stringId", this.stringId);
        XMLHelper.addAttr(sb, "operStart", this.operStart);
        XMLHelper.addAttr(sb, "operEnd", this.operEnd);
        XMLHelper.addAttr(sb, "startValue", this.startValue);
        XMLHelper.addAttr(sb, "endValue", this.endValue);
        XMLHelper.addAttr(sb, "sortType", this.sortType);
        XMLHelper.addAttr(sb, "tableList", this.tableList);
        XMLHelper.addAttr(sb, "contextTableIdent", this.contextTableIdent);
        XMLHelper.addAttr(sb, "columnAlias", this.columnAlias);
        sb.append(" />\n");
    }

    protected void setValue(DBTableInfo tblInfo, String fieldToSetName, Object value) {
        try {
            String strVal;
            DBFieldInfo fldInfo = tblInfo.getFieldByName(fieldToSetName);
            String fieldSetterName = "set" + UploadTable.capitalize(fieldToSetName);
            Method fieldSetter = SpQueryField.class.getMethod(fieldSetterName, fldInfo.getDataClass());
            if (fldInfo.getDataClass().equals(String.class) && value != null && (strVal = (String)value).length() > fldInfo.getLength()) {
                fieldSetter.invoke((Object)this, ((String)value).substring(0, fldInfo.getLength()));
                return;
            }
            fieldSetter.invoke((Object)this, value);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpQueryField.class, ex);
            ex.printStackTrace();
        }
    }

    public void fromXML(Element element) {
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(this.getTableId());
        this.setValue(tblInfo, "position", XMLHelper.getAttr(element, "position", (short)0));
        this.setValue(tblInfo, "fieldName", XMLHelper.getAttr(element, "fieldName", null));
        this.setValue(tblInfo, "isNot", XMLHelper.getAttr(element, "isNot", false));
        this.setValue(tblInfo, "isDisplay", XMLHelper.getAttr(element, "isDisplay", false));
        this.setValue(tblInfo, "isPrompt", XMLHelper.getAttr(element, "isPrompt", false));
        this.setValue(tblInfo, "isRelFld", XMLHelper.getAttr(element, "isRelFld", false));
        this.setValue(tblInfo, "alwaysFilter", XMLHelper.getAttr(element, "alwaysFilter", false));
        this.setValue(tblInfo, "stringId", XMLHelper.getAttr(element, "stringId", null));
        this.setValue(tblInfo, "operStart", XMLHelper.getAttr(element, "operStart", (byte)0));
        this.setValue(tblInfo, "operEnd", XMLHelper.getAttr(element, "operEnd", (byte)0));
        if (this.operEnd == 0) {
            this.operEnd = null;
        }
        this.setValue(tblInfo, "startValue", XMLHelper.getAttr(element, "startValue", null));
        this.setValue(tblInfo, "endValue", XMLHelper.getAttr(element, "endValue", null));
        this.setValue(tblInfo, "sortType", XMLHelper.getAttr(element, "sortType", (byte)0));
        this.setValue(tblInfo, "tableList", XMLHelper.getAttr(element, "tableList", null));
        this.setValue(tblInfo, "contextTableIdent", XMLHelper.getAttr(element, "contextTableIdent", 0));
        this.setValue(tblInfo, "columnAlias", XMLHelper.getAttr(element, "columnAlias", null));
    }

    protected boolean eq(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    protected String nullIfBlank(String val) {
        if (StringUtils.isEmpty((String)val)) {
            return null;
        }
        return val;
    }

    protected Number nullIfZero(Number val) {
        if (val != null && val.equals(0)) {
            return null;
        }
        return val;
    }

    public boolean isEquivalent(Object obj) {
        if (obj instanceof SpQueryField) {
            SpQueryField f = (SpQueryField)obj;
            return this.fieldName.equals(f.fieldName) && this.isNot.equals(f.isNot) && this.isDisplay.equals(f.isDisplay) && this.isPrompt.equals(f.isPrompt) && this.alwaysFilter.equals(f.alwaysFilter) && this.eq(this.nullIfZero(this.operStart), this.nullIfZero(f.operStart)) && this.eq(this.nullIfZero(this.operEnd), this.nullIfZero(f.operEnd)) && this.eq(this.nullIfBlank(this.startValue), this.nullIfBlank(f.startValue)) && this.eq(this.nullIfBlank(this.endValue), this.nullIfBlank(f.endValue)) && this.eq(this.nullIfZero(this.sortType), this.nullIfZero(f.sortType)) && this.eq(this.nullIfBlank(this.tableList), this.nullIfBlank(f.tableList)) && this.eq(this.nullIfZero(this.contextTableIdent), this.nullIfZero(f.contextTableIdent)) && this.eq(this.nullIfBlank(this.columnAlias), this.nullIfBlank(f.columnAlias));
        }
        return false;
    }

    public static enum OperatorType {
        LIKE(0),
        EQUALS(1),
        GREATERTHAN(2),
        LESSTHAN(3),
        GREATERTHANEQUALS(4),
        LESSTHANEQUALS(5),
        TRUE(6),
        FALSE(7),
        DONTCARE(8),
        BETWEEN(9),
        IN(10),
        CONTAINS(11),
        EMPTY(12),
        TRUEORNULL(13),
        FALSEORNULL(14);

        private byte ord;
        private static final String[] names;

        static {
            names = new String[]{"Like", "=", ">", "<", ">=", "<=", UIRegistry.getResourceString("true"), UIRegistry.getResourceString("false"), " ", UIRegistry.getResourceString("QB_BETWEEN"), UIRegistry.getResourceString("QB_IN"), UIRegistry.getResourceString("QB_CONTAINS"), UIRegistry.getResourceString("QB_EMPTY"), UIRegistry.getResourceString("QB_TRUEORNULL"), UIRegistry.getResourceString("QB_FALSEORNULL")};
        }

        private OperatorType(int ord) {
            this.ord = (byte)ord;
        }

        public byte getOrdinal() {
            return this.ord;
        }

        public void set(byte ord) {
            this.ord = ord;
        }

        public static String getString(byte ord) {
            return names[ord];
        }

        public static byte getOrdForName(String name) {
            byte o = 0;
            while (o < names.length) {
                if (names[o].equals(name)) {
                    return o;
                }
                o = (byte)(o + 1);
            }
            return -1;
        }

        public String toString() {
            return names[this.ord];
        }

        public static OperatorType valueOf(String string) {
            return Enum.valueOf(OperatorType.class, string);
        }
    }

    public static enum SortType {
        NONE(0),
        ASC(1),
        DESC(2);

        private byte ord;

        private SortType(int ord) {
            this.ord = (byte)ord;
        }

        public byte getOrdinal() {
            return this.ord;
        }

        public void set(byte ord) {
            this.ord = ord;
        }

        public static String getString(byte ord) {
            String[] names = new String[]{"None", "Ascending", "Descending"};
            return names[ord];
        }

        public static SortType valueOf(String string) {
            return Enum.valueOf(SortType.class, string);
        }
    }
}

