/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpExportSchemaItemMapping;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spquery")
@Table(appliesTo="spquery", indexes={@Index(name="SpQueryNameIDX", columnNames={"Name"})})
public class SpQuery
extends DataModelObjBase
implements Cloneable {
    protected Integer spQueryId;
    protected String name;
    protected String contextName;
    protected Short contextTableId;
    protected String sqlStr;
    protected Boolean isFavorite;
    protected boolean named = true;
    protected Short ordinal;
    protected String remarks;
    protected Boolean selectDistinct;
    protected Boolean searchSynonymy;
    protected Boolean countOnly;
    protected Set<SpQueryField> fields;
    protected Set<SpReport> reports;
    protected SpecifyUser specifyUser;

    @Override
    public void initialize() {
        super.init();
        this.spQueryId = null;
        this.name = null;
        this.contextName = null;
        this.contextTableId = null;
        this.sqlStr = null;
        this.named = true;
        this.fields = new HashSet<SpQueryField>();
        this.reports = new HashSet<SpReport>();
        this.specifyUser = null;
        this.isFavorite = null;
        this.ordinal = null;
        this.remarks = null;
        this.selectDistinct = null;
        this.searchSynonymy = null;
        this.countOnly = null;
    }

    public void setSpQueryId(Integer spQueryId) {
        this.spQueryId = spQueryId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setContextTableId(Short contextTableId) {
        this.contextTableId = contextTableId;
    }

    public void setSqlStr(String sqlStr) {
        this.sqlStr = sqlStr;
    }

    public void setFields(Set<SpQueryField> fields) {
        this.fields = fields;
    }

    public void setSpecifyUser(SpecifyUser owner) {
        this.specifyUser = owner;
    }

    public void setReports(Set<SpReport> reports) {
        this.reports = reports;
    }

    public void setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public void setOrdinal(Short order) {
        this.ordinal = order;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Id
    @GeneratedValue
    @Column(name="SpQueryID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpQueryId() {
        return this.spQueryId;
    }

    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Column(name="ContextName", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getContextName() {
        return this.contextName;
    }

    @Column(name="ContextTableId", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getContextTableId() {
        return this.contextTableId;
    }

    @Lob
    @Column(name="SqlStr", length=4096)
    public String getSqlStr() {
        return this.sqlStr;
    }

    @Column(name="IsFavorite", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsFavorite() {
        return this.isFavorite;
    }

    @Transient
    public boolean isSelectDistinct() {
        return this.selectDistinct == null ? false : this.selectDistinct;
    }

    @Column(name="SelectDistinct", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getSelectDistinct() {
        return this.selectDistinct;
    }

    public void setSelectDistinct(Boolean selectDistinct) {
        this.selectDistinct = selectDistinct;
    }

    @Column(name="SearchSynonymy", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getSearchSynonymy() {
        return this.searchSynonymy;
    }

    public void setSearchSynonymy(Boolean searchSynonymy) {
        this.searchSynonymy = searchSynonymy;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Column(name="CountOnly", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getCountOnly() {
        return this.countOnly;
    }

    public void setCountOnly(Boolean countOnly) {
        this.countOnly = countOnly;
    }

    @Column(name="Ordinal", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getOrdinal() {
        return this.ordinal != null ? this.ordinal : (short)Short.MAX_VALUE;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="query")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpQueryField> getFields() {
        return this.fields;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="query")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpReport> getReports() {
        return this.reports;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpecifyUserID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpecifyUser getSpecifyUser() {
        return this.specifyUser;
    }

    public void forceLoad(boolean forceReports) {
        for (SpQueryField qf : this.getFields()) {
            qf.getFieldName();
        }
        this.getSpecifyUser();
        if (forceReports) {
            for (SpReport r : this.getReports()) {
                r.forceLoad();
            }
        }
    }

    @Override
    public void forceLoad() {
        this.forceLoad(false);
    }

    public void toXML(StringBuilder sb) {
        sb.append("<query ");
        XMLHelper.addAttr(sb, "name", this.name);
        XMLHelper.addAttr(sb, "contextName", this.contextName);
        XMLHelper.addAttr(sb, "contextTableId", this.contextTableId);
        XMLHelper.addAttr(sb, "isFavorite", this.isFavorite);
        XMLHelper.addAttr(sb, "named", this.named);
        XMLHelper.addAttr(sb, "ordinal", this.ordinal);
        sb.append(">\r\n");
        if (this.sqlStr != null) {
            sb.append("<sqlStr><![CDATA[");
            sb.append(this.sqlStr);
            sb.append("]]></sqlStr>\r\n");
        }
        sb.append("<fields>");
        for (SpQueryField field : this.fields) {
            field.toXML(sb);
        }
        sb.append("</fields>\r\n");
        SpExportSchemaMapping mapping = this.getMapping();
        if (mapping != null) {
            mapping.toXML(sb);
        }
        sb.append("</query>\r\n");
    }

    public void fromXML(Element element) {
        this.name = XMLHelper.getAttr(element, "name", null);
        this.contextName = XMLHelper.getAttr(element, "contextName", null);
        this.contextTableId = XMLHelper.getAttr(element, "contextTableId", (short)0);
        this.isFavorite = XMLHelper.getAttr(element, "isFavorite", false);
        this.named = XMLHelper.getAttr(element, "named", false);
        this.ordinal = XMLHelper.getAttr(element, "ordinal", (short)0);
        Element sqlNode = (Element)element.selectSingleNode("sqlStr");
        this.sqlStr = sqlNode != null ? sqlNode.getTextTrim() : null;
        for (Object obj : element.selectNodes("fields/field")) {
            Element fieldEl = (Element)obj;
            SpQueryField field = new SpQueryField();
            field.initialize();
            field.fromXML(fieldEl);
            field.setQuery(this);
            this.fields.add(field);
        }
        Element mapping = (Element)element.selectSingleNode("spexportschemamapping");
        if (mapping != null) {
            SpExportSchemaMapping esm = new SpExportSchemaMapping();
            esm.initialize();
            esm.fromXML(mapping, this);
        }
    }

    @Transient
    public SpExportSchemaMapping getMapping() {
        for (SpQueryField field : this.fields) {
            SpExportSchemaItemMapping mapItem = field.getMapping();
            if (mapItem == null) continue;
            return mapItem.getExportSchemaMapping();
        }
        return null;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpQuery.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spQueryId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpQuery.getClassTableId();
    }

    public static int getClassTableId() {
        return 517;
    }

    @Transient
    public boolean isNamed() {
        return this.named;
    }

    public void setNamed(boolean named) {
        this.named = named;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpQuery query = (SpQuery)super.clone();
        query.spQueryId = null;
        this.fields = new HashSet<SpQueryField>();
        for (SpQueryField field : this.fields) {
            SpQueryField fld = (SpQueryField)field.clone();
            fld.setQuery(query);
            query.fields.add(fld);
        }
        return query;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.getName();
    }

    public boolean isEquivalent(SpQuery q) {
        if (!this.contextTableId.equals(q.getContextTableId())) {
            return false;
        }
        if (this.fields.size() != q.fields.size()) {
            return false;
        }
        Vector<SpQueryField> theseFields = new Vector<SpQueryField>(this.fields);
        Vector<SpQueryField> thoseFields = new Vector<SpQueryField>(q.fields);
        Collections.sort(theseFields);
        Collections.sort(thoseFields);
        int f = 0;
        while (f < theseFields.size()) {
            if (!theseFields.get(f).isEquivalent(thoseFields.get(f))) {
                return false;
            }
            ++f;
        }
        return true;
    }
}

