/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="spprincipal")
public class SpPrincipal
extends DataModelObjBase
implements Serializable,
Principal,
Comparable<SpPrincipal> {
    protected Integer spUserGroupId;
    protected String name;
    protected String groupType;
    protected String remarks;
    protected String groupSubClass;
    protected Byte priority;
    protected UserGroupScope scope;
    protected Set<SpecifyUser> specifyUsers;
    protected Set<SpPermission> permissions;

    public SpPrincipal() {
    }

    public SpPrincipal(Integer userGroupId) {
        this.spUserGroupId = userGroupId;
    }

    @Override
    public void initialize() {
        super.init();
        this.spUserGroupId = null;
        this.name = null;
        this.remarks = null;
        this.priority = null;
        this.groupSubClass = null;
        this.scope = null;
        this.specifyUsers = new HashSet<SpecifyUser>();
        this.permissions = new HashSet<SpPermission>();
    }

    @Id
    @GeneratedValue
    @Column(name="SpPrincipalID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getUserGroupId() {
        return this.spUserGroupId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spUserGroupId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpPrincipal.class;
    }

    public void setUserGroupId(Integer userGroupId) {
        this.spUserGroupId = userGroupId;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Lob
    @Column(name="Remarks", unique=false, nullable=true, updatable=true, insertable=true)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Priority", unique=false, nullable=false, updatable=true, insertable=true)
    public Byte getPriority() {
        return this.priority;
    }

    public void setPriority(Byte priority) {
        this.priority = priority;
    }

    public void setPriority(int priority) {
        this.priority = (byte)priority;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spPrincipals")
    public Set<SpecifyUser> getSpecifyUsers() {
        return this.specifyUsers;
    }

    public void setSpecifyUsers(Set<SpecifyUser> specifyUsers) {
        this.specifyUsers = specifyUsers;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpPrincipal.getClassTableId();
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public static int getClassTableId() {
        return 522;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        if (this.name != null) {
            return this.name;
        }
        return "Undefined";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SpPrincipal)) {
            return false;
        }
        SpPrincipal other = (SpPrincipal)obj;
        return this.getName().equals(other.getName());
    }

    @Override
    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className.substring(className.lastIndexOf(46) + 1)) + ": " + this.name + " [" + this.getName() + "]";
    }

    @Column(name="GroupSubClass", nullable=false, insertable=true, updatable=true, length=255)
    public String getGroupSubClass() {
        return this.groupSubClass;
    }

    public void setGroupSubClass(String groupClass) {
        this.groupSubClass = groupClass;
    }

    @ManyToMany(mappedBy="principals")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<SpPermission> permissions) {
        this.permissions = permissions;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="userGroupScopeID", unique=false, nullable=true, insertable=true, updatable=true)
    public UserGroupScope getScope() {
        return this.scope;
    }

    public void setScope(UserGroupScope scope) {
        this.scope = scope;
    }

    @Column(name="groupType", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getGroupType() {
        return this.groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    @Transient
    public static Integer getUserGroupScopeFromPrincipal(Integer principalId) {
        String sql = "SELECT userGroupScopeID FROM spprincipal WHERE SpPrincipalID = " + principalId;
        System.out.println(sql);
        return principalId == null ? null : BasicSQLUtils.getCount(sql);
    }

    @Override
    public int compareTo(SpPrincipal obj) {
        if (this.priority != null && obj != null && obj.priority != null) {
            if (this.priority < 80) {
                if (this.name != null && obj != null && StringUtils.isNotEmpty((String)obj.name)) {
                    return this.name.compareTo(obj.name);
                }
            } else if (this.priority != null && obj != null && obj.priority != null) {
                return this.priority.compareTo(obj.priority);
            }
        }
        return this.timestampCreated != null && obj != null && obj.timestampCreated != null ? this.timestampCreated.compareTo(obj.timestampCreated) : 0;
    }
}

