/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.SpPrincipal;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="sppermission")
public class SpPermission
implements Serializable {
    protected Integer permissionId;
    protected String permissionClass;
    protected String name;
    protected String actions;
    protected Integer targetId;
    protected Set<SpPrincipal> principals;
    protected boolean hasChanged = false;

    public SpPermission() {
    }

    public SpPermission(Integer permissionId) {
        this.permissionId = permissionId;
    }

    @Id
    @GeneratedValue
    @Column(name="SpPermissionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getPermissionId() {
        return this.permissionId;
    }

    public void initialize() {
        this.permissionId = null;
        this.permissionClass = null;
        this.name = null;
        this.actions = null;
        this.principals = new HashSet<SpPrincipal>();
    }

    @Transient
    public Class<?> getDataClass() {
        return SpPermission.class;
    }

    @Column(name="Actions", unique=false, nullable=true, insertable=true, updatable=true, length=256)
    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="TargetId", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Integer targetId) {
        this.targetId = targetId;
    }

    @Column(name="PermissionClass", unique=false, nullable=false, insertable=true, updatable=true, length=256)
    public String getPermissionClass() {
        return this.permissionClass;
    }

    public void setPermissionClass(String permissionClass) {
        this.permissionClass = permissionClass;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    @Transient
    public Integer getId() {
        return this.permissionId;
    }

    @Transient
    public int getTableId() {
        return SpPermission.getClassTableId();
    }

    public static int getClassTableId() {
        return 103;
    }

    @Transient
    public String getIdentityTitle() {
        return "Undefined";
    }

    public void setPermissionId(Integer permissionId) {
        this.permissionId = permissionId;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY)
    @JoinTable(name="spprincipal_sppermission", joinColumns={@JoinColumn(name="SpPermissionID", unique=false, nullable=false, insertable=true, updatable=false)}, inverseJoinColumns={@JoinColumn(name="SpPrincipalID", unique=false, nullable=false, insertable=true, updatable=false)})
    public Set<SpPrincipal> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Set<SpPrincipal> principals) {
        this.principals = principals;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(SpPermission other) {
        if (this.permissionId == null) {
            return super.equals(other);
        }
        return this.permissionId.equals(other.permissionId);
    }

    public boolean hasAction(String action) {
        return this.actions != null && this.actions.indexOf(action) >= 0;
    }

    public boolean canView() {
        return this.actions != null && this.actions.indexOf("view") >= 0;
    }

    public boolean canAdd() {
        return this.actions != null && this.actions.indexOf("add") >= 0;
    }

    public boolean canModify() {
        return this.actions != null && this.actions.indexOf("modify") >= 0;
    }

    public boolean canDelete() {
        return this.actions != null && this.actions.indexOf("delete") >= 0;
    }

    public boolean hasSameFlags(boolean canView, boolean canAdd, boolean canModify, boolean canDelete) {
        return canView == this.canView() && canAdd == this.canAdd() && canModify == this.canModify() && canDelete == this.canDelete();
    }

    public void setActions(boolean canView, boolean canAdd, boolean canModify, boolean canDelete) {
        String newActions = "";
        String sep = "";
        if (canView) {
            newActions = String.valueOf(newActions) + "view";
            sep = ",";
        }
        if (canAdd) {
            newActions = String.valueOf(newActions) + sep + "add";
            sep = ",";
        }
        if (canModify) {
            newActions = String.valueOf(newActions) + sep + "modify";
            sep = ",";
        }
        if (canDelete) {
            newActions = String.valueOf(newActions) + sep + "delete";
            sep = ",";
        }
        this.hasChanged = this.actions == null || !newActions.equals(this.actions);
        this.actions = newActions;
    }
}

