/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="splocaleitemstr")
@Table(appliesTo="splocaleitemstr", indexes={@Index(name="SpLocaleLanguageIDX", columnNames={"Language"}), @Index(name="SpLocaleCountyIDX", columnNames={"Country"})})
public class SpLocaleItemStr
extends DataModelObjBase
implements LocalizableStrIFace {
    private static final Logger log = Logger.getLogger(SpLocaleItemStr.class);
    protected Integer spLocaleItemStrId;
    protected String language;
    protected String country;
    protected String variant;
    protected String text;
    protected SpLocaleContainer containerDesc;
    protected SpLocaleContainer containerName;
    protected SpLocaleContainerItem itemDesc;
    protected SpLocaleContainerItem itemName;

    public SpLocaleItemStr() {
    }

    public SpLocaleItemStr(String text, Locale locale) {
        this.initialize();
        this.text = text;
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
        this.variant = locale.getVariant();
    }

    @Override
    public void initialize() {
        super.init();
        this.spLocaleItemStrId = null;
        this.language = null;
        this.country = null;
        this.variant = null;
        this.text = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpLocaleItemStrID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpLocaleItemStrId() {
        return this.spLocaleItemStrId;
    }

    public void setSpLocaleItemStrId(Integer localeItemStrId) {
        this.spLocaleItemStrId = localeItemStrId;
    }

    @Override
    @Column(name="Text", unique=false, nullable=false, insertable=true, updatable=true, length=255)
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        if (text != null && text.length() > 255) {
            log.error((Object)("String len: " + text.length() + " is > 255 [" + text + "]"));
            this.text = text.substring(0, 255);
        } else {
            this.text = text;
        }
    }

    @Override
    @Column(name="Country", unique=false, nullable=true, insertable=true, updatable=true, length=2)
    public String getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    @Column(name="Language", unique=false, nullable=false, insertable=true, updatable=true, length=2)
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    @Column(name="Variant", unique=false, nullable=true, insertable=true, updatable=true, length=2)
    public String getVariant() {
        return this.variant;
    }

    @Override
    public void setVariant(String variant) {
        this.variant = variant;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpLocaleContainerDescID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpLocaleContainer getContainerDesc() {
        return this.containerDesc;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpLocaleContainerNameID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpLocaleContainer getContainerName() {
        return this.containerName;
    }

    public void setContainerDesc(SpLocaleContainer containerDesc) {
        this.containerDesc = containerDesc;
    }

    public void setContainerName(SpLocaleContainer containerName) {
        this.containerName = containerName;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpLocaleContainerItemDescID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpLocaleContainerItem getItemDesc() {
        return this.itemDesc;
    }

    public void setItemDesc(SpLocaleContainerItem itemDesc) {
        this.itemDesc = itemDesc;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpLocaleContainerItemNameID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpLocaleContainerItem getItemName() {
        return this.itemName;
    }

    public void setItemName(SpLocaleContainerItem itemName) {
        this.itemName = itemName;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpLocaleItemStr.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spLocaleItemStrId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpLocaleItemStr.getClassTableId();
    }

    public static int getClassTableId() {
        return 505;
    }

    @Override
    @Transient
    public boolean isLocale(Locale locale) {
        return !(!this.language.equals(locale.getLanguage()) || this.country != null && !this.country.equals(locale.getCountry()) || this.variant != null && !this.variant.equals(locale.getVariant()));
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }
}

