/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.SpExportSchemaItem;
import edu.ku.brc.specify.datamodel.SpLocaleBase;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpLocaleItemStr;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="splocalecontaineritem")
@Table(appliesTo="splocalecontaineritem", indexes={@Index(name="SpLocaleContainerItemNameIDX", columnNames={"Name"})})
public class SpLocaleContainerItem
extends SpLocaleBase
implements LocalizableItemIFace,
Comparable<SpLocaleContainerItem> {
    private static final Logger log = Logger.getLogger(SpLocaleContainerItem.class);
    protected Integer spLocaleContainerItemId;
    protected SpLocaleContainer container;
    protected Set<SpLocaleItemStr> names;
    protected Set<SpLocaleItemStr> descs;
    protected Set<SpExportSchemaItem> spExportSchemaItems;
    protected String webLinkName;
    protected Boolean isRequired;

    @Id
    @GeneratedValue
    @Column(name="SpLocaleContainerItemID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpLocaleContainerItemId() {
        return this.spLocaleContainerItemId;
    }

    public void setSpLocaleContainerItemId(Integer localeContainerItemId) {
        this.spLocaleContainerItemId = localeContainerItemId;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.spLocaleContainerItemId = null;
        this.names = new HashSet<SpLocaleItemStr>();
        this.descs = new HashSet<SpLocaleItemStr>();
        this.spExportSchemaItems = new HashSet<SpExportSchemaItem>();
        this.isRequired = false;
        this.container = null;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="itemDesc")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpLocaleItemStr> getDescs() {
        return this.descs;
    }

    public void setDescs(Set<SpLocaleItemStr> descs) {
        this.descs = descs;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="itemName")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpLocaleItemStr> getNames() {
        return this.names;
    }

    public void setNames(Set<SpLocaleItemStr> names) {
        this.names = names;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpLocaleContainerID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpLocaleContainer getContainer() {
        return this.container;
    }

    public void setContainer(SpLocaleContainer container) {
        this.container = container;
    }

    @Override
    @Column(name="WebLinkName", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getWebLinkName() {
        return this.webLinkName;
    }

    @Override
    public void setWebLinkName(String webLinkName) {
        this.webLinkName = webLinkName;
    }

    @Override
    @Column(name="IsRequired", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public Boolean getIsRequired() {
        return this.isRequired == null ? false : this.isRequired;
    }

    @Override
    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spLocaleContainerItem")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpExportSchemaItem> getSpExportSchemaItems() {
        return this.spExportSchemaItems;
    }

    public void setSpExportSchemaItems(Set<SpExportSchemaItem> spExportSchemaItems) {
        this.spExportSchemaItems = spExportSchemaItems;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpLocaleContainerItem.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spLocaleContainerItemId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpLocaleContainerItem.getClassTableId();
    }

    public static int getClassTableId() {
        return 504;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void fillDescs(List<LocalizableStrIFace> descsArg) {
        descsArg.clear();
        descsArg.addAll(this.descs);
    }

    @Override
    public void fillNames(List<LocalizableStrIFace> namesArg) {
        namesArg.clear();
        namesArg.addAll(this.names);
    }

    @Override
    public void addDesc(LocalizableStrIFace str) {
        if (str != null && str instanceof SpLocaleItemStr) {
            SpLocaleItemStr strItem = (SpLocaleItemStr)str;
            strItem.setItemDesc(this);
            this.descs.add(strItem);
        } else {
            log.error((Object)"LocalizableStrIFace was null or not of Class SpLocaleItemStr");
        }
    }

    @Override
    public void addName(LocalizableStrIFace str) {
        if (str != null && str instanceof SpLocaleItemStr) {
            SpLocaleItemStr strItem = (SpLocaleItemStr)str;
            strItem.setItemName(this);
            this.names.add(strItem);
        } else {
            log.error((Object)"LocalizableStrIFace was null or not of Class SpLocaleItemStr");
        }
    }

    @Override
    public void removeDesc(LocalizableStrIFace str) {
        if (str != null && str instanceof SpLocaleItemStr) {
            this.descs.remove(str);
        } else {
            log.error((Object)"LocalizableStrIFace was null or not of Class SpLocaleItemStr");
        }
    }

    @Override
    public void removeName(LocalizableStrIFace str) {
        if (str != null && str instanceof SpLocaleItemStr) {
            this.names.remove((SpLocaleItemStr)str);
        } else {
            log.error((Object)"LocalizableStrIFace was null or not of Class SpLocaleItemStr");
        }
    }

    @Override
    public int compareTo(SpLocaleContainerItem obj) {
        return this.name != null && obj != null && obj.getName() != null ? this.name.compareTo(obj.getName()) : 0;
    }

    @Override
    @Transient
    public Set<SpLocaleItemStr> getNamesSet() {
        return this.names;
    }

    @Override
    @Transient
    public Set<SpLocaleItemStr> getDescsSet() {
        return this.descs;
    }
}

